/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class BuilderFromHapMap {
    private static final Logger myLogger = Logger.getLogger(BuilderFromHapMap.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;
    private static final int SNPID_INDEX = 0;
    private static final int VARIANT_INDEX = 1;
    private static final int CHROMOSOME_INDEX = 2;
    private static final int POSITION_INDEX = 3;
    private static final int NUM_VALUES_PROCESSED_TOGETHER = 0x700000;
    private final String myHapmapFile;
    private boolean mySortTaxaAlphabetically = false;
    private boolean mySortPositions = false;
    private final ProgressListener myProgressListener;

    private BuilderFromHapMap(String hapmapFile, ProgressListener listener) {
        this.myHapmapFile = hapmapFile;
        this.myProgressListener = listener;
    }

    public static BuilderFromHapMap getBuilder(String hapmapFile) {
        return new BuilderFromHapMap(hapmapFile, null);
    }

    public static BuilderFromHapMap getBuilder(String hapmapFile, ProgressListener listener) {
        return new BuilderFromHapMap(hapmapFile, listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenotypeTable build() {
        ExecutorService pool = null;
        try (BufferedReader reader = Utils.getBufferedReader(this.myHapmapFile, 0x100000);){
            ProcessHapmapBlock processBlock;
            TreeMap<String, SetMultimap<String, String>> sampAnnoBuild = new TreeMap<String, SetMultimap<String, String>>();
            String currLine = reader.readLine();
            while (currLine != null && currLine.startsWith("##")) {
                SetMultimap<String, String> mapOfAnno;
                String taxaID;
                String[] cat = currLine.split("=", 2);
                if (cat.length < 2) continue;
                if (cat[0].startsWith("##SAMPLE") && (taxaID = (String)(mapOfAnno = TaxaListIOUtils.parseVCFHeadersIntoMap(cat[1])).get((Object)"ID").iterator().next()) != null) {
                    sampAnnoBuild.put(taxaID, mapOfAnno);
                }
                currLine = reader.readLine();
            }
            TaxaListBuilder taxaList = BuilderFromHapMap.processTaxa(currLine, sampAnnoBuild);
            int numTaxa = taxaList.numberOfTaxa();
            ConcurrentHashMap<String, Chromosome> chromosomeLookup = new ConcurrentHashMap<String, Chromosome>();
            currLine = reader.readLine();
            boolean isOneLetter = false;
            String[] tokens = WHITESPACE_PATTERN.split(currLine, 12);
            if (tokens.length <= 11) {
                throw new IllegalStateException("BuilderFromHapMap: Header Incorrectly Formatted: See:\nhttps://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/Load/Load#markdown-header-hapmap");
            }
            double avg = (double)(tokens[11].length() + 1) / (double)numTaxa;
            if (avg > 1.99 && avg < 2.01) {
                isOneLetter = true;
            } else {
                if (!(avg > 2.99)) throw new IllegalStateException("BuilderFromHapMap: Genotype coded wrong use 1 or 2 letters per genotype.  Or first site has incorrect number of values.");
                if (!(avg < 3.01)) throw new IllegalStateException("BuilderFromHapMap: Genotype coded wrong use 1 or 2 letters per genotype.  Or first site has incorrect number of values.");
                isOneLetter = false;
            }
            int numThreads = Runtime.getRuntime().availableProcessors();
            pool = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<ProcessHapmapBlock>> futures = new ArrayList<Future<ProcessHapmapBlock>>();
            int numSitesToProcessTogether = 0x700000 / numTaxa;
            numSitesToProcessTogether = Math.min(65536, numSitesToProcessTogether);
            numSitesToProcessTogether = Math.max(512, numSitesToProcessTogether);
            ArrayList<String> textLines = new ArrayList<String>(numSitesToProcessTogether);
            int numLines = 0;
            while (currLine != null) {
                textLines.add(currLine);
                if (++numLines % numSitesToProcessTogether == 0) {
                    processBlock = new ProcessHapmapBlock(textLines, numTaxa, chromosomeLookup, isOneLetter);
                    futures.add(pool.submit(processBlock));
                    textLines = new ArrayList(numSitesToProcessTogether);
                }
                currLine = reader.readLine();
            }
            if (textLines.size() > 0) {
                processBlock = new ProcessHapmapBlock(textLines, numTaxa, chromosomeLookup, isOneLetter);
                futures.add(pool.submit(processBlock));
            }
            int currentSite = 0;
            PositionListBuilder positions = new PositionListBuilder();
            GenotypeCallTableBuilder genotypes = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(numTaxa, numLines);
            int numFutures = futures.size();
            int count = 0;
            Object genotypeTable = futures.iterator();
            while (true) {
                SuperByteMatrix bgTS;
                ProcessHapmapBlock pb;
                if (genotypeTable.hasNext()) {
                    Future future = (Future)genotypeTable.next();
                    pb = (ProcessHapmapBlock)future.get();
                    positions.addAll(pb.getPositions());
                    bgTS = pb.getGenotypes();
                } else {
                    pool.shutdown();
                    if (this.mySortTaxaAlphabetically) {
                        taxaList.sortTaxaAlphabetically(genotypes);
                    }
                    if (this.mySortPositions) {
                        positions.sortPositions(genotypes);
                    }
                    if (!positions.validateOrdering()) {
                        throw new IllegalStateException("BuilderFromHapMap: Ordering incorrect. HapMap must be ordered by position. Please first use SortGenotypeFilePlugin to correctly order the file.");
                    }
                    genotypeTable = GenotypeTableBuilder.getInstance(genotypes.build(), positions.build(), taxaList.build());
                    return genotypeTable;
                }
                for (int t = 0; t < bgTS.getNumRows(); ++t) {
                    for (int s = 0; s < bgTS.getNumColumns(); ++s) {
                        genotypes.setBase(t, currentSite + s, bgTS.get(t, s));
                    }
                }
                currentSite += pb.getNumberSitesProcessed();
                if (this.myProgressListener == null) continue;
                this.myProgressListener.progress(++count * 100 / numFutures, null);
            }
        }
        catch (Exception e) {
            if (pool != null) {
                pool.shutdown();
            }
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    static TaxaListBuilder processTaxa(String readLn, Map<String, SetMultimap<String, String>> taxaAnnotation) {
        String[] header = WHITESPACE_PATTERN.split(readLn);
        int numTaxa = header.length - 11;
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (int i = 0; i < numTaxa; ++i) {
            String taxonID = header[i + 11];
            Taxon.Builder at = new Taxon.Builder(taxonID);
            SetMultimap<String, String> taMap = taxaAnnotation.get(taxonID);
            if (taMap != null) {
                for (Map.Entry en : taMap.entries()) {
                    if (((String)en.getKey()).equals("ID")) continue;
                    String s = ((String)en.getValue()).replace("\"", "");
                    at.addAnno((String)en.getKey(), s);
                }
            }
            tlb.add(at.build());
        }
        return tlb;
    }

    public BuilderFromHapMap sortTaxa() {
        this.mySortTaxaAlphabetically = true;
        return this;
    }

    public BuilderFromHapMap sortPositions() {
        this.mySortPositions = true;
        return this;
    }

    private class ProcessHapmapBlock
    implements Callable<ProcessHapmapBlock> {
        private List<String> myInputLines;
        private final Map<String, Chromosome> myChromosomeLookup;
        private final boolean myIsOneLetter;
        private final List<Position> myPositionList;
        private final int myNumSitesToProcess;
        private final int myNumTaxa;
        private SuperByteMatrix myGenotypes;

        public ProcessHapmapBlock(List<String> inputLines, int numTaxa, Map<String, Chromosome> chromosomeLookup, boolean isOneLetter) {
            this.myInputLines = inputLines;
            this.myChromosomeLookup = chromosomeLookup;
            this.myNumTaxa = numTaxa;
            this.myIsOneLetter = isOneLetter;
            this.myNumSitesToProcess = inputLines.size();
            this.myPositionList = new ArrayList<Position>(this.myNumSitesToProcess);
        }

        @Override
        public ProcessHapmapBlock call() throws Exception {
            this.myGenotypes = SuperByteMatrixBuilder.getInstance(this.myNumTaxa, this.myNumSitesToProcess);
            for (int site = 0; site < this.myNumSitesToProcess; ++site) {
                String input = this.myInputLines.get(site);
                try {
                    byte value;
                    int i;
                    int physicalPos;
                    int[] tabPos = new int[11];
                    int tabIndex = 0;
                    int len = input.length();
                    for (int i2 = 0; tabIndex < 11 && i2 < len; ++i2) {
                        if (input.charAt(i2) != '\t') continue;
                        tabPos[tabIndex++] = i2;
                    }
                    String chrName = input.substring(tabPos[1] + 1, tabPos[2]);
                    Chromosome currChr = this.myChromosomeLookup.get(chrName);
                    if (currChr == null) {
                        currChr = new Chromosome(new String(chrName));
                        this.myChromosomeLookup.put(chrName, currChr);
                    }
                    String variants = input.substring(tabPos[0] + 1, tabPos[1]);
                    try {
                        physicalPos = Integer.parseInt(input.substring(tabPos[2] + 1, tabPos[3]));
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("BuilderFromHapMap: Position must be an integer: " + input.substring(tabPos[2] + 1, tabPos[3]).trim());
                    }
                    GeneralPosition.Builder apb = new GeneralPosition.Builder(currChr, physicalPos).snpName(input.substring(0, tabPos[0])).knownVariants(variants);
                    byte glbMajor = NucleotideAlignmentConstants.getNucleotideDiploidByte(variants.charAt(0));
                    apb.allele(WHICH_ALLELE.GlobalMajor, glbMajor);
                    if (variants.length() == 3) {
                        byte glbMinor = NucleotideAlignmentConstants.getNucleotideDiploidByte(variants.charAt(2));
                        apb.allele(WHICH_ALLELE.GlobalMinor, glbMinor);
                    }
                    this.myPositionList.add(apb.build());
                    int offset = tabPos[10] + 1;
                    int taxon = 0;
                    if (this.myIsOneLetter) {
                        for (i = offset; i < len; i += 2) {
                            if (taxon >= this.myNumTaxa) {
                                throw new IllegalStateException("BuilderFromHapMap: SNP Named: " + this.myPositionList.get(this.myPositionList.size() - 1).getSNPID() + " has too many values.");
                            }
                            value = NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i));
                            if (value == 102) {
                                throw new IllegalStateException("BuilderFromHapMap: SNP Named: " + this.myPositionList.get(this.myPositionList.size() - 1).getSNPID() + " has illegal value: " + input.charAt(i));
                            }
                            this.myGenotypes.set(taxon++, site, value);
                        }
                    } else {
                        for (i = offset; i < len; i += 3) {
                            if (taxon >= this.myNumTaxa) {
                                throw new IllegalStateException("BuilderFromHapMap: SNP Named: " + this.myPositionList.get(this.myPositionList.size() - 1).getSNPID() + " has too many values.");
                            }
                            value = GenotypeTableUtils.getDiploidValue(NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i + 1)), NucleotideAlignmentConstants.getNucleotideDiploidByte(input.charAt(i)));
                            if (value == 102) {
                                throw new IllegalStateException("BuilderFromHapMap: SNP Named: " + this.myPositionList.get(this.myPositionList.size() - 1).getSNPID() + " has illegal value: " + input.charAt(i) + input.charAt(i + 1));
                            }
                            this.myGenotypes.set(taxon++, site, value);
                        }
                    }
                    if (taxon != this.myNumTaxa) {
                        throw new IllegalStateException("BuilderFromHapMap: SNP Named: " + this.myPositionList.get(this.myPositionList.size() - 1).getSNPID() + " has too few values.");
                    }
                    this.swapSitesIfOutOfOrder(site);
                    continue;
                }
                catch (Exception e) {
                    myLogger.error((Object)("Error parsing this row " + input));
                    myLogger.debug((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("BuilderFromHapMap: Error Parsing Line: " + input.substring(0, Math.min(25, input.length())) + "...\n" + e.getMessage());
                }
            }
            this.myInputLines = null;
            return this;
        }

        private void swapSitesIfOutOfOrder(int site) {
            if (site < 1) {
                return;
            }
            if (this.myPositionList.get(site - 1).compareTo(this.myPositionList.get(site)) > 0) {
                Position tempP = this.myPositionList.get(site - 1);
                myLogger.warn((Object)("Swapping:" + tempP.toString() + " <-> " + this.myPositionList.get(site).toString()));
                this.myPositionList.set(site - 1, this.myPositionList.get(site));
                this.myPositionList.set(site, tempP);
                for (int t = 0; t < this.myGenotypes.getNumRows(); ++t) {
                    byte tempG = this.myGenotypes.get(t, site - 1);
                    this.myGenotypes.set(t, site - 1, this.myGenotypes.get(t, site));
                    this.myGenotypes.set(t, site, tempG);
                }
            }
        }

        public int getNumberSitesProcessed() {
            return this.myNumSitesToProcess;
        }

        public SuperByteMatrix getGenotypes() {
            return this.myGenotypes;
        }

        public List<Position> getPositions() {
            return this.myPositionList;
        }
    }
}

