/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.snp.score.AlleleDepthBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class BuilderFromVCFUsingHTSJDK {
    private static final Logger myLogger = Logger.getLogger(BuilderFromVCFUsingHTSJDK.class);
    private static final int NUM_VARIANT_CONTEXT_PER_THREAD = 100;
    private final VCFFileReader myReader;
    private final VCFHeader myHeader;
    private final Iterator<VariantContext> myVariants;
    private final TaxaList myTaxa;
    private boolean myKeepDepth = true;
    private ProgressListener myProgressListener = null;

    private BuilderFromVCFUsingHTSJDK(String vcf) {
        File vcfFile = new File(vcf);
        if (!vcfFile.isFile()) {
            throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: init: file doesn't exist: " + vcf);
        }
        this.myReader = new VCFFileReader(vcfFile, false);
        this.myHeader = this.myReader.getFileHeader();
        this.myVariants = this.myReader.iterator();
        this.myTaxa = this.taxa();
    }

    private BuilderFromVCFUsingHTSJDK(VCFHeader header, Iterator<VariantContext> variants) {
        this.myReader = null;
        this.myHeader = header;
        this.myVariants = variants;
        this.myTaxa = this.taxa();
    }

    private TaxaList taxa() {
        return this.myHeader.getGenotypeSamples().stream().map(name -> new Taxon((String)name)).collect(TaxaList.collect());
    }

    private void close() {
        try {
            if (this.myVariants instanceof CloseableIterator) {
                ((CloseableIterator)this.myVariants).close();
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (this.myReader != null) {
                this.myReader.close();
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static BuilderFromVCFUsingHTSJDK instance(String vcf) {
        return new BuilderFromVCFUsingHTSJDK(vcf);
    }

    public static BuilderFromVCFUsingHTSJDK instance(VCFHeader header, Iterator<VariantContext> variants) {
        return new BuilderFromVCFUsingHTSJDK(header, variants);
    }

    public static BuilderFromVCFUsingHTSJDK instance(VCFHeader header, List<VariantContext> variants) {
        return new BuilderFromVCFUsingHTSJDK(header, variants.iterator());
    }

    public static GenotypeTable read(String vcf) {
        return new BuilderFromVCFUsingHTSJDK(vcf).build();
    }

    public static GenotypeTable read(VCFHeader header, List<VariantContext> variants) {
        return new BuilderFromVCFUsingHTSJDK(header, variants.iterator()).build();
    }

    public BuilderFromVCFUsingHTSJDK progressListener(ProgressListener listener) {
        this.myProgressListener = listener;
        return this;
    }

    public BuilderFromVCFUsingHTSJDK keepDepth(boolean keep) {
        this.myKeepDepth = keep;
        return this;
    }

    public GenotypeTable build() {
        ForkJoinPool threadPool = ForkJoinPool.commonPool();
        int numTaxa = this.myTaxa.numberOfTaxa();
        try {
            Object object;
            ArrayList<Future> futures = new ArrayList<Future>();
            PositionListBuilder positionListBuilder = new PositionListBuilder();
            ArrayList<Object> contextsToProcess = new ArrayList<VariantContext>();
            int numContextsToProcess = 0;
            ArrayList<Tuple<Integer, Short>> positionsToProcess = new ArrayList<Tuple<Integer, Short>>();
            int previousEnd = -1;
            GeneralPosition previousPosition = null;
            Chromosome previousChromosome = null;
            while (this.myVariants.hasNext()) {
                GeneralPosition pos;
                GeneralPosition.Builder posBuilder;
                int position;
                List possibleAlleles;
                List<String> knownVariants;
                short maxLength;
                ++numContextsToProcess;
                VariantContext context = this.myVariants.next();
                if (context.getGenotypes() instanceof LazyGenotypesContext) {
                    ((LazyGenotypesContext)context.getGenotypes()).decode();
                }
                Chromosome chr = Chromosome.instance(context.getContig());
                if (previousChromosome == null) {
                    previousChromosome = chr;
                }
                if (!chr.equals(previousChromosome)) {
                    previousChromosome = chr;
                    previousEnd = -1;
                    previousPosition = null;
                    ProcessVariantContext process = new ProcessVariantContext(contextsToProcess, numTaxa, positionsToProcess);
                    futures.add(threadPool.submit((Callable)process));
                    numContextsToProcess = 0;
                    positionsToProcess = new ArrayList();
                    contextsToProcess = new ArrayList();
                }
                int start = context.getStart();
                int end = context.getEnd();
                int refLength = context.getLengthOnReference();
                if (refLength >= (maxLength = (knownVariants = (possibleAlleles = context.getAlleles()).stream().map(Allele::getBaseString).collect(Collectors.toList())).stream().map(String::length).max(Integer::compare).get().shortValue())) {
                    for (position = start; position <= end; ++position) {
                        posBuilder = new GeneralPosition.Builder(chr, position);
                        if (!context.getID().equals(".")) {
                            posBuilder.snpName(context.getID());
                        }
                        if (position == start) {
                            posBuilder.knownVariants(knownVariants.toArray(new String[knownVariants.size()]));
                        }
                        pos = posBuilder.build();
                        if (previousPosition != null && pos.compareTo(previousPosition) <= 0) continue;
                        positionListBuilder.add(pos);
                        previousPosition = pos;
                        positionsToProcess.add(new Tuple<Integer, Short>(position, (short)0));
                    }
                } else {
                    if (refLength != 1) {
                        throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: build: expected reference to be length 1 for insertion record: chr: " + chr.getName() + " start position: " + context.getStart());
                    }
                    position = context.getStart();
                    posBuilder = new GeneralPosition.Builder(chr, position);
                    if (!context.getID().equals(".")) {
                        posBuilder.snpName(context.getID());
                    }
                    posBuilder.knownVariants((String[])knownVariants.toArray());
                    pos = posBuilder.build();
                    if (previousPosition == null || pos.compareTo(previousPosition) > 0) {
                        positionListBuilder.add(pos);
                        previousPosition = pos;
                        positionsToProcess.add(new Tuple<Integer, Short>(position, (short)0));
                    }
                    for (short i = 1; i < maxLength; i = (short)(i + 1)) {
                        GeneralPosition insertionPos = new GeneralPosition.Builder(pos).insertionPosition(i).build();
                        if (previousPosition != null && insertionPos.compareTo(previousPosition) <= 0) continue;
                        positionListBuilder.add(insertionPos);
                        previousPosition = insertionPos;
                        positionsToProcess.add(new Tuple<Integer, Short>(position, i));
                    }
                }
                contextsToProcess.add(context);
                if (numContextsToProcess >= 100 && start > previousEnd) {
                    ProcessVariantContext process = new ProcessVariantContext(contextsToProcess, numTaxa, positionsToProcess);
                    futures.add(threadPool.submit((Callable)process));
                    numContextsToProcess = 0;
                    positionsToProcess = new ArrayList();
                    contextsToProcess = new ArrayList();
                }
                previousEnd = end;
            }
            if (!contextsToProcess.isEmpty()) {
                ProcessVariantContext process = new ProcessVariantContext(contextsToProcess, numTaxa, positionsToProcess);
                futures.add(threadPool.submit((Callable)process));
            }
            PositionList positions = positionListBuilder.build();
            int numSites = positions.numberOfSites();
            GenotypeCallTableBuilder genotypes = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(numTaxa, numSites);
            AlleleDepthBuilder depthBuilder = null;
            if (this.myKeepDepth) {
                depthBuilder = AlleleDepthBuilder.getInstance(numTaxa, numSites, this.myTaxa);
            }
            int numFutures = futures.size();
            int count = 0;
            int currentSite = 0;
            for (Future future : futures) {
                ProcessVariantContext process = (ProcessVariantContext)future.get();
                SuperByteMatrix genotypesBlock = process.genotypes();
                for (int t = 0; t < genotypesBlock.getNumRows(); ++t) {
                    for (int s = 0; s < genotypesBlock.getNumColumns(); ++s) {
                        genotypes.setBase(t, currentSite + s, genotypesBlock.get(t, s));
                    }
                }
                if (this.myKeepDepth) {
                    byte[][][] depth = process.depths();
                    for (int t = 0; t < depth.length; ++t) {
                        depthBuilder.setDepthRangeForTaxon(t, currentSite, depth[t]);
                    }
                }
                currentSite += genotypesBlock.getNumColumns();
                if (this.myProgressListener == null) continue;
                this.myProgressListener.progress(++count * 100 / numFutures, null);
            }
            if (this.myKeepDepth) {
                object = GenotypeTableBuilder.getInstance(genotypes.build(), positions, this.myTaxa, depthBuilder.build());
                return object;
            }
            object = GenotypeTableBuilder.getInstance(genotypes.build(), positions, this.myTaxa);
            return object;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: build: problem building GenotypeTable\n" + e.getMessage());
        }
        finally {
            this.close();
        }
    }

    private class ProcessVariantContext
    implements Callable<ProcessVariantContext> {
        private final List<VariantContext> myContexts;
        private final int myNumTaxa;
        private final int myNumSitesToProcess;
        private final List<Tuple<Integer, Short>> myPositionsToProcess;
        private SuperByteMatrix myGenotypes = null;
        private byte[][][] myDepths = null;

        public ProcessVariantContext(List<VariantContext> contexts, int numTaxa, List<Tuple<Integer, Short>> positionsToProcess) {
            this.myContexts = contexts;
            this.myNumTaxa = numTaxa;
            this.myPositionsToProcess = positionsToProcess;
            this.myNumSitesToProcess = positionsToProcess.size();
        }

        @Override
        public ProcessVariantContext call() {
            this.myGenotypes = SuperByteMatrixBuilder.getInstance(this.myNumTaxa, this.myNumSitesToProcess);
            this.myGenotypes.setAll((byte)-1);
            if (BuilderFromVCFUsingHTSJDK.this.myKeepDepth) {
                this.myDepths = new byte[this.myNumTaxa][6][this.myNumSitesToProcess];
            }
            for (VariantContext context : this.myContexts) {
                try {
                    if (this.myNumTaxa != context.getNSamples()) {
                        throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: call: number of taxa: " + this.myNumTaxa + " should equal samples in context: " + context.getNSamples());
                    }
                    int currentPosition = context.getStart();
                    List possibleAlleles = context.getAlleles();
                    short maxLength = possibleAlleles.stream().map(Allele::getBaseString).map(String::length).max(Integer::compare).get().shortValue();
                    HashMap<Allele, byte[]> alleleToBytes = new HashMap<Allele, byte[]>();
                    for (Allele allele : possibleAlleles) {
                        byte[] result = new byte[maxLength];
                        String value = allele.getBaseString();
                        if (value.equals("*")) {
                            Arrays.fill(result, (byte)5);
                        } else {
                            int i;
                            for (i = 0; i < value.length(); ++i) {
                                result[i] = NucleotideAlignmentConstants.getNucleotideAlleleByte(value.charAt(i));
                            }
                            for (i = value.length(); i < maxLength; ++i) {
                                result[i] = 5;
                            }
                        }
                        alleleToBytes.put(allele, result);
                    }
                    byte[] unknownAllele = new byte[maxLength];
                    Arrays.fill(unknownAllele, (byte)15);
                    for (int t = 0; t < this.myNumTaxa; ++t) {
                        List alleles = context.getGenotype(t).getAlleles();
                        int numAlleles = alleles.size();
                        if (numAlleles != 1 && numAlleles != 2) {
                            throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: call: not haploid or diploid: id: " + context.getID() + " start: " + context.getStart() + " taxon: " + t + ": " + ((Taxon)BuilderFromVCFUsingHTSJDK.this.myTaxa.get(t)).getName() + " allele size: " + numAlleles);
                        }
                        byte[] first = (byte[])alleleToBytes.get(alleles.get(0));
                        if (first == null) {
                            first = unknownAllele;
                        }
                        byte[] second = null;
                        if (numAlleles == 2) {
                            second = (byte[])alleleToBytes.get(alleles.get(1));
                            if (second == null) {
                                second = unknownAllele;
                            }
                        } else {
                            second = first;
                        }
                        int index = this.myPositionsToProcess.indexOf(new Tuple<Integer, Short>(currentPosition, (short)0));
                        for (short i = 0; i < maxLength; i = (short)(i + 1)) {
                            int[] alleleDepths;
                            this.myGenotypes.set(t, index, (byte)(first[i] << 4 | second[i]));
                            if (BuilderFromVCFUsingHTSJDK.this.myKeepDepth && (alleleDepths = context.getGenotype(t).getAD()) != null) {
                                if (alleleDepths.length != possibleAlleles.size()) {
                                    throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: call: number allele depths (AD): " + alleleDepths.length + " doesn't equal number alleles: " + possibleAlleles.size() + " position: " + context.getStart() + " taxa: " + t + " depths: " + Arrays.toString(alleleDepths));
                                }
                                for (int d = 0; d < alleleDepths.length; ++d) {
                                    byte[] byArray = this.myDepths[t][((byte[])alleleToBytes.get(possibleAlleles.get(d)))[i]];
                                    int n = index;
                                    byArray[n] = (byte)(byArray[n] + alleleDepths[d]);
                                }
                            }
                            ++index;
                        }
                    }
                }
                catch (Exception e) {
                    myLogger.debug((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("BuilderFromVCFUsingHTSJDK: call: problem with id: " + context.getID() + "  start position: " + context.getStart() + "\n" + e.getMessage());
                }
            }
            return this;
        }

        public SuperByteMatrix genotypes() {
            return this.myGenotypes;
        }

        public byte[][][] depths() {
            return this.myDepths;
        }
    }
}

