/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import java.io.BufferedWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class JSONUtils {
    private static final Logger myLogger = Logger.getLogger(JSONUtils.class);

    private JSONUtils() {
    }

    private static void taxaListToJSON(TaxaList taxa, JsonGenerator generator) {
        generator.writeStartArray("TaxaList");
        taxa.stream().forEach(current -> JSONUtils.taxaToJSON(current, generator));
        generator.writeEnd();
    }

    private static void taxaToJSON(Taxon taxon, JsonGenerator generator) {
        generator.writeStartObject();
        generator.write("name", taxon.getName());
        JSONUtils.generalAnnotationToJSON(taxon.getAnnotation(), generator);
        generator.writeEnd();
    }

    private static void generalAnnotationToJSON(GeneralAnnotation annotation, JsonGenerator generator) {
        if (annotation == null) {
            return;
        }
        Set<String> keys = annotation.getAnnotationKeys();
        if (keys.isEmpty()) {
            return;
        }
        generator.writeStartObject("anno");
        keys.stream().forEach(key -> {
            String[] values = annotation.getTextAnnotation((String)key);
            if (values.length == 1) {
                generator.write(key, values[0]);
            } else {
                generator.writeStartArray(key);
                for (String current : values) {
                    generator.write(current);
                }
                generator.writeEnd();
            }
        });
        generator.writeEnd();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportTaxaListToJSON(TaxaList taxa, String filename) {
        filename = Utils.addGzSuffixIfNeeded(filename, ".json");
        try (BufferedWriter writer = Utils.getBufferedWriter(filename);){
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonGeneratorFactory factory = Json.createGeneratorFactory(properties);
            try (JsonGenerator generator = factory.createGenerator((Writer)writer);){
                generator.writeStartObject();
                JSONUtils.taxaListToJSON(taxa, generator);
                generator.writeEnd();
            }
            String string = filename;
            return string;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("JSONUtils: exportTaxaListToJSON: problem saving file: " + filename + "\n" + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public static TaxaList importTaxaListFromJSON(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static TaxaList taxaListFromJSON(JsonArray taxaList) {
        if (taxaList.isEmpty()) {
            return null;
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        taxaList.forEach(current -> builder.add(JSONUtils.taxonFromJSON((JsonObject)current)));
        return builder.build();
    }

    private static Taxon taxonFromJSON(JsonObject json) {
        String name = json.getString("name");
        if (name == null) {
            throw new IllegalStateException("JSONUtils: taxonFromJSON: All Taxa must have a name.");
        }
        JsonObject anno = json.getJsonObject("anno");
        if (anno != null) {
            return new Taxon(name, JSONUtils.generalAnnotationFromJSON(anno));
        }
        return new Taxon(name);
    }

    private static GeneralAnnotationStorage.Builder generalAnnotationBuilderFromJSON(JsonObject json) {
        GeneralAnnotationStorage.Builder builder = GeneralAnnotationStorage.getBuilder();
        if (json != null) {
            json.forEach((key, value) -> {
                if (value instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)value;
                    jsonArray.forEach(str -> builder.addAnnotation((String)key, ((JsonString)str).getString()));
                } else if (value instanceof JsonString) {
                    builder.addAnnotation((String)key, ((JsonString)value).getString());
                } else {
                    throw new IllegalArgumentException("JSONUtils: generalAnnotationBuilderFromJSON: unknown value type: " + value.getClass().getName());
                }
            });
        }
        return builder;
    }

    private static GeneralAnnotation generalAnnotationFromJSON(JsonObject json) {
        if (json == null) {
            return GeneralAnnotationStorage.EMPTY_ANNOTATION_STORAGE;
        }
        GeneralAnnotationStorage.Builder builder = JSONUtils.generalAnnotationBuilderFromJSON(json);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exportPositionListToJSON(PositionList positions, String filename) {
        filename = Utils.addGzSuffixIfNeeded(filename, ".json");
        try (BufferedWriter writer = Utils.getBufferedWriter(filename);){
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonGeneratorFactory factory = Json.createGeneratorFactory(properties);
            try (JsonGenerator generator = factory.createGenerator((Writer)writer);){
                generator.writeStartObject();
                JSONUtils.positionListToJSON(positions, generator);
                generator.writeEnd();
            }
            String string = filename;
            return string;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("JSONUtils: exportTaxaListToJSON: problem saving file: " + filename + "\n" + e.getMessage());
        }
    }

    private static void positionListToJSON(PositionList positions, JsonGenerator generator) {
        generator.writeStartArray("PositionList");
        positions.stream().forEach(current -> JSONUtils.positionToJSON(current, generator));
        generator.writeEnd();
    }

    private static void positionToJSON(Position position, JsonGenerator generator) {
        float globalSiteCoverage;
        float globalMAF;
        generator.writeStartObject();
        String snpID = position.getActualSNPID();
        if (snpID != null) {
            generator.write("SNPID", snpID);
        }
        JSONUtils.chromosomeToJSON(position.getChromosome(), generator);
        generator.write("position", position.getPosition());
        short subPos = position.getInsertionPosition();
        if (subPos != 0) {
            generator.write("subPos", (int)subPos);
        }
        if (!Float.isNaN(globalMAF = position.getGlobalMAF())) {
            generator.write("globalMAF", (double)globalMAF);
        }
        if (!Float.isNaN(globalSiteCoverage = position.getGlobalSiteCoverage())) {
            generator.write("globalSiteCoverage", (double)globalSiteCoverage);
        }
        generator.write("strand", Position.getStrand(position.getStrand()));
        JSONUtils.generalAnnotationToJSON(position.getAnnotation(), generator);
        generator.writeEnd();
    }

    private static void chromosomeToJSON(Chromosome chromosome, JsonGenerator generator) {
        if (chromosome == null) {
            return;
        }
        generator.writeStartObject("chr");
        generator.write("name", chromosome.getName());
        int length = chromosome.getLength();
        if (length != -1) {
            generator.write("length", length);
        }
        JSONUtils.generalAnnotationToJSON(chromosome.getAnnotation(), generator);
        generator.writeEnd();
    }

    /*
     * Exception decompiling
     */
    public static PositionList importPositionListFromJSON(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PositionList positionListFromJSON(JsonParser parser) {
        JsonParser.Event current = parser.next();
        if (current != JsonParser.Event.KEY_NAME || !parser.getString().equals("PositionList")) {
            throw new IllegalStateException("JSOnUtils: positionListFromJSON: Expecting KEY_NAME PositionList");
        }
        current = parser.next();
        if (current != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException("JSONUtils: positionListFromJSON: Position List must start with JSON Array");
        }
        PositionListBuilder builder = new PositionListBuilder();
        current = parser.next();
        while (current == JsonParser.Event.START_OBJECT) {
            builder.add(JSONUtils.positionFromJSON(parser));
            current = parser.next();
        }
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Position positionFromJSON(JsonParser parser) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        JsonParser.Event current = parser.next();
        while (current != JsonParser.Event.END_OBJECT) {
            if (current != JsonParser.Event.KEY_NAME) throw new IllegalStateException("JSONUtils: positionFromJSON: Don't know how to handle Event type: " + current.name());
            String key = parser.getString();
            current = parser.next();
            if (current == JsonParser.Event.START_OBJECT) {
                if (key.equals("chr")) {
                    values.put(key, JSONUtils.chromosomeFromJSON(parser));
                } else {
                    if (!key.equals("anno")) throw new IllegalStateException("JSONUtils: positionFromJSON: Unknown Object value key: " + key);
                    values.put(key, JSONUtils.generalAnnotationBuilderFromJSON(parser));
                }
            } else {
                values.put(key, parser.getString());
            }
            current = parser.next();
        }
        Chromosome chr = (Chromosome)values.remove("chr");
        if (chr == null) {
            throw new IllegalStateException("JSONUtils: positionFromJSON: No chromosome defined.");
        }
        Object positionStr = values.remove("position");
        if (positionStr == null) {
            throw new IllegalStateException("JSONUtils: positionFromJSON: No position defined.");
        }
        int position = Integer.parseInt((String)positionStr);
        GeneralAnnotationStorage.Builder anno = (GeneralAnnotationStorage.Builder)values.remove("anno");
        GeneralPosition.Builder builder = anno == null ? new GeneralPosition.Builder(chr, position) : new GeneralPosition.Builder(chr, position, anno);
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("SNPID")) {
                builder.snpName((String)value);
                continue;
            }
            if (key.equals("subPos")) {
                builder.insertionPosition(Short.parseShort((String)value));
                continue;
            }
            if (key.equals("globalMAF")) {
                builder.maf(Float.parseFloat((String)value));
                continue;
            }
            if (key.equals("globalSiteCoverage")) {
                builder.siteCoverage(Float.parseFloat((String)value));
                continue;
            }
            if (!key.equals("strand")) throw new IllegalStateException("JSONUtils: positionFromJSON: Unknown key: " + key);
            builder.strand((String)value);
        }
        return builder.build();
    }

    private static GeneralAnnotationStorage.Builder generalAnnotationBuilderFromJSON(JsonParser parser) {
        GeneralAnnotationStorage.Builder builder = GeneralAnnotationStorage.getBuilder();
        JsonParser.Event current = parser.next();
        while (current != JsonParser.Event.END_OBJECT) {
            String key;
            if (current == JsonParser.Event.START_ARRAY) {
                key = parser.getString();
                current = parser.next();
                while (current != JsonParser.Event.END_ARRAY) {
                    builder.addAnnotation(key, parser.getString());
                    current = parser.next();
                }
            } else if (current == JsonParser.Event.KEY_NAME) {
                key = parser.getString();
                parser.next();
                builder.addAnnotation(key, parser.getString());
            }
            current = parser.next();
        }
        return builder;
    }

    private static GeneralAnnotation generalAnnotationFromJSON(JsonParser parser) {
        if (!parser.getString().equals("anno")) {
            return GeneralAnnotationStorage.EMPTY_ANNOTATION_STORAGE;
        }
        GeneralAnnotationStorage.Builder builder = JSONUtils.generalAnnotationBuilderFromJSON(parser);
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Chromosome chromosomeFromJSON(JsonParser parser) {
        String name = null;
        int length = -1;
        GeneralAnnotation anno = null;
        JsonParser.Event current = parser.next();
        while (current != JsonParser.Event.END_OBJECT) {
            if (current == JsonParser.Event.KEY_NAME) {
                String key = parser.getString();
                parser.next();
                if (key.equals("name")) {
                    name = parser.getString();
                } else {
                    if (!key.equals("length")) throw new IllegalStateException("JSONUtils: chromosomeFromJSON: Unknown key: " + key);
                    length = parser.getInt();
                }
            } else if (current == JsonParser.Event.START_OBJECT && parser.getString().equals("anno")) {
                anno = JSONUtils.generalAnnotationFromJSON(parser);
            }
            current = parser.next();
        }
        return Chromosome.instance(name, length, anno);
    }
}

