/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ReadBedfile {
    private static final Logger myLogger = Logger.getLogger(ReadBedfile.class);

    private ReadBedfile() {
    }

    public static List<BedFileRange> getRanges(String bedFile) {
        ArrayList<BedFileRange> result = new ArrayList<BedFileRange>();
        String line = null;
        try (BufferedReader reader = Utils.getBufferedReader(bedFile);){
            int lineNum = 1;
            line = reader.readLine();
            while (line != null) {
                String[] tokens = line.trim().split("\t");
                if (tokens.length < 3) {
                    throw new IllegalStateException("getRanges: Expecting at least 3 columns on line: " + lineNum);
                }
                int startPos = Integer.parseInt(tokens[1]) + 1;
                int endPos = Integer.parseInt(tokens[2]) + 1;
                String name = null;
                if (tokens.length > 3) {
                    name = tokens[3] == null || tokens[3].isEmpty() ? null : tokens[3];
                }
                result.add(new BedFileRange(tokens[0], startPos, endPos, name));
                line = reader.readLine();
                ++lineNum;
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("getRanges: problem reading: " + bedFile + " line: " + line);
        }
        return result;
    }

    public static PositionList getPositionList(String bedfile) {
        PositionListBuilder builder = new PositionListBuilder();
        ReadBedfile.getRanges(bedfile).stream().forEach(range -> {
            for (int pos = range.start(); pos < range.end(); ++pos) {
                builder.add(Position.of(range.chr(), pos));
            }
        });
        return builder.build();
    }

    public static RangeSet<Position> getRangesAsPositions(String bedfile) {
        return (RangeSet)ReadBedfile.getRanges(bedfile).stream().map(bedFileRange -> Range.closedOpen((Comparable)Position.of(((BedFileRange)bedFileRange).myChr, ((BedFileRange)bedFileRange).myStartPos), (Comparable)Position.of(((BedFileRange)bedFileRange).myChr, ((BedFileRange)bedFileRange).myEndPos))).collect(Collectors.collectingAndThen(Collectors.toSet(), TreeRangeSet::create));
    }

    public static RangeSet<Position> getClosedRangesAsPositions(String bedfile) {
        return (RangeSet)ReadBedfile.getRanges(bedfile).stream().map(bedFileRange -> Range.closed((Comparable)Position.of(((BedFileRange)bedFileRange).myChr, ((BedFileRange)bedFileRange).myStartPos), (Comparable)Position.of(((BedFileRange)bedFileRange).myChr, ((BedFileRange)bedFileRange).myEndPos - 1))).collect(Collectors.collectingAndThen(Collectors.toSet(), TreeRangeSet::create));
    }

    public static RangeMap<Position, String> getRangesAsPositionMap(String bedfile) {
        TreeRangeMap positionNameRangeMap = TreeRangeMap.create();
        for (BedFileRange bedFileRange : ReadBedfile.getRanges(bedfile)) {
            positionNameRangeMap.put(Range.closedOpen((Comparable)Position.of(bedFileRange.myChr, bedFileRange.myStartPos), (Comparable)Position.of(bedFileRange.myChr, bedFileRange.myEndPos)), (Object)bedFileRange.myName);
        }
        return positionNameRangeMap;
    }

    public static class BedFileRange
    implements Comparable<BedFileRange> {
        private final String myChr;
        private final int myChrInt;
        private final int myStartPos;
        private final int myEndPos;
        private final String myName;

        public BedFileRange(String chr, int startPos, int endPos, String name) {
            int temp;
            this.myChr = chr;
            try {
                temp = Integer.parseInt(chr);
            }
            catch (Exception e) {
                temp = -1;
            }
            this.myChrInt = temp;
            this.myStartPos = startPos;
            this.myEndPos = endPos;
            this.myName = name;
        }

        public String chr() {
            return this.myChr;
        }

        public int start() {
            return this.myStartPos;
        }

        public int end() {
            return this.myEndPos;
        }

        public String name() {
            return this.myName;
        }

        @Override
        public int compareTo(BedFileRange o) {
            if (this.myChrInt != -1) {
                if (this.myChrInt < o.myChrInt) {
                    return -1;
                }
                if (this.myChrInt > o.myChrInt) {
                    return 1;
                }
            } else if (!this.myChr.equals(o.myChr)) {
                return this.myChr.compareTo(o.myChr);
            }
            if (this.myStartPos < o.myStartPos) {
                return -1;
            }
            if (this.myStartPos > o.myStartPos) {
                return 1;
            }
            if (this.myEndPos < o.myEndPos) {
                return -1;
            }
            if (this.myEndPos > o.myEndPos) {
                return 1;
            }
            return 0;
        }
    }
}

