/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.TranslateBuilder;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.byte2d.Byte2DBuilder;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleDepthUtil;
import net.maizegenetics.dna.snp.score.FilterAlleleDepth;
import net.maizegenetics.dna.snp.score.HDF5AlleleDepth;
import net.maizegenetics.dna.snp.score.HDF5AlleleDepthBuilder;
import net.maizegenetics.dna.snp.score.MaskAlleleDepth;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;

public class AlleleDepthBuilder {
    private Byte2DBuilder[] myBuilders;
    private final int myNumSites;

    private AlleleDepthBuilder(int numTaxa, int numSites, TaxaList taxaList) {
        this.myBuilders = new Byte2DBuilder[AlleleDepth.NUM_ALLELE_DEPTH_TYPES];
        for (int i = 0; i < AlleleDepth.NUM_ALLELE_DEPTH_TYPES; ++i) {
            this.myBuilders[i] = Byte2DBuilder.getInstance(numTaxa, numSites, AlleleDepth.ALLELE_DEPTH_TYPES[i], taxaList);
        }
        this.myNumSites = numSites;
    }

    protected AlleleDepthBuilder(int numSites) {
        this.myNumSites = numSites;
        this.myBuilders = null;
    }

    public static AlleleDepthBuilder getInstance(IHDF5Writer writer, int numSites) {
        return HDF5AlleleDepthBuilder.getHDF5NucleotideInstance(writer, numSites);
    }

    public static AlleleDepth getFilteredInstance(HDF5AlleleDepth alleleDepth, FilterGenotypeTable filter) {
        return HDF5AlleleDepthBuilder.getFilteredInstance(alleleDepth, filter);
    }

    public static AlleleDepthBuilder getInstance(int numTaxa, int numSites, TaxaList taxaList) {
        return new AlleleDepthBuilder(numTaxa, numSites, taxaList);
    }

    public static AlleleDepth getFilteredInstance(AlleleDepth base, Translate translate) {
        if (base instanceof FilterAlleleDepth) {
            FilterAlleleDepth filter = (FilterAlleleDepth)base;
            Translate merged = TranslateBuilder.getInstance(filter.myTranslate, translate);
            return new FilterAlleleDepth(filter.myBase, merged);
        }
        return new FilterAlleleDepth(base, translate);
    }

    public static AlleleDepth getMaskInstance(AlleleDepth base, MaskMatrix mask) {
        return new MaskAlleleDepth(base, mask);
    }

    public static AlleleDepth getInstance(IHDF5Reader reader) {
        return HDF5AlleleDepthBuilder.getExistingHDF5Instance(reader);
    }

    public AlleleDepthBuilder addTaxon(int taxon, int[] values, SiteScore.SITE_SCORE_TYPE type) {
        if (this.myNumSites != values.length) {
            throw new IllegalArgumentException("AlleleDepthBuilder: addTaxon: number of values: " + values.length + " doesn't equal number of sites: " + this.myNumSites);
        }
        byte[] result = AlleleDepthUtil.depthIntToByte(values);
        this.myBuilders[type.getIndex()].addTaxon(taxon, result);
        return this;
    }

    public AlleleDepthBuilder addTaxon(int taxon, byte[][] values) {
        if (AlleleDepth.NUM_ALLELE_DEPTH_TYPES != values.length) {
            throw new IllegalArgumentException("AlleleDepthBuilder: addTaxon: number of alleles: " + values.length + " doesn't equals: " + AlleleDepth.NUM_ALLELE_DEPTH_TYPES);
        }
        if (this.myNumSites != values[0].length) {
            throw new IllegalArgumentException("AlleleDepthBuilder: addTaxon: number of values: " + values[0].length + " doesn't equal number of sites: " + this.myNumSites);
        }
        for (int i = 0; i < AlleleDepth.NUM_ALLELE_DEPTH_TYPES; ++i) {
            this.myBuilders[i].addTaxon(taxon, values[i]);
        }
        return this;
    }

    public AlleleDepthBuilder setDepthRangeForTaxon(int taxon, int siteOffset, byte[][] depths) {
        int numAlleles = depths.length;
        if (numAlleles != AlleleDepth.NUM_ALLELE_DEPTH_TYPES) {
            throw new IllegalArgumentException("AlleleDepthBuilder: setDepthRangeForTaxon: value number of alleles: " + numAlleles + " should be: " + AlleleDepth.NUM_ALLELE_DEPTH_TYPES);
        }
        for (int a = 0; a < AlleleDepth.NUM_ALLELE_DEPTH_TYPES; ++a) {
            this.myBuilders[a].setDepthRangeForTaxon(taxon, siteOffset, depths[a]);
        }
        return this;
    }

    public void reorderPositions(int[] newIndices) {
        for (int i = 0; i < AlleleDepth.NUM_ALLELE_DEPTH_TYPES; ++i) {
            this.myBuilders[i].reorderPositions(newIndices);
        }
    }

    public AlleleDepth build() {
        Byte2D[] input = new Byte2D[AlleleDepth.NUM_ALLELE_DEPTH_TYPES];
        for (int a = 0; a < AlleleDepth.NUM_ALLELE_DEPTH_TYPES; ++a) {
            input[a] = this.myBuilders[a].build();
        }
        this.myBuilders = null;
        return new AlleleDepth(input);
    }
}

