/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.SiteScore;

public class FilterAlleleProbability
extends AlleleProbability {
    final AlleleProbability myBase;
    final Translate myTranslate;

    FilterAlleleProbability(AlleleProbability alleleProbability, Translate translate) {
        super(translate.numTaxa(), translate.numSites());
        if (alleleProbability instanceof FilterAlleleProbability) {
            throw new IllegalArgumentException();
        }
        this.myBase = alleleProbability;
        this.myTranslate = translate;
    }

    @Override
    public float value(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        long taxonSite = this.myTranslate.taxonSite(taxon, site);
        if (taxonSite == -1L) {
            return 0.0f;
        }
        return this.myBase.value((int)(taxonSite >>> 32), (int)(taxonSite & 0xFFFFFFFFFFFFFFFFL), scoreType);
    }
}

