/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Collection;
import net.maizegenetics.dna.snp.MaskMatrix;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.SiteScore;

public class MaskAlleleProbability
extends AlleleProbability {
    private final AlleleProbability myProbability;
    private final MaskMatrix myMask;

    public MaskAlleleProbability(AlleleProbability probability, MaskMatrix mask) {
        super(probability.numTaxa(), probability.numSites());
        this.myProbability = probability;
        this.myMask = mask;
    }

    @Override
    public float value(int taxon, int site, SiteScore.SITE_SCORE_TYPE scoreType) {
        if (this.myMask.get(taxon, site)) {
            return 0.0f;
        }
        return this.myProbability.value(taxon, site, scoreType);
    }

    @Override
    Collection<Byte2D> byteStorage() {
        return null;
    }

    public AlleleProbability base() {
        return this.myProbability;
    }

    public MaskMatrix mask() {
        return this.myMask;
    }
}

