/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.maizegenetics.dna.snp.byte2d.Byte2D;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.dna.snp.score.SiteScoreUtil;

public class ReferenceProbability
implements SiteScore {
    private final Byte2D myStorage;
    private final int myNumTaxa;
    private final int myNumSites;

    ReferenceProbability(Byte2D value) {
        this.myStorage = value;
        this.myNumTaxa = this.myStorage.numTaxa();
        this.myNumSites = this.myStorage.numSites();
    }

    ReferenceProbability(int numTaxa, int numSites) {
        this.myStorage = null;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    public float value(int taxon, int site) {
        return SiteScoreUtil.byteToFloatPercentage(this.myStorage.valueForAllele(taxon, site));
    }

    Byte2D byteStorage() {
        return this.myStorage;
    }

    @Override
    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes() {
        return new HashSet<SiteScore.SITE_SCORE_TYPE>(Arrays.asList(SiteScore.SITE_SCORE_TYPE.Dosage));
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }
}

