/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maizegenetics.analysis.gbs.repgen.AlignmentInfo;
import net.maizegenetics.analysis.gbs.repgen.RefTagData;
import net.maizegenetics.analysis.gbs.repgen.TagCorrelationInfo;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Tuple;

public interface RepGenData {
    public TaxaDistribution getTaxaDistribution(Tag var1);

    public Set<Allele> getAlleles(Tag var1);

    public Multimap<Tag, Allele> getAlleleMap();

    public Set<Tag> getTagsForAllele(Position var1, byte var2);

    public Set<Tag> getTagsForAllele(Allele var1);

    public Set<Tag> getTags();

    public Map<Tag, String> getTagsNameMap();

    public PositionList getSNPPositions();

    public PositionList getSNPPositions(int var1);

    public PositionList getSNPPositions(double var1);

    public PositionList getSNPPositionsForChromosomes(Integer var1, Integer var2);

    public Set<Tag> getTagsForTaxon(Taxon var1);

    public Map<Tag, Integer> getTagDepth(Taxon var1, Position var2);

    public Map<Tag, Integer> getTagsWithDepth(int var1);

    public PositionList getTagCutPositions(boolean var1);

    public PositionList getTagCutPositions(Chromosome var1, int var2, int var3, boolean var4);

    public Map<Tag, Position> getTagCutPosition(Set<Tag> var1);

    public Map<String, String> getTagAlignmentApproaches();

    public Map<Position, Map<Tag, Tuple<Boolean, TaxaDistribution>>> getCutPositionTagTaxaMap(Chromosome var1, int var2, int var3);

    public Map<Position, Map<Tag, TaxaDistribution>> getCutPosForStrandTagTaxaMap(Chromosome var1, int var2, int var3, boolean var4);

    public TaxaList getTaxaList();

    public ListMultimap<String, Tuple<Integer, Float>> getSNPPositionQS(HashMultimap<String, Integer> var1);

    public Multimap<Allele, Map<Tag, TaxaDistribution>> getAllelesTagTaxaDistForSNP(Position var1);

    public List<Chromosome> getChromosomesFromCutPositions();

    public Map<Tag, TaxaDistribution> getAllTagsTaxaMap();

    public PositionList getPhysicalMapPositions();

    public PositionList getPhysicalMapPositions(Chromosome var1, int var2, int var3);

    public Set<RefTagData> getRefTags();

    public Multimap<Tag, AlignmentInfo> getTagAlignmentsForTags(List<Tag> var1, int var2);

    public Multimap<Tag, AlignmentInfo> getRefAlignmentsForTags(List<Tag> var1, int var2);

    public Multimap<Tag, AlignmentInfo> getTagAlignmentsForRefTag(RefTagData var1, int var2);

    public Multimap<Tag, AlignmentInfo> getAllNonRefTagAlignments(int var1);

    public Multimap<RefTagData, AlignmentInfo> getAllRefTagAlignments(int var1);

    public Multimap<RefTagData, AlignmentInfo> getRefAlignmentsForRefTags(List<RefTagData> var1, int var2);

    public Multimap<Tag, TagCorrelationInfo> getCorrelationsForTags(List<Tag> var1);
}

