/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.maizegenetics.dna.tag.TaxaDistFixed;
import net.maizegenetics.dna.tag.TaxaDistIntExpandable;
import net.maizegenetics.dna.tag.TaxaDistShortExpandable;
import net.maizegenetics.dna.tag.TaxaDistribution;
import org.xerial.snappy.Snappy;

public class TaxaDistBuilder {
    private TaxaDistBuilder() {
    }

    public static TaxaDistribution create(int maxTaxa, int taxaWithTag) {
        TaxaDistribution td = TaxaDistBuilder.create(maxTaxa);
        return td.increment(taxaWithTag);
    }

    public static TaxaDistribution create(int maxTaxa) {
        if (maxTaxa < Short.MAX_VALUE) {
            return new TaxaDistShortExpandable(maxTaxa);
        }
        return new TaxaDistIntExpandable(maxTaxa);
    }

    public static TaxaDistribution create(int maxTaxa, int[] taxaWithTags, int[] depthOfTags) {
        return new TaxaDistFixed(maxTaxa, taxaWithTags, depthOfTags);
    }

    public static TaxaDistribution create(byte[] encodedTaxaDistribution) {
        int[][] decodedTD = TaxaDistBuilder.getDepthMatrixForEncodedDepths(encodedTaxaDistribution);
        return new TaxaDistFixed(decodedTD[2][0], decodedTD[0], decodedTD[1]);
    }

    public static TaxaDistribution create(TaxaDistribution srcTaxaDist) {
        TaxaDistribution dstTD = TaxaDistBuilder.create(srcTaxaDist.maxTaxa());
        int[] depths = srcTaxaDist.depths();
        for (int taxaIndex = 0; taxaIndex < depths.length; ++taxaIndex) {
            for (int j = 0; j < depths[taxaIndex]; ++j) {
                dstTD.increment(taxaIndex);
            }
        }
        return dstTD;
    }

    public static TaxaDistribution combine(TaxaDistribution taxaDist1, TaxaDistribution taxaDist2) {
        if (taxaDist1.maxTaxa() != taxaDist2.maxTaxa()) {
            throw new IllegalStateException("TaxaDistributions not of same size");
        }
        int[] depths1 = taxaDist1.depths();
        int[] depths2 = taxaDist2.depths();
        int taxaWithDepth = 0;
        for (int i = 0; i < depths1.length; ++i) {
            int n = i;
            depths1[n] = depths1[n] + depths2[i];
            if (depths1[i] <= 0) continue;
            ++taxaWithDepth;
        }
        int[] taxaWithTags = new int[taxaWithDepth];
        int[] depthOfTags = new int[taxaWithDepth];
        taxaWithDepth = 0;
        for (int i = 0; i < depths1.length; ++i) {
            if (depths1[i] <= 0) continue;
            taxaWithTags[taxaWithDepth] = i;
            depthOfTags[taxaWithDepth] = depths1[i];
            ++taxaWithDepth;
        }
        return TaxaDistBuilder.create(taxaDist1.maxTaxa(), taxaWithTags, depthOfTags);
    }

    public static TaxaDistribution create(int maxTaxa, int[] encodeTaxaDepths) {
        TaxaDistribution dstTD = TaxaDistBuilder.create(maxTaxa);
        for (int taxaDepth : encodeTaxaDepths) {
            int taxa = taxaDepth >>> 8;
            int depth = UnsignedBytes.toInt((byte)((byte)taxaDepth));
            for (int i = 0; i < depth; ++i) {
                dstTD.increment(taxa);
            }
        }
        return dstTD;
    }

    public static int[][] getDepthMatrixForEncodedDepths(byte[] input) {
        try {
            int inc;
            int i;
            int maxValueInInt = UnsignedBytes.toInt((byte)-1);
            ByteBuffer bb = ByteBuffer.wrap(Snappy.uncompress((byte[])input));
            int maxTaxa = bb.getInt();
            int taxaWithDepth = bb.getInt();
            int[][] result = new int[][]{new int[taxaWithDepth], new int[taxaWithDepth], {maxTaxa}};
            for (i = 0; i < taxaWithDepth; ++i) {
                int space = i > 0 ? result[0][i - 1] : 0;
                inc = UnsignedBytes.toInt((byte)bb.get());
                while (inc == maxValueInInt) {
                    space += inc;
                    inc = UnsignedBytes.toInt((byte)bb.get());
                }
                result[0][i] = space += inc;
            }
            for (i = 0; i < taxaWithDepth; ++i) {
                int depth = 0;
                inc = UnsignedBytes.toInt((byte)bb.get());
                while (inc == maxValueInInt) {
                    depth += inc;
                    inc = UnsignedBytes.toInt((byte)bb.get());
                }
                result[1][i] = depth += inc;
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

