/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public abstract class AbstractAvailableListModel
extends AbstractListModel<String> {
    private final BitSet myShownIndices;
    private boolean myShowAll = true;
    private final int myRealSize;

    public AbstractAvailableListModel(int realSize) {
        this.myRealSize = realSize;
        this.myShownIndices = new OpenBitSet(this.myRealSize);
        this.showAll();
    }

    @Override
    public int getSize() {
        return (int)this.myShownIndices.cardinality();
    }

    @Override
    public String getElementAt(int index) {
        if (this.myShowAll) {
            return this.getRealElementAt(index);
        }
        return this.getRealElementAt(this.myShownIndices.indexOfNthSetBit(index + 1));
    }

    public void setShown(String search) {
        if (search == null || search.length() == 0) {
            if (this.showAll()) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return;
        }
        try {
            if (search.indexOf(42, search.length() - 1) == -1) {
                search = search + "*";
            }
            search = search.replaceAll("\\.", "\\\\.");
            search = search.replaceAll("\\*", "(.*)");
            this.showNone();
            Pattern pattern = Pattern.compile(search);
            int n = this.getRealSize();
            for (int i = 0; i < n; ++i) {
                if (!pattern.matcher(this.getRealElementAt(i)).matches()) continue;
                this.myShownIndices.fastSet(i);
            }
            this.myShowAll = this.myShownIndices.cardinality() == (long)this.getRealSize();
        }
        catch (Exception e) {
            this.showNone();
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public int[] translateToRealIndices(int[] shownIndices) {
        for (int i = 0; i < shownIndices.length; ++i) {
            shownIndices[i] = this.myShownIndices.indexOfNthSetBit(shownIndices[i] + 1);
        }
        return shownIndices;
    }

    private boolean showAll() {
        this.myShowAll = true;
        if (this.myShownIndices.cardinality() == (long)this.getRealSize()) {
            return false;
        }
        this.myShownIndices.set(0L, this.getRealSize());
        return true;
    }

    private void showNone() {
        this.myShowAll = false;
        this.myShownIndices.clear(0, this.getRealSize());
    }

    public int getRealSize() {
        return this.myRealSize;
    }

    public abstract String getRealElementAt(int var1);
}

