/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.maizegenetics.dna.map.DonorHaplotypes;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.ProjectionGenotypeCallTable;
import net.maizegenetics.gui.AlignmentTableModel;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.gui.GenotypeTableMaskGeneticDistance;
import net.maizegenetics.gui.GenotypeTableMaskReference;
import org.apache.log4j.Logger;

public class AlignmentTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger myLogger = Logger.getLogger(AlignmentTableCellRenderer.class);
    private static int[] NUCLEOTIDE_COLORS = new int[16];
    private static final Color MAJOR_ALLELE_COLOR;
    private static final Color MINOR_ALLELE_COLOR;
    private static final Color HETEROZYGOUS_COLOR;
    private static final Color MAJOR_MINOR_ALLELE_COLOR;
    private static final Color[] COLORS_256;
    private static final Map<String, Color> COLORS_NUCLEOTIDES;
    private static final RENDERING_TYPE[] GENOTYPE_RENDERING_TYPES;
    protected final AlignmentTableModel myAlignmentTableModel;
    private final GenotypeTable myAlignment;
    private GenotypeTableMask[] myMasks;
    private final RENDERING_TYPE[] mySupportedRenderingTypes;
    private RENDERING_TYPE myRenderingType = RENDERING_TYPE.MajorMinorAllele;
    private final Map<Integer, byte[]> myCachedAlleles = new LinkedHashMap<Integer, byte[]>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    };
    private static final int[] PROJECTION_MASKS;

    public AlignmentTableCellRenderer(AlignmentTableModel model, GenotypeTable alignment, GenotypeTableMask[] masks) {
        this.myAlignmentTableModel = model;
        this.myAlignment = alignment;
        this.myMasks = masks;
        ArrayList<RENDERING_TYPE> temp = new ArrayList<RENDERING_TYPE>();
        if (this.myAlignment.hasGenotype()) {
            try {
                if (this.myAlignment.genotypeMatrix() instanceof ProjectionGenotypeCallTable) {
                    temp.add(RENDERING_TYPE.Projection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.myAlignment.hasReferenceProbablity()) {
                temp.add(RENDERING_TYPE.NumericGenotype);
            }
            for (int i = 0; i < GENOTYPE_RENDERING_TYPES.length; ++i) {
                temp.add(GENOTYPE_RENDERING_TYPES[i]);
            }
            try {
                if (NucleotideAlignmentConstants.isNucleotideEncodings(this.myAlignment.alleleDefinitions())) {
                    temp.add(RENDERING_TYPE.Nucleotide);
                    temp.add(RENDERING_TYPE.NucleotideHeterozygous);
                }
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.myAlignment.hasDepth()) {
            temp.add(RENDERING_TYPE.Depth);
        }
        this.mySupportedRenderingTypes = new RENDERING_TYPE[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            this.mySupportedRenderingTypes[i] = (RENDERING_TYPE)((Object)temp.get(i));
        }
        if (this.mySupportedRenderingTypes.length != 0) {
            this.setRenderingType(this.mySupportedRenderingTypes[0]);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        switch (this.myRenderingType) {
            case Nucleotide: {
                return this.getNucleotideRendering(table, value, isSelected, hasFocus, row, col);
            }
            case NucleotideHeterozygous: {
                return this.getNucleotideHeterozygousRendering(table, value, isSelected, hasFocus, row, col);
            }
            case MajorAllele: {
                return this.getMajorAlleleRendering(table, value, isSelected, hasFocus, row, col);
            }
            case MinorAllele: {
                return this.getMinorAlleleRendering(table, value, isSelected, hasFocus, row, col);
            }
            case Heterozygous: {
                return this.getHeterozygousRendering(table, value, isSelected, hasFocus, row, col);
            }
            case MajorMinorAllele: {
                return this.getMajorMinorAlleleRendering(table, value, isSelected, hasFocus, row, col);
            }
            case ReferenceMasks: {
                return this.getReferenceMasksRendering(table, value, isSelected, hasFocus, row, col);
            }
            case NumericGenotype: {
                return this.getReferenceProbabilityRendering(table, value, isSelected, hasFocus, row, col);
            }
            case Projection: {
                return this.getProjectionRendering(table, value, isSelected, hasFocus, row, col);
            }
            case GeneticDistanceMasks: {
                return this.getGeneticDistanceMasksRendering(table, value, isSelected, hasFocus, row, col);
            }
            case Depth: {
                return this.getDepthMasksRendering(table, value, isSelected, hasFocus, row, col);
            }
            case None: {
                return this.getDefaultRendering(table, value, isSelected, hasFocus, row, col);
            }
        }
        return this.getDefaultRendering(table, value, isSelected, hasFocus, row, col);
    }

    protected Component getDefaultRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else {
            comp.setBackground(null);
        }
        return comp;
    }

    protected Component getNucleotideRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        String alleles = this.myAlignment.genotypeAsString(row, this.myAlignmentTableModel.getRealColumnIndex(col));
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (alleles.equals("N")) {
            comp.setBackground(null);
        } else {
            comp.setBackground(COLORS_NUCLEOTIDES.get(alleles));
        }
        return comp;
    }

    private Component getNucleotideHeterozygousRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        int site = this.myAlignmentTableModel.getRealColumnIndex(col);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (this.myAlignment.isHeterozygous(row, site)) {
            String alleles = this.myAlignment.genotypeAsString(row, this.myAlignmentTableModel.getRealColumnIndex(col));
            comp.setBackground(COLORS_NUCLEOTIDES.get(alleles));
        } else {
            comp.setBackground(null);
        }
        return comp;
    }

    private Component getMajorAlleleRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        int site = this.myAlignmentTableModel.getRealColumnIndex(col);
        byte[] alleles = this.myCachedAlleles.get(site);
        if (alleles == null) {
            alleles = this.myAlignment.alleles(site);
            this.myCachedAlleles.put(site, alleles);
        }
        byte major = 15;
        if (alleles.length > 0) {
            major = alleles[0];
        }
        byte[] diploidValues = this.myAlignment.genotypeArray(row, site);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (diploidValues[0] == major || diploidValues[1] == major) {
            comp.setBackground(MAJOR_ALLELE_COLOR);
        } else {
            comp.setBackground(null);
        }
        return comp;
    }

    private Component getHeterozygousRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        int site = this.myAlignmentTableModel.getRealColumnIndex(col);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (this.myAlignment.isHeterozygous(row, site)) {
            comp.setBackground(HETEROZYGOUS_COLOR);
        } else {
            comp.setBackground(null);
        }
        return comp;
    }

    private Component getMinorAlleleRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        int site = this.myAlignmentTableModel.getRealColumnIndex(col);
        byte[] alleles = this.myCachedAlleles.get(site);
        if (alleles == null) {
            alleles = this.myAlignment.alleles(site);
            this.myCachedAlleles.put(site, alleles);
        }
        byte minor = 15;
        if (alleles.length > 1) {
            minor = alleles[1];
        }
        byte[] diploidValues = this.myAlignment.genotypeArray(row, site);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (diploidValues[0] == minor || diploidValues[1] == minor) {
            comp.setBackground(MINOR_ALLELE_COLOR);
        } else {
            comp.setBackground(null);
        }
        return comp;
    }

    private Component getMajorMinorAlleleRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        int site = this.myAlignmentTableModel.getRealColumnIndex(col);
        byte[] alleles = this.myCachedAlleles.get(site);
        if (alleles == null) {
            alleles = this.myAlignment.alleles(site);
            this.myCachedAlleles.put(site, alleles);
        }
        byte[] diploidValues = this.myAlignment.genotypeArray(row, site);
        if (alleles.length > 1) {
            byte major = alleles[0];
            byte minor = alleles[1];
            if (isSelected) {
                comp.setBackground(Color.DARK_GRAY);
            } else if (diploidValues[0] == major && diploidValues[1] == minor || diploidValues[0] == minor && diploidValues[1] == major) {
                comp.setBackground(MAJOR_MINOR_ALLELE_COLOR);
            } else if (diploidValues[0] == major || diploidValues[1] == major) {
                comp.setBackground(MAJOR_ALLELE_COLOR);
            } else if (diploidValues[0] == minor || diploidValues[1] == minor) {
                comp.setBackground(MINOR_ALLELE_COLOR);
            } else {
                comp.setBackground(null);
            }
        } else if (alleles.length == 1) {
            byte major = alleles[0];
            if (isSelected) {
                comp.setBackground(Color.DARK_GRAY);
            } else if (diploidValues[0] == major || diploidValues[1] == major) {
                comp.setBackground(MAJOR_ALLELE_COLOR);
            } else {
                comp.setBackground(null);
            }
        } else if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else {
            comp.setBackground(null);
        }
        return comp;
    }

    public Component getReferenceMasksRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        GenotypeTableMask[] masks = this.getAlignmentMasksOfClass(GenotypeTableMaskReference.class);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (masks == null || masks.length == 0) {
            comp.setBackground(null);
        } else if (masks.length == 1) {
            if (masks[0].getMask(row, this.myAlignmentTableModel.getRealColumnIndex(col)) == 1) {
                comp.setBackground(masks[0].getColor());
            } else {
                comp.setBackground(null);
            }
        } else {
            int red = 0;
            int green = 0;
            int blue = 0;
            boolean changed = false;
            for (int i = 0; i < masks.length; ++i) {
                if (masks[i].getMask(row, this.myAlignmentTableModel.getRealColumnIndex(col)) != 1) continue;
                red += masks[i].getColor().getRed();
                green += masks[i].getColor().getGreen();
                blue += masks[i].getColor().getBlue();
                changed = true;
            }
            if (changed) {
                comp.setBackground(new Color(red %= 256, green %= 256, blue %= 256));
            } else {
                comp.setBackground(null);
            }
        }
        return comp;
    }

    private Component getProjectionRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        int site = this.myAlignmentTableModel.getRealColumnIndex(col);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else {
            Optional<DonorHaplotypes> optional = this.donorHaplotype(row, site);
            if (optional.isPresent()) {
                DonorHaplotypes dh = optional.get();
                int color = PROJECTION_MASKS[row % 3];
                color = color | dh.getStartPosition() | dh.getEndPosition();
                comp.setBackground(new Color(color));
            } else {
                comp.setBackground(null);
            }
        }
        return comp;
    }

    private Optional<DonorHaplotypes> donorHaplotype(int taxon, int site) {
        Position position = (Position)this.myAlignment.positions().get(site);
        int physical = position.getPosition();
        return ((ProjectionGenotypeCallTable)this.myAlignment.genotypeMatrix()).getDonorHaplotypes(taxon).stream().filter(dh -> dh.getChromosome().equals(position.getChromosome())).filter(dh -> physical >= dh.getStartPosition() && physical <= dh.getEndPosition()).findFirst();
    }

    public Component getReferenceProbabilityRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else {
            int site = this.myAlignmentTableModel.getRealColumnIndex(col);
            float probability = this.myAlignment.referenceProbability().value(row, site);
            if (Float.isNaN(probability)) {
                comp.setBackground(Color.GRAY);
            } else {
                comp.setBackground(COLORS_256[255 - Math.round(probability * 255.0f)]);
            }
        }
        return comp;
    }

    public Component getGeneticDistanceMasksRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        GenotypeTableMask[] masks = this.getAlignmentMasksOfClass(GenotypeTableMaskGeneticDistance.class);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (masks == null || masks.length == 0) {
            comp.setBackground(null);
        } else {
            int aveDistance = 0;
            for (int i = 0; i < masks.length; ++i) {
                aveDistance += 0xFF & masks[i].getMask(row, this.myAlignmentTableModel.getRealColumnIndex(col));
            }
            comp.setBackground(COLORS_256[aveDistance /= masks.length]);
        }
        return comp;
    }

    public Component getDepthMasksRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.setHorizontalAlignment(0);
        if (isSelected) {
            comp.setBackground(Color.DARK_GRAY);
        } else if (!this.myAlignment.hasDepth()) {
            comp.setBackground(null);
        } else {
            int depth = 0;
            int site = this.myAlignmentTableModel.getRealColumnIndex(col);
            byte[] diploidValues = this.myAlignment.genotypeArray(row, site);
            int[] depths = this.myAlignment.depthForAlleles(row, site);
            if (diploidValues[0] < 6) {
                depth = depths[diploidValues[0]];
            }
            if (diploidValues[1] < 6 && diploidValues[1] != diploidValues[0]) {
                depth += depths[diploidValues[1]];
            }
            if (depth == 0) {
                comp.setBackground(null);
            } else {
                if ((depth *= 30) > 255) {
                    depth = 255;
                }
                comp.setBackground(COLORS_256[255 - depth]);
            }
        }
        return comp;
    }

    private static Color[] generateColors(int n) {
        Color[] cols = new Color[n];
        for (int i = 0; i < n; ++i) {
            cols[i] = Color.getHSBColor((float)i / (float)n * 0.6f, 0.85f, 0.9f);
        }
        return cols;
    }

    private static Map<String, Color> generateNucleotideColors() {
        HashMap<String, Color> result = new HashMap<String, Color>();
        for (Map.Entry<Byte, String> current : NucleotideAlignmentConstants.NUCLEOTIDE_IUPAC_HASH.entrySet()) {
            result.put(current.getValue(), Color.BLACK);
        }
        int numCodes = result.size();
        Iterator<Map.Entry<Byte, String>> itr = result.entrySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map.Entry<Byte, String> current = itr.next();
            Color color = Color.getHSBColor((float)count / (float)(numCodes - 1), 0.7f, 0.9f);
            result.put((String)((Object)current.getKey()), color);
            ++count;
        }
        return result;
    }

    private GenotypeTableMask[] getAlignmentMasksOfClass(Class type) {
        if (this.myMasks == null || this.myMasks.length == 0) {
            return null;
        }
        ArrayList<GenotypeTableMask> masks = new ArrayList<GenotypeTableMask>();
        for (int i = 0; i < this.myMasks.length; ++i) {
            if (!type.isInstance(this.myMasks[i])) continue;
            masks.add(this.myMasks[i]);
        }
        GenotypeTableMask[] result = new GenotypeTableMask[masks.size()];
        masks.toArray(result);
        return result;
    }

    public RENDERING_TYPE getRenderingType() {
        return this.myRenderingType;
    }

    public final void setRenderingType(RENDERING_TYPE type) {
        this.myRenderingType = type;
        this.myAlignmentTableModel.setRenderingType(type);
    }

    public void setMasks(GenotypeTableMask[] masks) {
        this.myMasks = masks;
    }

    public RENDERING_TYPE[] getRenderingTypes() {
        return this.mySupportedRenderingTypes;
    }

    static {
        AlignmentTableCellRenderer.NUCLEOTIDE_COLORS[0] = 0xFA0000;
        AlignmentTableCellRenderer.NUCLEOTIDE_COLORS[1] = 10210715;
        AlignmentTableCellRenderer.NUCLEOTIDE_COLORS[2] = 4749055;
        AlignmentTableCellRenderer.NUCLEOTIDE_COLORS[3] = 0x777D7E;
        AlignmentTableCellRenderer.NUCLEOTIDE_COLORS[5] = 0xFFF68F;
        AlignmentTableCellRenderer.NUCLEOTIDE_COLORS[4] = 16747520;
        MAJOR_ALLELE_COLOR = new Color(15126341);
        MINOR_ALLELE_COLOR = new Color(4563430);
        HETEROZYGOUS_COLOR = new Color(15091013);
        MAJOR_MINOR_ALLELE_COLOR = new Color((MAJOR_ALLELE_COLOR.getRGB() + MINOR_ALLELE_COLOR.getRGB()) % 0xFFFFFF);
        COLORS_256 = AlignmentTableCellRenderer.generateColors(256);
        COLORS_NUCLEOTIDES = AlignmentTableCellRenderer.generateNucleotideColors();
        GENOTYPE_RENDERING_TYPES = new RENDERING_TYPE[]{RENDERING_TYPE.MajorMinorAllele, RENDERING_TYPE.MajorAllele, RENDERING_TYPE.MinorAllele, RENDERING_TYPE.Heterozygous, RENDERING_TYPE.ReferenceMasks, RENDERING_TYPE.GeneticDistanceMasks, RENDERING_TYPE.None};
        PROJECTION_MASKS = new int[]{255, 65280, 0xFF0000};
    }

    public static enum RENDERING_TYPE {
        Nucleotide,
        NucleotideHeterozygous,
        MajorAllele,
        MinorAllele,
        MajorMinorAllele,
        Heterozygous,
        ReferenceMasks,
        GeneticDistanceMasks,
        Depth,
        None,
        TOPM,
        SNPs,
        NumericGenotype,
        Projection;

    }
}

