/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.AbstractGenotypeTableMask;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.taxa.Taxon;

public class GenotypeTableMaskBoolean
extends AbstractGenotypeTableMask {
    private static final long serialVersionUID = -5197800047652332969L;
    private final byte[][] myMask;

    public GenotypeTableMaskBoolean(GenotypeTable align, byte[][] mask, String name, GenotypeTableMask.MaskType type) {
        this(align, mask, name, GenotypeTableMaskBoolean.getNextColor(), type);
    }

    public GenotypeTableMaskBoolean(GenotypeTable align, byte[][] mask, String name, Color color, GenotypeTableMask.MaskType type) {
        super(align, name, color, type);
        if (mask.length != align.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: init: number of mask rows should equal number of sequences.");
        }
        int numBytesNeeded = GenotypeTableMaskBoolean.getNumMaskColumns(align.numberOfSites());
        if (numBytesNeeded != mask[0].length) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: init: incorrect number of mask columns: " + mask[0].length + "  should be: " + numBytesNeeded);
        }
        this.myMask = mask;
    }

    public static GenotypeTableMaskBoolean getInstanceCompareReference(GenotypeTable align) {
        String name = align.taxaName(0) + " Reference";
        return GenotypeTableMaskBoolean.getInstanceCompareReference(align, align.genotypeRange(0, 0, align.numberOfSites()), name);
    }

    public static GenotypeTableMaskBoolean getInstanceCompareReference(GenotypeTable align, Taxon id) {
        int index = align.taxa().indexOf(id);
        if (index < 0) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: getInstanceCompareReference: unknown id: " + id);
        }
        String name = id.getName() + " Reference";
        return GenotypeTableMaskBoolean.getInstanceCompareReference(align, align.genotypeRange(index, 0, align.numberOfSites()), name);
    }

    public static GenotypeTableMaskBoolean getInstanceCompareReference(GenotypeTable align, int index) {
        if (index < 0 || index >= align.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: getInstanceCompareReference: unknown index: " + index);
        }
        String name = align.taxaName(index) + " Reference";
        return GenotypeTableMaskBoolean.getInstanceCompareReference(align, align.genotypeRange(index, 0, align.numberOfSites()), name);
    }

    public static GenotypeTableMaskBoolean getInstanceCompareReference(GenotypeTable align, String id) {
        int index = align.taxa().indexOf(id);
        if (index < 0) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: getInstanceCompareReference: unknown id: " + id);
        }
        return GenotypeTableMaskBoolean.getInstanceCompareReference(align, align.genotypeRange(index, 0, align.numberOfSites()), id + " Reference");
    }

    public static GenotypeTableMaskBoolean getInstanceCompareReference(GenotypeTable align, byte[] ref, String name) {
        if (align == null || ref == null) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: getInstanceCompareReference: alignment or reference can not be null.");
        }
        if (align.numberOfSites() != ref.length) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: getInstanceCompareReference: ref length should equal alignment site count.");
        }
        int numMaskColumns = GenotypeTableMaskBoolean.getNumMaskColumns(ref.length);
        byte[][] mask = new byte[align.numberOfTaxa()][numMaskColumns];
        int n = align.numberOfSites();
        for (int c = 0; c < n; ++c) {
            int currentByteCol = c / 8;
            byte currentColMask = (byte)(128 >>> c % 8);
            int m = align.numberOfTaxa();
            for (int r = 0; r < m; ++r) {
                if (align.genotype(r, c) == ref[c]) continue;
                mask[r][currentByteCol] = (byte)(mask[r][currentByteCol] | currentColMask);
            }
        }
        return new GenotypeTableMaskBoolean(align, mask, name, GenotypeTableMask.MaskType.reference);
    }

    public static GenotypeTableMaskBoolean getInstanceCompareAlignments(GenotypeTable align1, GenotypeTable align2, String name, GenotypeTableMask.MaskType type) {
        if (align1.numberOfTaxa() != align2.numberOfTaxa() || align1.numberOfSites() != align2.numberOfSites()) {
            throw new IllegalArgumentException("GenotypeTableMaskBoolean: getInstanceCompareAlignments: both alignments should have same number of sequences and sites.");
        }
        int numMaskColumns = GenotypeTableMaskBoolean.getNumMaskColumns(align1.numberOfSites());
        byte[][] mask = new byte[align1.numberOfTaxa()][numMaskColumns];
        int n = align1.numberOfSites();
        for (int c = 0; c < n; ++c) {
            int currentByteCol = c / 8;
            byte currentColMask = (byte)(128 >>> c % 8);
            int m = align1.numberOfTaxa();
            for (int r = 0; r < m; ++r) {
                if (align1.genotype(r, c) == align2.genotype(r, c)) continue;
                mask[r][currentByteCol] = (byte)(mask[r][currentByteCol] | currentColMask);
            }
        }
        return new GenotypeTableMaskBoolean(align1, mask, name, type);
    }

    private static int getNumMaskColumns(int numSites) {
        int numMaskColumns = numSites / 8;
        if (numSites % 8 > 0) {
            ++numMaskColumns;
        }
        return numMaskColumns;
    }

    @Override
    public byte getMask(int taxon, int site) {
        int maskColumn = site / 8;
        int shift = 7 - site % 8;
        return (byte)(this.myMask[taxon][maskColumn] >>> shift & 1);
    }
}

