/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import org.ejml.data.DenseMatrix64F;

public class ColtEigenvalueDecomposition
implements EigenvalueDecomposition {
    cern.colt.matrix.linalg.EigenvalueDecomposition myDecomposition;

    public ColtEigenvalueDecomposition(DoubleMatrix dm) {
        int nrows = dm.numberOfRows();
        int ncols = dm.numberOfColumns();
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(nrows, ncols);
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                matrix.setQuick(r, c, dm.get(r, c));
            }
        }
        this.myDecomposition = new cern.colt.matrix.linalg.EigenvalueDecomposition(matrix);
    }

    public ColtEigenvalueDecomposition(DenseMatrix64F dm) {
        int nrows = dm.numRows;
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(dm.data, nrows);
        this.myDecomposition = new cern.colt.matrix.linalg.EigenvalueDecomposition(matrix);
    }

    public ColtEigenvalueDecomposition(DoubleMatrix2D matrix) {
        this.myDecomposition = new cern.colt.matrix.linalg.EigenvalueDecomposition(matrix);
    }

    @Override
    public double[] getEigenvalues() {
        return this.myDecomposition.getRealEigenvalues().toArray();
    }

    @Override
    public double getEigenvalue(int i) {
        return this.myDecomposition.getRealEigenvalues().get(i);
    }

    @Override
    public DoubleMatrix getEigenvectors() {
        DoubleMatrix2D V = this.myDecomposition.getV();
        int nrows = V.rows();
        int ncols = V.columns();
        DoubleMatrix dm = DoubleMatrixFactory.DEFAULT.make(nrows, ncols);
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                dm.set(r, c, V.getQuick(r, c));
            }
        }
        return dm;
    }

    @Override
    public DoubleMatrix getEigenvalueMatrix() {
        double[] eigenvalues = this.getEigenvalues();
        return DoubleMatrixFactory.DEFAULT.diagonal(eigenvalues);
    }
}

