/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.Matrix.EJMLDoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.ops.SingularOps;

public class EJMLSingularValueDecomposition
implements SingularValueDecomposition {
    org.ejml.factory.SingularValueDecomposition<DenseMatrix64F> myDecomposition;
    boolean successful;
    int rank = -1;

    public EJMLSingularValueDecomposition(DenseMatrix64F matrix) {
        this.myDecomposition = DecompositionFactory.svd((int)matrix.numRows, (int)matrix.numCols, (boolean)true, (boolean)true, (boolean)true);
        this.successful = this.myDecomposition.decompose((Matrix64F)matrix);
    }

    @Override
    public DoubleMatrix getS() {
        double[] singularValues = this.myDecomposition.getSingularValues();
        return DoubleMatrixFactory.DEFAULT.diagonal(singularValues);
    }

    @Override
    public double[] getSingularValues() {
        return this.myDecomposition.getSingularValues();
    }

    @Override
    public DoubleMatrix getU(boolean transpose) {
        return new EJMLDoubleMatrix((DenseMatrix64F)this.myDecomposition.getU(null, transpose));
    }

    @Override
    public DoubleMatrix getV(boolean transpose) {
        return new EJMLDoubleMatrix((DenseMatrix64F)this.myDecomposition.getV(null, transpose));
    }

    boolean wasSuccessful() {
        return this.successful;
    }

    @Override
    public int getRank() {
        this.rank = SingularOps.rank(this.myDecomposition, (double)1.0E-12);
        return this.rank;
    }
}

