/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.pipeline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.maizegenetics.pipeline.TasselPipeline;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TasselPipelineXMLUtil {
    private static final Logger myLogger = Logger.getLogger(TasselPipelineXMLUtil.class);
    private static final int DEFAULT_LINE_LENGTH = 50;

    private TasselPipelineXMLUtil() {
    }

    public static void writeArgsAsXML(String filename, String[] args) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("TasselPipeline");
            doc.appendChild(rootElement);
            TasselPipelineXMLUtil.createXML(doc, rootElement, args);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("method", "xml");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filename));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createXML(Document doc, Element element, String[] args) throws IOException {
        int index = 0;
        while (index < args.length) {
            String current = args[index];
            if (!TasselPipelineXMLUtil.isFork(current)) {
                throw new IllegalArgumentException("TasselPipelineXMLUtil: createXML: this flag should be either -fork, -combine, or -runfork: " + current);
            }
            Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
            while (++index < args.length && !TasselPipelineXMLUtil.isFork(args[index])) {
                if (TasselPipelineXMLUtil.isSelfDescribingPlugin(args[index])) {
                    index = TasselPipelineXMLUtil.createSelfDescribingPluginXML(doc, newElement, args, index);
                    continue;
                }
                if (TasselPipelineXMLUtil.isModifier(args[index])) {
                    index = TasselPipelineXMLUtil.createString(doc, newElement, args, index);
                    continue;
                }
                index = TasselPipelineXMLUtil.createXML(doc, newElement, args, index);
            }
        }
    }

    private static int createXML(Document doc, Element element, String[] args, int index) throws IOException {
        String current = args[index];
        Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
        while (++index < args.length && TasselPipelineXMLUtil.isModifier(args[index])) {
            index = TasselPipelineXMLUtil.createString(doc, newElement, args, index);
        }
        return index - 1;
    }

    private static int createSelfDescribingPluginXML(Document doc, Element element, String[] args, int index) throws IOException {
        String current = args[index];
        Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
        while (++index < args.length) {
            if (args[index].equalsIgnoreCase("-endPlugin")) {
                ++index;
                break;
            }
            if (args[index].startsWith("-runfork")) break;
            index = TasselPipelineXMLUtil.createString(doc, newElement, args, index);
        }
        return index - 1;
    }

    private static boolean isFork(String str) {
        return str.startsWith("-fork") || str.startsWith("-runfork") || str.startsWith("-combine");
    }

    private static boolean isModifier(String str) {
        if (str.startsWith("-")) {
            TasselPipeline.FLAGS temp = null;
            try {
                temp = TasselPipeline.FLAGS.valueOf(str.substring(1));
            }
            catch (Exception e) {
                temp = null;
            }
            if (str.startsWith("-fork") || str.startsWith("-runfork") || str.startsWith("-combine")) {
                return false;
            }
            if (temp != null) {
                return false;
            }
            return !TasselPipelineXMLUtil.isSelfDescribingPlugin(str);
        }
        return true;
    }

    private static boolean isSelfDescribingPlugin(String str) {
        if (str.startsWith("-")) {
            str = str.substring(1);
        }
        List<String> matches = Utils.getFullyQualifiedClassNames(str);
        for (String current : matches) {
            if (!Plugin.isPlugin(current)) continue;
            return true;
        }
        return false;
    }

    private static Element createTag(Document doc, Element element, String tag) {
        String str = tag.substring(tag.lastIndexOf(45) + 1);
        Element tagElement = doc.createElement(str);
        element.appendChild(tagElement);
        return tagElement;
    }

    private static int createString(Document doc, Element element, String[] args, int index) throws IOException {
        String current = args[index].substring(args[index].lastIndexOf(45) + 1);
        if (args[index].startsWith("-")) {
            Element newElement = TasselPipelineXMLUtil.createTag(doc, element, current);
            while (true) {
                if (++index >= args.length) {
                    return index - 1;
                }
                if (args[index].startsWith("-")) {
                    return index - 1;
                }
                newElement.appendChild(doc.createTextNode(args[index]));
            }
        }
        element.appendChild(doc.createTextNode(current));
        return index;
    }

    public static String[][] readXMLAsArgs(String filename) {
        try {
            File fXmlFile = new File(filename);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            return TasselPipelineXMLUtil.readXMLAsArgs(doc);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TasselPipelineXMLUtil: readXMLAsArgs: Problem reading XML file: " + filename + "\n" + e.getMessage());
        }
    }

    public static String[][] readXMLAsArgsFromResource(String filename) {
        try {
            InputStream input = TasselPipelineXMLUtil.class.getResourceAsStream(filename);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            return TasselPipelineXMLUtil.readXMLAsArgs(doc);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TasselPipelineXMLUtil: readXMLAsArgsFromResource: Problem reading XML file: " + filename + "\n" + e.getMessage());
        }
    }

    private static String[][] readXMLAsArgs(Document doc) {
        try {
            doc.getDocumentElement().normalize();
            Element rootElement = doc.getDocumentElement();
            if (!rootElement.getNodeName().equalsIgnoreCase("TasselPipeline")) {
                throw new IllegalArgumentException("TasselPipelineXMLUtil: readXMLAsArgs: Root Node must be TasselPipeline: " + rootElement.getNodeName());
            }
            ArrayList<String> temp = new ArrayList<String>();
            ArrayList<String> workflow = new ArrayList<String>();
            NodeList children = rootElement.getChildNodes();
            String overallDescription = null;
            String citation = null;
            block2: for (int i = 0; i < children.getLength(); ++i) {
                String value;
                Node currentDesc;
                int j;
                NodeList descNodes;
                Node current = children.item(i);
                if (current.getNodeType() == 1 && current.getNodeName().trim().equals("workflow")) {
                    descNodes = current.getChildNodes();
                    for (j = 0; j < descNodes.getLength(); ++j) {
                        currentDesc = descNodes.item(j);
                        if (currentDesc.getNodeType() != 3) continue;
                        value = currentDesc.getNodeValue().trim();
                        overallDescription = TasselPipelineXMLUtil.formatDescription(value);
                        continue block2;
                    }
                    continue;
                }
                if (current.getNodeType() == 1 && current.getNodeName().trim().equals("citation")) {
                    descNodes = current.getChildNodes();
                    for (j = 0; j < descNodes.getLength(); ++j) {
                        currentDesc = descNodes.item(j);
                        if (currentDesc.getNodeType() != 3) continue;
                        value = "Citation: " + currentDesc.getNodeValue().trim();
                        citation = TasselPipelineXMLUtil.formatDescription(value);
                        continue block2;
                    }
                    continue;
                }
                TasselPipelineXMLUtil.getFlags(current, temp, workflow);
            }
            if (temp.size() != workflow.size()) {
                throw new IllegalStateException("TasselPipelineXMLUtil: readXMLAsArgs: number of flags and descriptions should be the same.");
            }
            String[] args = new String[temp.size()];
            temp.toArray(args);
            String[] descriptions = new String[workflow.size()];
            workflow.toArray(descriptions);
            String[][] result = new String[][]{args, descriptions, {overallDescription, citation}};
            return result;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TasselPipelineXMLUtil: readXMLAsArgs: Problem converting XML to Args: " + e.getMessage());
        }
    }

    private static void getFlags(Node node, List<String> flags, List<String> workflow) {
        if (node.getNodeType() != 1) {
            return;
        }
        String flagName = node.getNodeName().trim();
        int workflowIndex = flags.size();
        flags.add("-" + flagName);
        workflow.add(null);
        NodeList children = node.getChildNodes();
        block0: for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (current.getNodeType() == 3) {
                String temp = current.getNodeValue().trim();
                if (temp.length() == 0) continue;
                flags.add(temp);
                workflow.add(null);
                continue;
            }
            if (current.getNodeType() == 1 && current.getNodeName().trim().equals("workflow")) {
                NodeList descNodes = current.getChildNodes();
                for (int j = 0; j < descNodes.getLength(); ++j) {
                    Node currentDesc = descNodes.item(j);
                    if (currentDesc.getNodeType() != 3) continue;
                    workflow.remove(workflowIndex);
                    String value = currentDesc.getNodeValue().trim();
                    workflow.add(workflowIndex, TasselPipelineXMLUtil.formatDescription(value));
                    continue block0;
                }
                continue;
            }
            TasselPipelineXMLUtil.getFlags(current, flags, workflow);
        }
        if (TasselPipelineXMLUtil.isSelfDescribingPlugin(flagName)) {
            flags.add("-endPlugin");
            workflow.add(null);
        }
    }

    private static String formatDescription(String description) {
        description = description.replaceAll("\\s+", " ");
        int count = 0;
        StringBuilder builder = new StringBuilder();
        int n = description.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (description.charAt(i) == '\n') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            if (count > 50 && description.charAt(i) == ' ') {
                builder.append("<br>");
                count = 0;
                continue;
            }
            builder.append(description.charAt(i));
        }
        return builder.toString();
    }
}

