/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import com.google.common.base.CaseFormat;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.maizegenetics.analysis.association.FastMultithreadedAssociationPlugin;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.GenomicSelectionPlugin;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.filter.FilterSiteBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterTaxaBuilderPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.dna.snp.io.FlapjackUtils;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GenerateRCode {
    private static final Logger myLogger = Logger.getLogger(GenerateRCode.class);
    private static final int DEFAULT_DESCRIPTION_LINE_LENGTH = 50;

    private GenerateRCode() {
    }

    public static void main(String[] args) {
        GenerateRCode.printHeader();
        GenerateRCode.generate(FilterSiteBuilderPlugin.class, "genotypeTable", "genotypeTable");
        GenerateRCode.generate(FilterTaxaBuilderPlugin.class, "genotypeTable", "genotypeTable");
        GenerateRCode.generate(KinshipPlugin.class, "genotypeTable", "distanceMatrix");
        GenerateRCode.generate(FixedEffectLMPlugin.class, "phenotypeGenotypeTable", "tableReport");
    }

    private static void printHeader() {
        System.out.println("#!/usr/bin/env Rscript");
        System.out.println("\n#--------------------------------------------------------------------");
        System.out.println("# Script Name:   TasselPluginWrappers.R");
        System.out.println("# Description:   Generated R interface to TASSEL 5");
        System.out.println("# Author:        Brandon Monier, Ed Buckler, Terry Casstevens");
        System.out.print("# Created:       ");
        System.out.println(new Date());
        System.out.println("#--------------------------------------------------------------------");
        System.out.println("# Preamble\n");
        System.out.println("\n## Load packages");
        System.out.println("if (!requireNamespace(\"BiocManager\")) {");
        System.out.println("    install.packages(\"BiocManager\")");
        System.out.println("}");
        System.out.println("\npackages <- c(");
        System.out.println("\"rJava\"");
        System.out.println(")");
        System.out.println("BiocManager::install(packages)");
        System.out.println("library(rJava)");
        System.out.println("\n## Init JVM");
        System.out.println("rJava::.jinit()");
        System.out.println("\n## Add TASSEL 5 class path");
        System.out.println("rJava::.jaddClassPath(\"/tassel-5-standalone/lib\")");
        System.out.println("rJava::.jaddClassPath(\"/tassel-5-standalone/sTASSEL.jar\")\n");
        System.out.println("source(\"R/AllClasses.R\")\n");
    }

    public static void generate(Class currentMatch, String inputObject, String outputObject) {
        try {
            Constructor constructor = currentMatch.getConstructor(Frame.class);
            GenerateRCode.generate((AbstractPlugin)constructor.newInstance(new Object[]{null}), inputObject, outputObject);
        }
        catch (Exception ex) {
            try {
                Constructor constructor = currentMatch.getConstructor(Frame.class, Boolean.TYPE);
                GenerateRCode.generate((AbstractPlugin)constructor.newInstance(null, false), inputObject, outputObject);
            }
            catch (NoSuchMethodException nsme) {
                myLogger.warn((Object)("Self-describing Plugins should implement this constructor: " + currentMatch.getClass().getName()));
                myLogger.warn((Object)"public Plugin(Frame parentFrame, boolean isInteractive) {");
                myLogger.warn((Object)"   super(parentFrame, isInteractive);");
                myLogger.warn((Object)"}");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void generate(AbstractPlugin plugin, String inputObject, String outputObject) {
        String methodName;
        PluginParameter current;
        String clazz = Utils.getBasename(plugin.getClass().getName());
        StringBuilder sb = new StringBuilder(GenerateRCode.stringToCamelCase(clazz));
        sb.append(" <- function(");
        sb.append(inputObject + ",\n");
        for (Field field : plugin.getParameterFields()) {
            current = null;
            try {
                current = (PluginParameter)field.get(plugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            methodName = current.cmdLineName();
            if (current.defaultValue() instanceof Number || current.defaultValue() instanceof Boolean || current.defaultValue() instanceof String) {
                sb.append("            " + methodName + "=" + current.defaultValue() + ",\n");
                continue;
            }
            if (current.defaultValue() instanceof Enum) {
                sb.append("            " + methodName + "=\"" + current.defaultValue() + "\",\n");
                continue;
            }
            if (!(current.defaultValue() instanceof Boolean)) continue;
            sb.append("            " + methodName + "=\"" + current.defaultValue() + "\",\n");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append(") {\n");
        if (inputObject.equals("genotypeTable")) {
            sb.append("    if(is(genotypeTable, \"GenotypeTable\") == TRUE) {\n");
            sb.append("        genotypeTable <- genotypeTable@jtsGenotypeTable\n");
            sb.append("    }\n");
        }
        sb.append("    plugin <- new(J(\"" + plugin.getClass().getCanonicalName() + "\"), .jnull(), FALSE)\n");
        for (Field field : plugin.getParameterFields()) {
            current = null;
            try {
                current = (PluginParameter)field.get(plugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            methodName = current.cmdLineName();
            if (current.defaultValue() instanceof Number || current.defaultValue() instanceof Boolean || current.defaultValue() instanceof String) {
                sb.append("    plugin$setParameter(\"" + methodName + "\",toString(" + methodName + "))\n");
                continue;
            }
            if (current.defaultValue() instanceof Enum) {
                sb.append("    plugin$setParameter(\"" + methodName + "\",toString(" + methodName + "))\n");
                continue;
            }
            if (!(current.defaultValue() instanceof Boolean)) continue;
            sb.append("    plugin$setParameter(\"" + methodName + "\",toString(" + methodName + "))\n");
        }
        if (outputObject.equals("genotypeTable")) {
            sb.append("    filteredGT <- plugin$runPlugin(" + inputObject + ")\n");
            sb.append("    new(\n");
            sb.append("        Class = \"GenotypeTable\",\n");
            sb.append("        name = paste0(\"Filtered:\"),\n");
            sb.append("        jtsGenotypeTable = filteredGT\n");
            sb.append("    )\n");
        } else {
            sb.append("    plugin$runPlugin(" + inputObject + ")\n");
        }
        sb.append("}\n");
        System.out.println(sb.toString());
    }

    private static String createDescription(String description) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("     * ");
        int n = description.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (description.charAt(i) == '\n') {
                builder.append("\n");
                builder.append("     * ");
                count = 0;
                continue;
            }
            if (count > 50 && description.charAt(i) == ' ') {
                builder.append("\n");
                builder.append("     * ");
                count = 0;
                continue;
            }
            builder.append(description.charAt(i));
        }
        return builder.toString();
    }

    private static String stringToCamelCase(String str) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toLowerCase(str.charAt(0)));
        boolean makeUpper = false;
        for (int i = 1; i < str.length(); ++i) {
            char current = str.charAt(i);
            if (current == ' ') {
                makeUpper = true;
                continue;
            }
            if (makeUpper) {
                builder.append(Character.toUpperCase(current));
                makeUpper = false;
                continue;
            }
            builder.append(current);
        }
        return builder.toString();
    }

    private static String removeMyFromString(String str) {
        String lower = str.toLowerCase();
        if (lower.startsWith("my")) {
            str = str.substring(2);
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, str);
    }

    public static byte[][] genotypeTableToDosageByteArray(GenotypeTable genotype, boolean useRef) {
        byte[][] result = new byte[genotype.numberOfTaxa()][genotype.numberOfSites()];
        PositionList posList = genotype.positions();
        for (int site = 0; site < genotype.numberOfSites(); ++site) {
            byte refAllele;
            byte[] siteGenotypes = genotype.genotypeAllTaxa(site);
            Position posAtSite = (Position)posList.get(site);
            if (useRef) {
                myLogger.info((Object)"genotypeTableToDosageIntArray: using refAllele at sites");
                refAllele = posAtSite.getAllele(WHICH_ALLELE.Reference);
            } else {
                myLogger.info((Object)"genotypeTableToDosageIntArray: using majorAllele for ref at sites");
                int[][] alleleCounts = AlleleFreqCache.allelesSortedByFrequencyNucleotide(siteGenotypes);
                refAllele = AlleleFreqCache.majorAllele(alleleCounts);
            }
            for (int taxon = 0; taxon < genotype.numberOfTaxa(); ++taxon) {
                int value = 0;
                byte[] alleles = GenotypeTableUtils.getDiploidValues(siteGenotypes[taxon]);
                if (alleles[0] == 15 || alleles[1] == 15) {
                    value = -128;
                } else {
                    if (alleles[0] != refAllele) {
                        value = (byte)(value + 1);
                    }
                    if (alleles[1] != refAllele) {
                        value = (byte)(value + 1);
                    }
                }
                result[taxon][site] = value;
            }
        }
        return result;
    }

    public static String[] genotypeTableToSampleNameArray(GenotypeTable genotype) {
        return GenerateRCode.genotypeTableToSampleNameArray(genotype.taxa());
    }

    public static String[] genotypeTableToSampleNameArray(TaxaList taxa) {
        return (String[])taxa.stream().map(Taxon::getName).toArray(String[]::new);
    }

    public static PositionVectors genotypeTableToPositionListOfArrays(PositionList positions) {
        String[] chromosomes = new String[positions.numberOfSites()];
        int[] startPos = new int[positions.numberOfSites()];
        int[] strand = new int[positions.numberOfSites()];
        String[] refAllele = new String[positions.numberOfSites()];
        String[] altAllele = new String[positions.numberOfSites()];
        for (int site = 0; site < positions.numberOfSites(); ++site) {
            Position p = (Position)positions.get(site);
            chromosomes[site] = p.getChromosome().getName();
            startPos[site] = p.getPosition();
            strand[site] = p.getStrand() == 1 ? 1 : (p.getStrand() == 0 ? -1 : Integer.MIN_VALUE);
            String[] variants = p.getKnownVariants();
            refAllele[site] = variants.length > 0 ? variants[0] : "";
            altAllele[site] = variants.length > 1 ? variants[1] : "";
        }
        return new PositionVectors(chromosomes, startPos, strand, refAllele, altAllele);
    }

    public static PositionVectors genotypeTableToPositionListOfArrays(GenotypeTable genotype) {
        return GenerateRCode.genotypeTableToPositionListOfArrays(genotype.positions());
    }

    public static TableReportVectors tableReportToVectors(TableReport tableReport) {
        if (tableReport.getRowCount() > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("R cannot handle more than 2147483647 rows");
        }
        int rows = (int)tableReport.getRowCount();
        String[] columnNames = (String[])Stream.of(tableReport.getTableColumnNames()).map(Object::toString).toArray(String[]::new);
        ArrayList<double[]> dataVector = new ArrayList<double[]>();
        String[] columnType = (String[])Stream.of(tableReport.getRow(0L)).map(t -> t.getClass().toString()).toArray(String[]::new);
        for (int column = 0; column < tableReport.getColumnCount(); ++column) {
            int row;
            Object[] result;
            Object o = tableReport.getValueAt(0L, column);
            if (o instanceof Float || o instanceof Double) {
                result = new double[rows];
                row = 0;
                while ((long)row < tableReport.getRowCount()) {
                    result[row] = ((Number)tableReport.getValueAt(row, column)).doubleValue();
                    ++row;
                }
                dataVector.add((double[])result);
                continue;
            }
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
                result = new int[rows];
                row = 0;
                while ((long)row < tableReport.getRowCount()) {
                    try {
                        result[row] = ((Number)tableReport.getValueAt(row, column)).intValue();
                    }
                    catch (ClassCastException cce) {
                        result[row] = Integer.MIN_VALUE;
                    }
                    ++row;
                }
                dataVector.add((double[])result);
                continue;
            }
            result = new String[rows];
            row = 0;
            while ((long)row < tableReport.getRowCount()) {
                result[row] = (double)tableReport.getValueAt(row, column).toString();
                ++row;
            }
            dataVector.add((double[])result);
        }
        String[] annotation = new String[tableReport.getColumnCount()];
        return new TableReportVectors(columnNames, columnType, annotation, dataVector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Phenotype createPhenotypeFromRDataFrameElements(String[] taxaArray, String[] colNames, String[] attributeType, List dataVectors) {
        if (colNames.length != attributeType.length || colNames.length != dataVectors.size()) {
            throw new IllegalArgumentException("ColNames, attributeType, and dataVectors need to be same size");
        }
        List<Taxon> taxaList = Stream.of(taxaArray).map(Taxon::new).collect(Collectors.toList());
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        TaxaAttribute ta = new TaxaAttribute(taxaList);
        attributes.add(ta);
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (int i = 0; i < colNames.length; ++i) {
            Phenotype.ATTRIBUTE_TYPE attribute_type;
            Object o = dataVectors.get(i);
            if (o instanceof double[]) {
                attributes.add(new NumericAttribute(colNames[i], (double[])o));
                attribute_type = Phenotype.ATTRIBUTE_TYPE.valueOf(attributeType[i]);
                types.add(attribute_type);
            } else if (o instanceof int[]) {
                int[] initialTraits = (int[])o;
                Phenotype.ATTRIBUTE_TYPE attribute_type2 = Phenotype.ATTRIBUTE_TYPE.valueOf(attributeType[i]);
                if (attribute_type2 == Phenotype.ATTRIBUTE_TYPE.data || attribute_type2 == Phenotype.ATTRIBUTE_TYPE.covariate) {
                    float[] traitsValueWithNaN = new float[initialTraits.length];
                    for (int j = 0; j < initialTraits.length; ++j) {
                        traitsValueWithNaN[j] = initialTraits[j] == Integer.MIN_VALUE ? Float.NaN : (float)initialTraits[j];
                    }
                    attributes.add(new NumericAttribute(colNames[i], traitsValueWithNaN));
                    types.add(attribute_type2);
                } else {
                    if (attribute_type2 != Phenotype.ATTRIBUTE_TYPE.factor) throw new IllegalArgumentException("attribute type of " + attributeType[i] + "inconsistent with data type of int for " + colNames[i]);
                    String[] categories = (String[])Arrays.stream(initialTraits).mapToObj(intval -> Integer.toString(intval)).toArray(String[]::new);
                    attributes.add(new CategoricalAttribute(colNames[i], categories));
                    types.add(attribute_type2);
                }
            } else {
                if (!(o instanceof String[])) throw new IllegalArgumentException("Unsupported type for phenotype table");
                attributes.add(new CategoricalAttribute(colNames[i], (String[])o));
                attribute_type = Phenotype.ATTRIBUTE_TYPE.valueOf(attributeType[i]);
                types.add(attribute_type);
            }
            System.out.println("phenotype column added: " + colNames[i] + "," + attributeType[i]);
        }
        return new PhenotypeBuilder().fromAttributeList(attributes, types).build().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> association(DistanceMatrix kinship, GenotypeTable genotype, Phenotype phenotype, GenotypePhenotype genoPheno, int minClassSize, boolean biallelicOnly, boolean appendAddDom, boolean saveToFile, String outputFile, double maxP) {
        String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
        myLogger.info((Object)("Starting association: time: " + timeStr));
        try {
            if (genotype == null && phenotype == null) {
                myLogger.warn((Object)"association: genotype and phenotype are null.  Nothing calculated");
            }
            if (kinship == null) {
                DataSet input;
                myLogger.info((Object)"association: running GLM");
                FixedEffectLMPlugin plugin = new FixedEffectLMPlugin(null, false);
                plugin.biallelicOnly(biallelicOnly);
                plugin.minClassSize(minClassSize);
                plugin.appendAddDom(appendAddDom);
                plugin.saveAsFile(saveToFile);
                plugin.siteReportFilename(outputFile + "_site");
                plugin.alleleReportFilename(outputFile + "_allele");
                plugin.bluesReportFilename(outputFile + "_blues");
                plugin.anovaReportFilename(outputFile + "_anova");
                plugin.maxPvalue(maxP);
                if (genotype == null) {
                    plugin.phenotypeOnly(true);
                    input = DataSet.getDataSet(phenotype);
                } else {
                    plugin.phenotypeOnly(false);
                    input = DataSet.getDataSet(genoPheno);
                }
                DataSet output = plugin.performFunction(input);
                Map<String, Object> map = GenerateRCode.tableReportsMap(output);
                return map;
            }
            myLogger.info((Object)"association: running MLM");
            MLMPlugin plugin = new MLMPlugin(null, false);
            plugin.setWriteOutputToFile(saveToFile);
            if (outputFile != null && !outputFile.isEmpty()) {
                plugin.setOutputName(outputFile);
            }
            Datum genoDatum = new Datum("GenotypePhenotype", genoPheno, null);
            Datum kinshipDatum = new Datum("Kinship", kinship, null);
            DataSet input = new DataSet(new Datum[]{genoDatum, kinshipDatum}, null);
            DataSet output = plugin.performFunction(input);
            Map<String, Object> map = GenerateRCode.tableReportsMap(output);
            return map;
        }
        finally {
            timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
            myLogger.info((Object)("Finished association: time: " + timeStr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> fastAssociation(GenotypePhenotype genoPheno, Double maxp, Integer maxThreads, boolean writeToFile, String outputFile) {
        String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
        myLogger.info((Object)("Starting fastAssociation: time: " + timeStr));
        try {
            if (genoPheno == null) {
                myLogger.warn((Object)"fastAssociation: GenotypePhenotype is null.  Nothing calculated");
            }
            FastMultithreadedAssociationPlugin plugin = new FastMultithreadedAssociationPlugin(null, false);
            if (maxp != null) {
                plugin.maxp(maxp);
            }
            if (maxThreads != null) {
                plugin.maxThreads(maxThreads);
            }
            plugin.saveAsFile(writeToFile);
            plugin.reportFilename(outputFile);
            DataSet input = DataSet.getDataSet(genoPheno);
            DataSet output = plugin.performFunction(input);
            Map<String, Object> map = GenerateRCode.tableReportsMap(output);
            return map;
        }
        finally {
            timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
            myLogger.info((Object)("Finished fastAssociation: time: " + timeStr));
        }
    }

    private static Map<String, Object> tableReportsMap(DataSet output) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (output == null) {
            return result;
        }
        for (Datum temp : output.getDataOfType(TableReport.class)) {
            String name = temp.getName();
            if (name.startsWith("GLM_Genotypes")) {
                result.put("GLM_Genotypes", temp.getData());
                continue;
            }
            if (name.startsWith("GLM_Stats")) {
                result.put("GLM_Stats", temp.getData());
                continue;
            }
            if (name.startsWith("MLM_statistics")) {
                result.put("MLM_Stats", temp.getData());
                continue;
            }
            if (name.startsWith("MLM_effects")) {
                result.put("MLM_Effects", temp.getData());
                continue;
            }
            if (name.startsWith("Residuals for")) {
                String[] tokens = name.split(" ");
                if (tokens[2].endsWith(".")) {
                    result.put("MLM_Residuals_" + tokens[2].substring(0, tokens[2].length() - 1), temp.getData());
                    continue;
                }
                result.put("MLM_Residuals_" + tokens[2], temp.getData());
                continue;
            }
            if (name.startsWith("MLM_compression")) {
                result.put("MLM_Compression", temp.getData());
                continue;
            }
            if (name.startsWith("BLUEs")) {
                result.put("BLUE", temp.getData());
                continue;
            }
            if (name.startsWith("Phenotype_ANOVA")) {
                result.put("BLUE_ANOVA", temp.getData());
                continue;
            }
            if (!name.startsWith("Fast Association")) continue;
            result.put("FastAssociation", temp.getData());
        }
        return result;
    }

    public static TableReport linkageDiseq(GenotypeTable genotype, String ldType, int windowSize, String hetTreatment) {
        LinkageDisequilibrium.testDesign testDesign2 = null;
        try {
            testDesign2 = LinkageDisequilibrium.testDesign.valueOf(ldType);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            myLogger.error((Object)("linkageDiseq: ldType: " + ldType + " is unknown"));
            throw new IllegalArgumentException("GenerateRCode: linkageDiseq: ldType: " + ldType + " is unknown");
        }
        LinkageDisequilibrium.HetTreatment treatment = null;
        if (hetTreatment.equalsIgnoreCase("ignore")) {
            treatment = LinkageDisequilibrium.HetTreatment.Haplotype;
        } else if (hetTreatment.equalsIgnoreCase("missing")) {
            treatment = LinkageDisequilibrium.HetTreatment.Homozygous;
        } else if (hetTreatment.equalsIgnoreCase("third")) {
            treatment = LinkageDisequilibrium.HetTreatment.Genotype;
        } else {
            myLogger.error((Object)("linkageDiseq: unknown LD Type: " + hetTreatment));
            throw new IllegalArgumentException("GenerateRCode: linkageDiseq: unknown LD Type: " + hetTreatment);
        }
        LinkageDisequilibrium result = new LinkageDisequilibrium(genotype, windowSize, testDesign2, -1, null, false, 100, null, treatment);
        result.run();
        return result;
    }

    public static void exportToFlapjack(GenotypeTable genotype, String filename) {
        FlapjackUtils.writeToFlapjack(genotype, filename, '\t');
    }

    public static GenotypeTable read(String filename, boolean keepDepth, boolean sortPositions) {
        return ImportUtils.read(filename, keepDepth, sortPositions);
    }

    public static TableReport genomicSelection(Phenotype phenotype, DistanceMatrix matrix, boolean doCV, int kFolds, int nIter) {
        GenomicSelectionPlugin plugin = new GenomicSelectionPlugin(null, false);
        plugin.performCrossValidation(doCV);
        plugin.kFolds(kFolds);
        plugin.nIterations(nIter);
        Datum phenoInput = new Datum("phenotype", phenotype, null);
        Datum matrixInput = new Datum("matrix", matrix, null);
        DataSet result = plugin.performFunction(new DataSet(new Datum[]{phenoInput, matrixInput}, null));
        return (TableReport)result.getDataOfType(TableReport.class).get(0).getData();
    }

    public static class TableReportVectors {
        public String[] columnNames;
        public String[] columnType;
        public String[] annotation;
        public List dataVector = new ArrayList();

        public TableReportVectors(String[] columnNames, String[] columnType, String[] annotation, List dataVector) {
            this.columnNames = columnNames;
            this.columnType = columnType;
            this.annotation = annotation;
            this.dataVector = dataVector;
        }
    }

    public static class PositionVectors {
        public String[] chromosomes;
        public int[] startPos;
        public int[] strand;
        public String[] refAllele;
        public String[] altAllele;

        public PositionVectors(String[] chromosomes, int[] startPos, int[] strand, String[] refAllele, String[] altAllele) {
            this.chromosomes = chromosomes;
            this.startPos = startPos;
            this.strand = strand;
            this.refAllele = refAllele;
            this.altAllele = altAllele;
        }
    }
}

