/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ParameterCache {
    private static final Logger myLogger = Logger.getLogger(ParameterCache.class);
    private static Properties CACHE = null;

    private ParameterCache() {
    }

    public static void load(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            CACHE = null;
            return;
        }
        myLogger.info((Object)("load: loading parameter cache with: " + filename));
        CACHE = new Properties();
        try (BufferedReader reader = Utils.getBufferedReader(filename);){
            CACHE.load(reader);
            CACHE.put("configFile", filename);
        }
        catch (Exception e) {
            CACHE = null;
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("ParameterCache: load: problem reading properties file: " + filename + "\n" + e.getMessage());
        }
        for (String key : CACHE.stringPropertyNames()) {
            myLogger.info((Object)("ParameterCache: key: " + key + " value: " + CACHE.getProperty(key)));
        }
        ParameterCache.verify(filename);
    }

    private static void verify(String filename) {
        for (Map.Entry<Object, Object> current : CACHE.entrySet()) {
            String match;
            int dot = ((String)current.getKey()).indexOf(46);
            if (dot == -1) continue;
            String possibleClassName = ((String)current.getKey()).substring(0, dot);
            Plugin plugin = null;
            List<String> matches = Utils.getFullyQualifiedClassNames(possibleClassName);
            Iterator<String> iterator = matches.iterator();
            while (iterator.hasNext() && (plugin = Plugin.getPluginInstance(match = iterator.next(), null)) == null) {
            }
            if (plugin == null) {
                throw new IllegalArgumentException("ParameterCache: verify: unknown plugin: " + possibleClassName + " in file: " + filename);
            }
            String parameterName = ((String)current.getKey()).substring(dot + 1);
            if (((AbstractPlugin)plugin).isPluginParameter(parameterName)) continue;
            throw new IllegalArgumentException("ParameterCache: verify: unknown parameter: " + parameterName + " for plugin: " + possibleClassName + " in file: " + filename);
        }
    }

    public static Optional<String> value(Plugin plugin, String parameter) {
        return ParameterCache.value(plugin.getClass().getName(), parameter);
    }

    public static Optional<String> value(String plugin, String parameter) {
        if (CACHE == null) {
            return Optional.empty();
        }
        String value = CACHE.getProperty(Utils.getBasename(plugin) + "." + parameter);
        if (value != null) {
            return Optional.of(value);
        }
        value = CACHE.getProperty(parameter);
        return Optional.ofNullable(value);
    }

    public static Optional<String> value(String key) {
        if (CACHE == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(CACHE.getProperty(key));
    }

    public static boolean hasValues() {
        return CACHE != null;
    }

    public static Enumeration<?> keys() {
        if (CACHE == null) {
            return null;
        }
        return CACHE.propertyNames();
    }
}

