/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.statistics;

import java.util.Arrays;

public class FisherExact {
    private static final boolean DEBUG = false;
    private static double[] factorialArray;
    private static int maxSize;
    private static FisherExact myFisherExact;

    public static FisherExact getInstance(int size) {
        if (myFisherExact == null) {
            myFisherExact = new FisherExact(size);
        } else if (size > maxSize) {
            factorialArray = FisherExact.resizeArray(size);
            maxSize = size;
        }
        return myFisherExact;
    }

    private FisherExact(int maxSize) {
        FisherExact.maxSize = maxSize;
        factorialArray = new double[maxSize + 1];
        FisherExact.factorialArray[0] = 0.0;
        for (int i = 1; i <= FisherExact.maxSize; ++i) {
            FisherExact.factorialArray[i] = factorialArray[i - 1] + Math.log(i);
        }
    }

    private static synchronized double[] resizeArray(int size) {
        int flength = factorialArray.length;
        maxSize = size;
        if (flength > size + 1) {
            return factorialArray;
        }
        double[] newF = Arrays.copyOf(factorialArray, size + 1);
        for (int idx = flength; idx <= size; ++idx) {
            newF[idx] = newF[idx - 1] + Math.log(idx);
        }
        return newF;
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > maxSize) {
            factorialArray = FisherExact.resizeArray(n);
        }
        double p = factorialArray[a + b] + factorialArray[c + d] + factorialArray[a + c] + factorialArray[b + d] - (factorialArray[a] + factorialArray[b] + factorialArray[c] + factorialArray[d] + factorialArray[n]);
        return Math.exp(p);
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > maxSize) {
            factorialArray = FisherExact.resizeArray(n);
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            for (i = 0; i < min; ++i) {
                p += this.getP(++a, --b, --c, ++d);
            }
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            for (i = 0; i < min; ++i) {
                double pTemp = this.getP(--a, ++b, ++c, --d);
                p += pTemp;
            }
        }
        return p;
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > maxSize) {
            factorialArray = FisherExact.resizeArray(n);
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        for (int i = 0; i < min; ++i) {
            p += this.getP(++a, --b, --c, ++d);
        }
        return p;
    }

    public final double getRightTailedPQuick(int a, int b, int c, int d, double maxP) {
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        for (int i = 0; i < min && p < maxP; p += this.getP(++a, --b, --c, ++d), ++i) {
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > maxSize) {
            factorialArray = FisherExact.resizeArray(n);
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = a < d ? a : d;
        for (int i = 0; i < min; ++i) {
            double pTemp = this.getP(--a, ++b, ++c, --d);
            p += pTemp;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        int i;
        int n = a + b + c + d;
        if (n > maxSize) {
            System.out.printf("LCJ - FE:getTwoTailedP, resize for a %d, b %d c %d d %d\n", a, b, c, d);
            factorialArray = FisherExact.resizeArray(n);
        }
        double p = 0.0;
        double baseP = this.getP(a, b, c, d);
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        p += baseP;
        int min = c < b ? c : b;
        for (i = 0; i < min; ++i) {
            double tempP;
            if (!((tempP = this.getP(++a, --b, --c, ++d)) <= baseP)) continue;
            p += tempP;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        min = a < d ? a : d;
        for (i = 0; i < min; ++i) {
            double pTemp;
            if (!((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP)) continue;
            p += pTemp;
        }
        return p;
    }
}

