/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.ParameterCache;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.tassel.TasselLogging;
import org.apache.log4j.Logger;

public class PreferencesDialog
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(PreferencesDialog.class);
    private PluginParameter<Boolean> myRetainRareAlleles = new PluginParameter.Builder<Boolean>("retainRareAlleles", false, Boolean.class).description("True if rare alleles should be retained.  This has no effect on Nucleotide Data as all alleles will be retained regardless.").build();
    private PluginParameter<Boolean> mySendLogToConsole = new PluginParameter.Builder<Boolean>("sendLogToConsole", false, Boolean.class).description("Flag whether to send logging to the console.").build();
    private PluginParameter<String> myConfigFile = new PluginParameter.Builder<String>("configFile", "", String.class).description("Global configuration file").required(false).inFile().build();
    private PluginParameter<LocaleWrapper> myLocale = new PluginParameter.Builder<LocaleWrapper>("locale", null, LocaleWrapper.class).description("Default locale for TASSEL").required(false).objectListSingleSelect().build();

    public PreferencesDialog(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        Locale locale = TasselPrefs.getLocale();
        Locale.setDefault(locale);
        myLogger.info((Object)("TasselPrefs: default locale set: " + locale.getDisplayName()));
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        this.setParameter(this.myRetainRareAlleles, (Object)TasselPrefs.getAlignmentRetainRareAlleles());
        this.setParameter(this.mySendLogToConsole, (Object)TasselPrefs.getLogSendToConsole());
        this.setParameter(this.myConfigFile, (Object)TasselPrefs.getConfigFile());
        ArrayList<LocaleWrapper> temp = new ArrayList<LocaleWrapper>();
        temp.add(new LocaleWrapper(TasselPrefs.getLocale()));
        temp.add(new LocaleWrapper(Locale.US));
        for (Locale current : Locale.getAvailableLocales()) {
            if (current.toString() == null || current.toString().isEmpty()) continue;
            temp.add(new LocaleWrapper(current));
        }
        this.myLocale = new PluginParameter<LocaleWrapper>(this.myLocale, temp);
    }

    @Override
    public DataSet processData(DataSet input) {
        TasselPrefs.putAlignmentRetainRareAlleles(this.retainRareAlleles());
        TasselPrefs.putLogSendToConsole(this.sendLogToConsole());
        TasselLogging.updateLoggingLocation();
        TasselPrefs.putConfigFile(this.configFile());
        ParameterCache.load(TasselPrefs.getConfigFile());
        TasselPrefs.putLocale(this.locale().myLocale);
        Locale.setDefault(this.locale().myLocale);
        ((TASSELMainFrame)this.getParentFrame()).updatePluginsWithGlobalConfigParameters();
        return null;
    }

    public Boolean retainRareAlleles() {
        return this.myRetainRareAlleles.value();
    }

    public PreferencesDialog retainRareAlleles(Boolean value) {
        this.myRetainRareAlleles = new PluginParameter<Boolean>(this.myRetainRareAlleles, value);
        return this;
    }

    public Boolean sendLogToConsole() {
        return this.mySendLogToConsole.value();
    }

    public PreferencesDialog sendLogToConsole(Boolean value) {
        this.mySendLogToConsole = new PluginParameter<Boolean>(this.mySendLogToConsole, value);
        return this;
    }

    public String configFile() {
        return this.myConfigFile.value();
    }

    public PreferencesDialog configFile(String value) {
        this.myConfigFile = new PluginParameter<String>(this.myConfigFile, value);
        return this;
    }

    public LocaleWrapper locale() {
        return this.myLocale.value();
    }

    public PreferencesDialog locale(LocaleWrapper value) {
        this.myLocale = new PluginParameter<LocaleWrapper>(this.myLocale, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = TasselLogging.class.getResource("/net/maizegenetics/analysis/images/preferences.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Preferences";
    }

    @Override
    public String getToolTipText() {
        return "Preferences";
    }

    private class LocaleWrapper {
        public final Locale myLocale;

        private LocaleWrapper(Locale locale) {
            this.myLocale = locale;
        }

        public String toString() {
            return this.myLocale.getDisplayName();
        }
    }
}

