/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.maizegenetics.analysis.association.FastMultithreadedAssociationPlugin;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.GenomicSelectionPlugin;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.association.WeightedMLMPlugin;
import net.maizegenetics.analysis.chart.ChartDisplayPlugin;
import net.maizegenetics.analysis.chart.ManhattanDisplayPlugin;
import net.maizegenetics.analysis.chart.QQDisplayPlugin;
import net.maizegenetics.analysis.chart.TableDisplayPlugin;
import net.maizegenetics.analysis.data.CreateHybridGenotypesPlugin;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.data.FindInversionsPlugin;
import net.maizegenetics.analysis.data.GenosToABHPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.data.GetPositionListPlugin;
import net.maizegenetics.analysis.data.GetTaxaListPlugin;
import net.maizegenetics.analysis.data.HetsToUnknownPlugin;
import net.maizegenetics.analysis.data.IdentityRecognitionPlugin;
import net.maizegenetics.analysis.data.IndelsToUnknownPlugin;
import net.maizegenetics.analysis.data.IntersectionAlignmentPlugin;
import net.maizegenetics.analysis.data.MaskGenotypePlugin;
import net.maizegenetics.analysis.data.MergeGenotypeTablesPlugin;
import net.maizegenetics.analysis.data.PrincipalComponentsPlugin;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.analysis.data.SetLowDepthGenosToMissingPlugin;
import net.maizegenetics.analysis.data.SortGenotypeFilePlugin;
import net.maizegenetics.analysis.data.SortTaxaAlphabeticallyPlugin;
import net.maizegenetics.analysis.data.SynonymizerPlugin;
import net.maizegenetics.analysis.data.ThinSitesByPositionPlugin;
import net.maizegenetics.analysis.data.UnionAlignmentPlugin;
import net.maizegenetics.analysis.distance.AMatrixPlugin;
import net.maizegenetics.analysis.distance.AddDistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.DistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.HMatrixPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.distance.MultiDimensionalScalingPlugin;
import net.maizegenetics.analysis.distance.RemoveNaNFromDistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.SubtractDistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.VCAPScanPlugin;
import net.maizegenetics.analysis.filter.FilterAlignmentPlugin;
import net.maizegenetics.analysis.filter.FilterSiteBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterSiteNamePlugin;
import net.maizegenetics.analysis.filter.FilterTaxaBuilderPlugin;
import net.maizegenetics.analysis.filter.FilterTaxaPropertiesPlugin;
import net.maizegenetics.analysis.filter.FilterTraitsPlugin;
import net.maizegenetics.analysis.gbs.BinaryToTextPlugin;
import net.maizegenetics.analysis.gbs.DiscoverySNPCallerPlugin;
import net.maizegenetics.analysis.gbs.FastqToTagCountPlugin;
import net.maizegenetics.analysis.gbs.MergeMultipleTagCountPlugin;
import net.maizegenetics.analysis.gbs.ModifyTBTHDF5Plugin;
import net.maizegenetics.analysis.gbs.ProductionSNPCallerPlugin;
import net.maizegenetics.analysis.gbs.SAMConverterPlugin;
import net.maizegenetics.analysis.gbs.SeqToTBTHDF5Plugin;
import net.maizegenetics.analysis.gbs.TagCountToFastqPlugin;
import net.maizegenetics.analysis.gbs.UTagCountToTagPairPlugin;
import net.maizegenetics.analysis.gbs.UTagPairToTOPMPlugin;
import net.maizegenetics.analysis.gbs.v2.DiscoverySNPCallerPluginV2;
import net.maizegenetics.analysis.gbs.v2.GBSSeqToTagDBPlugin;
import net.maizegenetics.analysis.gbs.v2.GetTagSequenceFromDBPlugin;
import net.maizegenetics.analysis.gbs.v2.ProductionSNPCallerPluginV2;
import net.maizegenetics.analysis.gbs.v2.SAMToGBSdbPlugin;
import net.maizegenetics.analysis.gbs.v2.SNPCutPosTagVerificationPlugin;
import net.maizegenetics.analysis.gbs.v2.SNPQualityProfilerPlugin;
import net.maizegenetics.analysis.gbs.v2.TagExportToFastqPlugin;
import net.maizegenetics.analysis.gbs.v2.UpdateSNPPositionQualityPlugin;
import net.maizegenetics.analysis.imputation.ClusterGenotypesPlugin;
import net.maizegenetics.analysis.imputation.FILLINFindHaplotypesPlugin;
import net.maizegenetics.analysis.imputation.FILLINImputationPlugin;
import net.maizegenetics.analysis.imputation.FSFHapImputationPlugin;
import net.maizegenetics.analysis.imputation.ImputationAccuracyPlugin;
import net.maizegenetics.analysis.imputation.LDKNNiImputationPlugin;
import net.maizegenetics.analysis.imputation.RemoveIndelsForBeaglePlugin;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitterPlugin;
import net.maizegenetics.analysis.numericaltransform.ImputationPlugin;
import net.maizegenetics.analysis.numericaltransform.NumericalGenotypePlugin;
import net.maizegenetics.analysis.numericaltransform.TransformDataPlugin;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumPlugin;
import net.maizegenetics.analysis.popgen.SequenceDiversityPlugin;
import net.maizegenetics.analysis.tree.ArchaeopteryxPlugin;
import net.maizegenetics.analysis.tree.ConvertTreeNamesPlugin;
import net.maizegenetics.analysis.tree.CreateTreePlugin;
import net.maizegenetics.analysis.tree.MergeTreesPlugin;
import net.maizegenetics.analysis.tree.RemoveBranchLengthsPlugin;
import net.maizegenetics.analysis.tree.SubsetTreePlugin;
import net.maizegenetics.analysis.workflow.WorkflowPlugin;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.gui.PrintHeapAction;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.progress.ProgressPanel;
import net.maizegenetics.tassel.AboutBox;
import net.maizegenetics.tassel.DataTreePanel;
import net.maizegenetics.tassel.PreferencesDialog;
import net.maizegenetics.tassel.ShowParameterCachePlugin;
import net.maizegenetics.tassel.TasselLogging;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TASSELMainFrame
extends JFrame
implements ActionListener {
    private static final Logger myLogger = Logger.getLogger(TASSELMainFrame.class);
    public static final String version = "5.2.66";
    public static final String versionDate = "October 29, 2020";
    private DataTreePanel myDataTreePanel;
    private JFileChooser filerSave = new JFileChooser();
    private JFileChooser filerOpen = new JFileChooser();
    private JScrollPane reportPanelScrollPane = new JScrollPane();
    private JTextArea reportPanelTextArea = new JTextArea();
    JScrollPane mainPanelScrollPane = new JScrollPane();
    JPanel mainDisplayPanel = new JPanel();
    private JTextArea mainPanelTextArea = new JTextArea();
    private JTextField myStatusTextField = new JTextField();
    private final ProgressPanel myProgressPanel = ProgressPanel.getInstance();
    private HashMap<JMenuItem, Plugin> myMenuItemHash = new HashMap();
    private PreferencesDialog myPreferences = null;
    private static final int ICON_WIDTH_PLUS_GAP = 30;

    public TASSELMainFrame() {
        try {
            this.loadSettings();
            this.myDataTreePanel = new DataTreePanel(this);
            this.myDataTreePanel.setToolTipText("Data Tree Panel");
            this.addMenuBar();
            this.initializeMyFrame();
            this.setTitle("TASSEL (Trait Analysis by aSSociation, Evolution, and Linkage) 5.2.66");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeMyFrame() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        int xDim = TasselPrefs.getXDim();
        int yDim = TasselPrefs.getYDim();
        if (xDim < 50 || yDim < 50) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(new Dimension(screenSize.width * 19 / 20, screenSize.height * 19 / 20));
        } else {
            this.setSize(xDim, yDim);
        }
        this.setTitle("TASSEL (Trait Analysis by aSSociation, Evolution, and Linkage)");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TasselLogging.closeInstance();
                TasselPrefs.putXDim(TASSELMainFrame.this.getWidth());
                TasselPrefs.putYDim(TASSELMainFrame.this.getHeight());
                System.exit(0);
            }
        });
        this.filerSave.setDialogType(1);
        JSplitPane dataTreeReportPanelsSplitPanel = new JSplitPane();
        dataTreeReportPanelsSplitPanel.setOrientation(0);
        this.reportPanelTextArea.setEditable(false);
        this.reportPanelTextArea.setToolTipText("Report Panel");
        this.reportPanelTextArea.setLineWrap(true);
        this.reportPanelTextArea.setWrapStyleWord(true);
        this.mainPanelTextArea.setDoubleBuffered(true);
        this.mainPanelTextArea.setEditable(false);
        this.mainPanelTextArea.setFont(new Font("Monospaced", 0, 12));
        this.mainPanelTextArea.setToolTipText("Main Panel");
        this.myStatusTextField.setBackground(Color.lightGray);
        this.myStatusTextField.setBorder(null);
        JSplitPane dataTreeReportMainPanelsSplitPanel = new JSplitPane();
        this.getContentPane().add((Component)dataTreeReportMainPanelsSplitPanel, "Center");
        dataTreeReportMainPanelsSplitPanel.add((Component)dataTreeReportPanelsSplitPanel, "left");
        dataTreeReportPanelsSplitPanel.add((Component)this.myDataTreePanel, "top");
        JSplitPane reportProgressSplitPane = new JSplitPane(0);
        JPanel reportPanel = new JPanel(new BorderLayout());
        reportProgressSplitPane.add((Component)reportPanel, "top");
        reportPanel.add((Component)this.reportPanelScrollPane, "Center");
        this.reportPanelScrollPane.getViewport().add((Component)this.reportPanelTextArea, null);
        reportProgressSplitPane.add((Component)new JScrollPane(this.myProgressPanel), "bottom");
        dataTreeReportPanelsSplitPanel.add((Component)reportProgressSplitPane, "bottom");
        dataTreeReportMainPanelsSplitPanel.add((Component)this.mainDisplayPanel, "right");
        this.mainDisplayPanel.setLayout(new BorderLayout());
        this.mainPanelScrollPane.getViewport().add((Component)this.mainPanelTextArea, null);
        this.mainDisplayPanel.add((Component)this.mainPanelScrollPane, "Center");
        this.mainPanelScrollPane.getViewport().add((Component)this.mainPanelTextArea, null);
        this.getContentPane().add((Component)this.myStatusTextField, "South");
        dataTreeReportMainPanelsSplitPanel.setDividerLocation(this.getSize().width / 4);
        dataTreeReportPanelsSplitPanel.setDividerLocation((int)((double)this.getSize().height / 3.5));
        reportProgressSplitPane.setDividerLocation((int)((double)this.getSize().height / 3.5));
    }

    public void loadPreferences() {
        this.myPreferences.processData(null);
    }

    private void addMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.getFileMenu());
        jMenuBar.add(this.getDataMenu());
        jMenuBar.add(this.getImputeMenu());
        jMenuBar.add(this.getFiltersMenu());
        jMenuBar.add(this.getAnalysisMenu());
        jMenuBar.add(this.getResultsMenu());
        jMenuBar.add(this.getGBSv2Menu());
        jMenuBar.add(this.getGBSMenu());
        jMenuBar.add(this.getWorkflowMenu());
        this.addThirdPartyMenus(jMenuBar);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.getHelpMenu());
        this.setJMenuBar(jMenuBar);
        this.updatePluginsWithGlobalConfigParameters();
    }

    private void addThirdPartyMenus(JMenuBar jMenuBar) {
        for (String current : Utils.getFullyQualifiedResourceNames("tassel_menu.xml")) {
            myLogger.info((Object)("TASSELMainFrame: addThirdPartyMenus: adding: " + current));
            this.addThirdPartyMenus(jMenuBar, current);
        }
    }

    private void addThirdPartyMenus(JMenuBar jMenuBar, String filename) {
        try (InputStream input = TASSELMainFrame.class.getResourceAsStream(filename);){
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            doc.getDocumentElement().normalize();
            Element rootElement = doc.getDocumentElement();
            if (!rootElement.getNodeName().equalsIgnoreCase("TasselMenus")) {
                throw new IllegalArgumentException("TASSELMainFrame: addThirdPartyMenus: Root Node must be TasselMenus: " + rootElement.getNodeName());
            }
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node current = children.item(i);
                JMenu menu = this.createSubMenu(current);
                if (menu == null) continue;
                jMenuBar.add(menu);
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TASSELMainFrame: addThirdPartyMenus: Problem reading XML file: " + filename + "\n" + e.getMessage());
        }
    }

    private JMenu createSubMenu(Node rootElement) {
        try {
            if (!rootElement.getNodeName().trim().equalsIgnoreCase("TasselMenu")) {
                return null;
            }
            JMenu result = new JMenu("Menu");
            NodeList children = rootElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node current = children.item(i);
                String elementName = current.getNodeName().trim();
                if (current.getNodeType() == 1 && elementName.equalsIgnoreCase("name")) {
                    result.setText(current.getTextContent().trim());
                    continue;
                }
                if (current.getNodeType() == 1 && elementName.equalsIgnoreCase("TasselMenu")) {
                    JMenu menu = this.createSubMenu(current);
                    if (menu == null) continue;
                    result.add(menu);
                    continue;
                }
                if (current.getNodeType() == 1 && elementName.equalsIgnoreCase("plugin")) {
                    try {
                        String match;
                        Plugin plugin = null;
                        String possibleClassName = current.getTextContent().trim();
                        List<String> matches = Utils.getFullyQualifiedClassNames(possibleClassName);
                        Iterator<String> iterator = matches.iterator();
                        while (iterator.hasNext() && (plugin = Plugin.getPluginInstance(match = iterator.next(), this, true)) == null) {
                        }
                        if (plugin == null) {
                            plugin = Plugin.getPluginInstance(possibleClassName, this, true);
                        }
                        if (plugin == null) continue;
                        result.add(this.createMenuItem(plugin, false));
                        continue;
                    }
                    catch (UnsupportedOperationException usoe) {
                        throw new IllegalArgumentException("TASSELMainFrame: addSubMenu: this plugin is not self-described: " + current);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TASSELMainFrame: addSubMenu: Unknown parameter: " + current);
                    }
                }
                if (current.getNodeType() != 1 || !elementName.equalsIgnoreCase("separator")) continue;
                result.addSeparator();
            }
            return result;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TASSELMainFrame: addSubMenu: Problem converting XML to Args: " + e.getMessage());
        }
    }

    private void helpAbout_actionPerformed(ActionEvent e) {
        AboutBox dlg = new AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public void sendMessage(String text) {
        this.myStatusTextField.setForeground(Color.BLACK);
        this.myStatusTextField.setText(text);
    }

    public void sendErrorMessage(String text) {
        this.myStatusTextField.setForeground(Color.RED);
        this.myStatusTextField.setText(text);
    }

    public void setMainText(String text) {
        this.mainPanelTextArea.setText(text);
        this.mainPanelTextArea.setCaretPosition(0);
    }

    public void setNoteText(String text) {
        this.reportPanelTextArea.setText(text);
        this.reportPanelTextArea.setCaretPosition(0);
    }

    private void loadSettings() {
        this.filerOpen.setCurrentDirectory(new File(TasselPrefs.getOpenDir()));
        this.filerSave.setCurrentDirectory(new File(TasselPrefs.getSaveDir()));
    }

    public void addDataSet(DataSet theDataSet, String defaultNode) {
        this.myDataTreePanel.addDataSet(theDataSet, defaultNode);
    }

    public void updateMainDisplayPanel(JPanel panel) {
        this.mainDisplayPanel.removeAll();
        this.mainDisplayPanel.add((Component)panel, "Center");
        this.mainDisplayPanel.repaint();
        this.mainDisplayPanel.validate();
    }

    public DataTreePanel getDataTreePanel() {
        return this.myDataTreePanel;
    }

    public ProgressPanel getProgressPanel() {
        return this.myProgressPanel;
    }

    private JMenuItem createMenuItem(Plugin theTP) {
        return this.createMenuItem(theTP, -1);
    }

    private JMenuItem createMenuItem(Plugin theTP, boolean adjustForIcon) {
        return this.createMenuItem(theTP, -1, adjustForIcon);
    }

    private JMenuItem createMenuItem(Plugin theTP, int mnemonic) {
        return this.createMenuItem(theTP, mnemonic, true);
    }

    private JMenuItem createMenuItem(Plugin theTP, int mnemonic, boolean adjustForIcon) {
        ImageIcon icon = theTP.getIcon();
        JMenuItem menuItem = new JMenuItem(theTP.getButtonName(), icon);
        if (mnemonic != -1) {
            menuItem.setMnemonic(mnemonic);
        }
        if (adjustForIcon) {
            int pixels = 30;
            if (icon != null) {
                pixels -= icon.getIconWidth();
                pixels /= 2;
            }
            menuItem.setIconTextGap(pixels);
        }
        menuItem.setBackground(Color.white);
        menuItem.setMargin(new Insets(2, 2, 2, 2));
        menuItem.setToolTipText(theTP.getToolTipText());
        menuItem.addActionListener(this);
        theTP.addListener(this.myDataTreePanel);
        this.myMenuItemHash.put(menuItem, theTP);
        return menuItem;
    }

    private JMenuItem createMenuItem(Action action, int mnemonic) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        JMenuItem menuItem = new JMenuItem(action.getValue("Name").toString(), icon);
        if (mnemonic != -1) {
            menuItem.setMnemonic(mnemonic);
        }
        int pixels = 30;
        if (icon != null) {
            pixels -= icon.getIconWidth();
            pixels /= 2;
        }
        menuItem.setIconTextGap(pixels);
        menuItem.setBackground(Color.white);
        menuItem.setMargin(new Insets(2, 2, 2, 2));
        menuItem.addActionListener(action);
        return menuItem;
    }

    private JMenuItem createMenuItem(String label, boolean adjustForIcon) {
        JMenuItem menuItem = new JMenuItem(label);
        if (adjustForIcon) {
            menuItem.setIconTextGap(30);
        }
        menuItem.setBackground(Color.white);
        menuItem.setMargin(new Insets(2, 2, 2, 2));
        menuItem.setEnabled(false);
        return menuItem;
    }

    void updatePluginsWithGlobalConfigParameters() {
        for (Plugin plugin : this.myMenuItemHash.values()) {
            ((AbstractPlugin)plugin).setConfigParameters();
        }
    }

    private JMenu getFiltersMenu() {
        JMenu result = new JMenu("Filter");
        result.setMnemonic(70);
        result.add(this.createMenuItem(new FilterSiteBuilderPlugin(this, true)));
        result.add(this.createMenuItem(new FilterTaxaBuilderPlugin(this, true)));
        result.add(this.createMenuItem(new FilterTraitsPlugin(this, true)));
        result.addSeparator();
        result.add(this.createMenuItem("Not Recommended", false));
        result.add(this.createMenuItem(new FilterAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new FilterSiteNamePlugin(this, true)));
        result.add(this.createMenuItem(new FilterTaxaPropertiesPlugin(this, true)));
        return result;
    }

    private JMenu getDataMenu() {
        JMenu result = new JMenu("Data");
        result.setMnemonic(68);
        result.add(this.createMenuItem(new GetTaxaListPlugin(this, true)));
        result.add(this.createMenuItem(new GetPositionListPlugin(this, true)));
        result.add(this.createMenuItem(new SortTaxaAlphabeticallyPlugin(this, true)));
        result.add(this.createMenuItem(new SortGenotypeFilePlugin(this, true)));
        result.add(this.createMenuItem(new SynonymizerPlugin(this, true)));
        result.add(this.createMenuItem(new IntersectionAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new UnionAlignmentPlugin(this, true)));
        result.add(this.createMenuItem(new MergeGenotypeTablesPlugin(this, true)));
        result.add(this.createMenuItem(new SeparatePlugin(this, true)));
        result.add(this.createMenuItem(new HetsToUnknownPlugin(this, true)));
        result.add(this.createMenuItem(new IndelsToUnknownPlugin(this, true)));
        result.add(this.createMenuItem(new SetLowDepthGenosToMissingPlugin(this, true)));
        result.add(this.createMenuItem(new TransformDataPlugin(this, true)));
        result.add(this.createMenuItem(new NumericalGenotypePlugin(this, true)));
        result.add(this.createMenuItem(new GenosToABHPlugin(this, true)));
        result.add(this.createMenuItem(new ThinSitesByPositionPlugin(this, true)));
        result.add(this.createMenuItem(new ClusterGenotypesPlugin(this, true)));
        result.add(this.createMenuItem(new MaskGenotypePlugin(this, true)));
        result.add(this.createMenuItem(new FindInversionsPlugin(this, true)));
        result.add(this.createMenuItem(new CreateHybridGenotypesPlugin(this, true)));
        result.add(this.createMenuItem(new GenotypeSummaryPlugin(this, true)));
        return result;
    }

    private JMenu getImputeMenu() {
        JMenu result = new JMenu("Impute");
        result.setMnemonic(73);
        result.add(this.createMenuItem((Plugin)new FILLINFindHaplotypesPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new FILLINImputationPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new FSFHapImputationPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new ImputationPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new RemoveIndelsForBeaglePlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new LDKNNiImputationPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new ImputationAccuracyPlugin(this, true), false));
        return result;
    }

    private JMenu getAnalysisMenu() {
        JMenu result = new JMenu("Analysis");
        result.setMnemonic(65);
        result.add(this.getPopGenMenu());
        result.add(this.getDistanceMenu());
        result.add(this.getAssociationMenu());
        return result;
    }

    private JMenu getPopGenMenu() {
        JMenu result = new JMenu("Diversity");
        result.setMnemonic(68);
        result.add(this.createMenuItem(new SequenceDiversityPlugin(this, true)));
        result.add(this.createMenuItem(new LinkageDisequilibriumPlugin(this, true)));
        return result;
    }

    private JMenu getDistanceMenu() {
        JMenu result = new JMenu("Relatedness");
        result.setMnemonic(82);
        result.add(this.createMenuItem(new DistanceMatrixPlugin(this, true)));
        result.add(this.createMenuItem(new KinshipPlugin(this, true)));
        result.add(this.createMenuItem(new CreateTreePlugin(this, true)));
        result.add(this.createMenuItem(new MergeTreesPlugin(this, true)));
        result.add(this.createMenuItem(new SubsetTreePlugin(this, true)));
        result.add(this.createMenuItem(new RemoveBranchLengthsPlugin(this, true)));
        result.add(this.createMenuItem(new ConvertTreeNamesPlugin(this, true)));
        result.add(this.createMenuItem(new AMatrixPlugin(this, true)));
        result.add(this.createMenuItem(new HMatrixPlugin(this, true)));
        result.add(this.createMenuItem(new MultiDimensionalScalingPlugin(this, true)));
        result.add(this.createMenuItem(new PrincipalComponentsPlugin(this, true)));
        result.addSeparator();
        result.add(this.createMenuItem(new RemoveNaNFromDistanceMatrixPlugin(this, true)));
        result.add(this.createMenuItem(new SubtractDistanceMatrixPlugin(this, true)));
        result.add(this.createMenuItem(new AddDistanceMatrixPlugin(this, true)));
        result.add(this.createMenuItem(new IdentityRecognitionPlugin(this, true)));
        return result;
    }

    private JMenu getAssociationMenu() {
        JMenu result = new JMenu("Association");
        result.setMnemonic(65);
        result.add(this.createMenuItem(new FixedEffectLMPlugin(this, true)));
        result.add(this.createMenuItem(new MLMPlugin(this, true)));
        result.add(this.createMenuItem(new WeightedMLMPlugin(this, true)));
        result.add(this.createMenuItem(new GenomicSelectionPlugin(this, true)));
        result.add(this.createMenuItem(new StepwiseOLSModelFitterPlugin(this, true)));
        result.add(this.createMenuItem(new FastMultithreadedAssociationPlugin(this, true)));
        result.add(this.createMenuItem(new VCAPScanPlugin(this, true)));
        return result;
    }

    private JMenu getResultsMenu() {
        JMenu result = new JMenu("Results");
        result.setMnemonic(82);
        result.add(this.createMenuItem(new TableDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new ArchaeopteryxPlugin(this, true)));
        result.add(this.createMenuItem(new LinkageDiseqDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new ChartDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new QQDisplayPlugin(this, true)));
        result.add(this.createMenuItem(new ManhattanDisplayPlugin(this, true)));
        return result;
    }

    private JMenu getFileMenu() {
        JMenu fileMenu = new JMenu();
        fileMenu.setText("File");
        final FileLoadPlugin autoGuessPlugin = new FileLoadPlugin(this, true, true);
        autoGuessPlugin.addListener(this.myDataTreePanel);
        fileMenu.add(this.createMenuItem(new AbstractAction("Open", autoGuessPlugin.getIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    autoGuessPlugin.processData(null);
                }
                catch (Exception ex) {
                    myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                    DialogUtils.showError(ex.getMessage() + "\n", (Component)autoGuessPlugin.getParentFrame());
                }
            }
        }, 79));
        fileMenu.add(this.createMenuItem(new FileLoadPlugin(this, true)));
        fileMenu.add(this.createMenuItem(new ExportPlugin(this, true)));
        URL deleteImageURL = TASSELMainFrame.class.getResource("/net/maizegenetics/analysis/images/trash.gif");
        ImageIcon deleteIcon = null;
        if (deleteImageURL != null) {
            deleteIcon = new ImageIcon(deleteImageURL);
        }
        fileMenu.add(this.createMenuItem(new AbstractAction("Delete Dataset", deleteIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.myDataTreePanel.deleteSelectedNodes();
            }
        }, -1));
        this.myPreferences = new PreferencesDialog(this, true);
        fileMenu.add(this.createMenuItem((Plugin)this.myPreferences, true));
        fileMenu.add(this.createMenuItem((Plugin)new ShowParameterCachePlugin(this, true), true));
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.addActionListener(e -> {
            TasselLogging.closeInstance();
            TasselPrefs.putXDim(this.getWidth());
            TasselPrefs.putYDim(this.getHeight());
            System.exit(0);
        });
        fileMenu.add(exitMenuItem);
        return fileMenu;
    }

    private JMenu getGBSv2Menu() {
        JMenu result = new JMenu("GBSv2");
        result.setMnemonic(71);
        result.add(this.createMenuItem((Plugin)new GBSSeqToTagDBPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new TagExportToFastqPlugin(this, true), false));
        result.add(this.createMenuItem("Align to Reference", false));
        result.add(this.createMenuItem((Plugin)new SAMToGBSdbPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new DiscoverySNPCallerPluginV2(this, true), false));
        result.add(this.createMenuItem((Plugin)new SNPQualityProfilerPlugin(this, true), false));
        result.add(this.createMenuItem((Plugin)new UpdateSNPPositionQualityPlugin(this, true), false));
        result.addSeparator();
        result.add(this.createMenuItem((Plugin)new ProductionSNPCallerPluginV2(this, true), false));
        result.addSeparator();
        result.add(this.createMenuItem((Plugin)new GetTagSequenceFromDBPlugin(this, true), false));
        result.addSeparator();
        result.add(this.createMenuItem((Plugin)new SNPCutPosTagVerificationPlugin(this, true), false));
        return result;
    }

    private JMenu getGBSMenu() {
        JMenu result = new JMenu("GBS");
        Map<TextAttribute, ?> attributes = result.getFont().getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        result.setFont(new Font(attributes));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new BinaryToTextPlugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new FastqToTagCountPlugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new MergeMultipleTagCountPlugin(this, true), false));
        result.addSeparator();
        this.addMenuItemDeprecated(result, this.getGBSReferenceMenu());
        result.addSeparator();
        this.addMenuItemDeprecated(result, this.getUNEAKMenu());
        result.addSeparator();
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new SeqToTBTHDF5Plugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new ModifyTBTHDF5Plugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new DiscoverySNPCallerPlugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new ProductionSNPCallerPlugin(this, true), false));
        return result;
    }

    private JMenu getGBSReferenceMenu() {
        JMenu result = new JMenu("Reference Genome");
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new TagCountToFastqPlugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem("Align to Reference", false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new SAMConverterPlugin(this, true), false));
        return result;
    }

    private JMenu getUNEAKMenu() {
        JMenu result = new JMenu("UNEAK (No Reference)");
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new UTagCountToTagPairPlugin(this, true), false));
        this.addMenuItemDeprecated(result, this.createMenuItem((Plugin)new UTagPairToTOPMPlugin(this, true), false));
        return result;
    }

    private void addMenuItemDeprecated(JMenu menu, JMenuItem item) {
        Map<TextAttribute, ?> attributes = item.getFont().getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        item.setFont(new Font(attributes));
        menu.add(item);
    }

    private void addMenuItemDeprecated(JMenu menu, JMenu item) {
        Map<TextAttribute, ?> attributes = item.getFont().getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        item.setFont(new Font(attributes));
        menu.add(item);
    }

    private JMenu getWorkflowMenu() {
        JMenu result = new JMenu("Workflow");
        List<WorkflowPlugin> workflows = WorkflowPlugin.getInstances(this);
        for (Plugin plugin : workflows) {
            result.add(this.createMenuItem(plugin));
        }
        return result;
    }

    private JMenu getHelpMenu() {
        JMenu helpMenu = new JMenu();
        helpMenu.setMnemonic(72);
        helpMenu.setText("Help");
        URL infoImageURL = TASSELMainFrame.class.getResource("/net/maizegenetics/analysis/images/info.gif");
        ImageIcon infoIcon = null;
        if (infoImageURL != null) {
            infoIcon = new ImageIcon(infoImageURL);
        }
        helpMenu.add(this.createMenuItem(new AbstractAction("Help Manual", infoIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                String html = "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/Home";
                try {
                    Desktop desktop = Desktop.getDesktop();
                    URI uri = new URI("https://bitbucket.org/tasseladmin/tassel-5-source/wiki/Home");
                    desktop.browse(uri);
                }
                catch (Exception ex) {
                    myLogger.warn((Object)"Problem showing Tassel Wiki URl in Browser.", (Throwable)ex);
                }
            }
        }, -1));
        URL aboutImageURL = TASSELMainFrame.class.getResource("/net/maizegenetics/analysis/images/Tassel_Logo16.png");
        ImageIcon aboutIcon = null;
        if (aboutImageURL != null) {
            aboutIcon = new ImageIcon(aboutImageURL);
        }
        helpMenu.add(this.createMenuItem(new AbstractAction("About", aboutIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TASSELMainFrame.this.helpAbout_actionPerformed(e);
            }
        }, -1));
        helpMenu.add(this.createMenuItem(PrintHeapAction.getInstance(this), -1));
        helpMenu.add(this.createMenuItem(TasselLogging.getInstance(this)));
        return helpMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem theMenuItem = (JMenuItem)e.getSource();
        Plugin theTP = this.myMenuItemHash.get(theMenuItem);
        PluginEvent event = new PluginEvent(this.myDataTreePanel.getSelectedTasselDataSet());
        ProgressPanel progressPanel = this.getProgressPanel();
        progressPanel.addPlugin(theTP);
        ThreadedPluginListener thread = new ThreadedPluginListener(theTP, event);
        thread.start();
    }
}

