/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.gui.FileBrowserUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TasselLogging
extends AbstractPlugin {
    private static TasselLogging myInstance = null;
    private static final Logger myLogger = Logger.getLogger(TasselLogging.class);
    private final JDialog myDialog = new JDialog((Window)null, "Tassel Logging", Dialog.ModalityType.MODELESS);
    private final JTextArea myTextArea = new JTextArea();
    private final TextAreaOutputStream myTextAreaOutputStream = new TextAreaOutputStream(this.myTextArea);
    private final PrintStream myPrintStream = new PrintStream(this.myTextAreaOutputStream);

    private TasselLogging(Frame parentFrame) {
        super(parentFrame, true);
        this.createDialog();
        TasselLogging.basicLoggingInfo();
        LoggingUtils.setupLogging(this.myPrintStream);
        this.myTextAreaOutputStream.clear();
        if (TasselPrefs.getLogSendToConsole()) {
            LoggingUtils.setupLogging();
        }
    }

    public static TasselLogging getInstance(Frame parentFrame) {
        if (parentFrame == null) {
            return null;
        }
        if (myInstance == null) {
            myInstance = new TasselLogging(parentFrame);
        }
        return myInstance;
    }

    public static void closeInstance() {
        if (myInstance != null) {
            myInstance.close();
        }
    }

    private void close() {
        TasselPrefs.putLogXDim(this.myDialog.getWidth());
        TasselPrefs.putLogYDim(this.myDialog.getHeight());
        this.myDialog.setVisible(false);
        if (TasselPrefs.getLogSendToConsole()) {
            LoggingUtils.setupLogging();
        }
    }

    public static void updateLoggingLocation() {
        if (myInstance != null) {
            myInstance.updateLogging();
        }
    }

    private void updateLogging() {
        if (TasselPrefs.getLogSendToConsole()) {
            LoggingUtils.setupLogging();
        } else {
            LoggingUtils.setupDebugLogging(this.myPrintStream);
        }
    }

    private void createDialog() {
        this.myDialog.setLayout(new BorderLayout());
        int x = TasselPrefs.getLogXDim();
        int y = TasselPrefs.getLogYDim();
        if (x < 50 || y < 50) {
            this.myDialog.setSize(500, 400);
        } else {
            this.myDialog.setSize(x, y);
        }
        this.myTextArea.setLineWrap(true);
        this.myTextArea.setMargin(new Insets(10, 10, 10, 10));
        this.myTextArea.setEditable(false);
        final JCheckBox isDebug = new JCheckBox("Debug Level");
        isDebug.setSelected(TasselPrefs.getLogDebug());
        isDebug.setToolTipText("Set to show Debug Logging Messages");
        isDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean debugMode = isDebug.isSelected();
                isDebug.setSelected(debugMode);
                TasselPrefs.putLogDebug(debugMode);
                LoggingUtils.setupLogging(TasselLogging.this.myPrintStream);
            }
        });
        JButton closeButton = new JButton();
        closeButton.setActionCommand("Close");
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasselLogging.this.close();
            }
        });
        JButton clearButton = new JButton();
        clearButton.setActionCommand("Clear");
        clearButton.setText("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasselLogging.this.myTextAreaOutputStream.clear();
            }
        });
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File theFile = FileBrowserUtils.getSaveFile(TasselLogging.this.myDialog);
                    if (theFile != null) {
                        TasselLogging.this.myTextArea.write(Utils.getBufferedWriter(theFile));
                    }
                }
                catch (Exception ex) {
                    DialogUtils.showError(ex.getMessage() + "\n", (Component)TasselLogging.this.myDialog);
                }
            }
        });
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(closeButton);
        pnlButtons.add(clearButton);
        pnlButtons.add(saveButton);
        pnlButtons.add(isDebug);
        this.myDialog.getContentPane().add((Component)new JScrollPane(this.myTextArea), "Center");
        this.myDialog.getContentPane().add((Component)pnlButtons, "South");
        this.myDialog.setResizable(true);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        try {
            LoggingUtils.setupLogging(this.myPrintStream);
            this.myDialog.setLocationRelativeTo(this.getParentFrame());
            this.myDialog.setVisible(true);
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = TasselLogging.class.getResource("/net/maizegenetics/analysis/images/log.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Logging";
    }

    @Override
    public String getToolTipText() {
        return "Logging";
    }

    public static void basicLoggingInfo() {
        myLogger.info((Object)"Tassel Version: 5.2.66  Date: October 29, 2020");
        myLogger.info((Object)("Max Available Memory Reported by JVM: " + Utils.getMaxHeapSizeMB() + " MB"));
        myLogger.info((Object)("Java Version: " + System.getProperty("java.version")));
        myLogger.info((Object)("OS: " + System.getProperty("os.name")));
        myLogger.info((Object)("Number of Processors: " + Runtime.getRuntime().availableProcessors()));
    }

    private static String bytesToString(byte[] ba, int str, int len) {
        try {
            return new String(ba, str, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(ba, str, len);
        }
    }

    static class TextAppender
    implements Runnable {
        private static final int MAX_NUM_LINES = 1000;
        private final JTextArea myTextArea;
        private final LinkedList<Integer> myLineLengths = new LinkedList();
        private final List<String> myBufferedText = new ArrayList<String>();
        private int myCurrentLineLength = 0;
        private boolean myClearAllText = false;
        private boolean myIfNoTextQueued = true;
        private static final String END_OF_LINE = "\n";
        private static final String SYSTEM_END_OF_LINE = System.getProperty("line.separator", "\n");

        TextAppender(JTextArea textArea) {
            this.myTextArea = textArea;
        }

        synchronized void append(String val) {
            this.myBufferedText.add(val);
            if (this.myIfNoTextQueued) {
                this.myIfNoTextQueued = false;
                EventQueue.invokeLater(this);
            }
        }

        synchronized void clear() {
            this.myClearAllText = true;
            this.myCurrentLineLength = 0;
            this.myLineLengths.clear();
            this.myBufferedText.clear();
            if (this.myIfNoTextQueued) {
                this.myIfNoTextQueued = false;
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public synchronized void run() {
            if (this.myClearAllText) {
                this.myTextArea.setText(null);
            }
            for (String val : this.myBufferedText) {
                this.myCurrentLineLength += val.length();
                if (val.endsWith(END_OF_LINE) || val.endsWith(SYSTEM_END_OF_LINE)) {
                    if (this.myLineLengths.size() >= 1000) {
                        this.myTextArea.replaceRange("", 0, this.myLineLengths.removeFirst());
                    }
                    this.myLineLengths.addLast(this.myCurrentLineLength);
                    this.myCurrentLineLength = 0;
                }
                this.myTextArea.append(val);
            }
            this.myBufferedText.clear();
            this.myClearAllText = false;
            this.myIfNoTextQueued = true;
        }
    }

    class TextAreaOutputStream
    extends OutputStream {
        private final byte[] myByteArray = new byte[1];
        private TextAppender myTextAppender;

        public TextAreaOutputStream(JTextArea textArea) {
            this.myTextAppender = new TextAppender(textArea);
        }

        public synchronized void clear() {
            if (this.myTextAppender != null) {
                this.myTextAppender.clear();
                TasselLogging.basicLoggingInfo();
            }
        }

        @Override
        public synchronized void close() {
            this.myTextAppender = null;
        }

        @Override
        public synchronized void flush() {
        }

        @Override
        public synchronized void write(int val) {
            this.myByteArray[0] = (byte)val;
            this.write(this.myByteArray, 0, 1);
        }

        @Override
        public synchronized void write(byte[] ba) {
            this.write(ba, 0, ba.length);
        }

        @Override
        public synchronized void write(byte[] ba, int str, int len) {
            if (this.myTextAppender != null) {
                this.myTextAppender.append(TasselLogging.bytesToString(ba, str, len));
            }
        }
    }
}

