/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

class TaxaArrayList
implements TaxaList {
    private static final Logger myLogger = Logger.getLogger(TaxaArrayList.class);
    private final List<Taxon> myTaxaList;
    private final int myNumTaxa;
    private final ImmutableMap<String, Integer> myNameToIndex;

    TaxaArrayList(TaxaListBuilder builder) {
        List<Taxon> srcList = builder.getImmutableList();
        this.myTaxaList = new ArrayList<Taxon>(srcList.size());
        this.myNumTaxa = srcList.size();
        int index = 0;
        ImmutableMap.Builder nToIBuilder = new ImmutableMap.Builder();
        for (Taxon Taxon2 : srcList) {
            this.myTaxaList.add(Taxon2);
            nToIBuilder.put((Object)Taxon2.getName(), (Object)index);
            ++index;
        }
        this.myNameToIndex = nToIBuilder.build();
    }

    @Override
    public int numberOfTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public String taxaName(int index) {
        return this.myTaxaList.get(index).getName();
    }

    @Override
    public int size() {
        return this.myNumTaxa;
    }

    @Override
    public int indexOf(String name) {
        Integer index = (Integer)this.myNameToIndex.get((Object)name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public int indexOf(Taxon taxon) {
        return this.indexOf(taxon.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.myTaxaList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myTaxaList.contains(o);
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.myTaxaList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.myTaxaList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.myTaxaList.toArray(a);
    }

    @Override
    public boolean add(Taxon Taxon2) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myTaxaList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Taxon> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Taxon> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public Taxon get(int index) {
        return this.myTaxaList.get(index);
    }

    @Override
    public Taxon set(int index, Taxon element) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public void add(int index, Taxon element) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public Taxon remove(int index) {
        throw new UnsupportedOperationException("This Class is Immutable.");
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf((Taxon)o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myTaxaList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Taxon> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Taxon> listIterator(final int index) {
        return new ListIterator<Taxon>(){
            private final ListIterator<Taxon> i;
            {
                this.i = TaxaArrayList.this.myTaxaList.listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Taxon next() {
                return this.i.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public Taxon previous() {
                return this.i.previous();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Taxon e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Taxon e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<Taxon> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.myTaxaList.subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TaxaList)) {
            return false;
        }
        TaxaList otherTaxa = (TaxaList)obj;
        if (this.numberOfTaxa() != otherTaxa.numberOfTaxa()) {
            return false;
        }
        Iterator<Taxon> myIter = this.myTaxaList.iterator();
        Iterator otherIter = otherTaxa.iterator();
        while (myIter.hasNext()) {
            if (myIter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }
}

