/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import java.util.Map;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.GeneralAnnotationStorage;

public class Taxon
implements Comparable<Taxon> {
    public static final String DELIMITER = ":";
    public static Taxon ANONYMOUS = new Taxon("");
    public static final String FatherKey = "FATHER";
    public static final String MotherKey = "MOTHER";
    public static final String PedigreeKey = "PEDIGREE";
    public static final String SexKey = "SEX";
    public static final String InbreedFKey = "INBREEDF";
    public static final String SynonymKey = "SYNONYM";
    public static final String LatitudeKey = "LATITUDE";
    public static final String LongitudeKey = "LONGITUDE";
    public static final String AltitudeKey = "ALTITUDE";
    public static final String GenusKey = "GENUS";
    public static final String SpeciesKey = "SPECIES";
    private final GeneralAnnotation myAnno;
    private final String myName;
    private final int hashCode;

    public Taxon(String name) {
        this(name, GeneralAnnotationStorage.EMPTY_ANNOTATION_STORAGE);
    }

    public Taxon(String name, GeneralAnnotation anno) {
        this.myName = name.trim();
        this.hashCode = this.myName.hashCode();
        this.myAnno = anno;
    }

    public String toString() {
        return this.getName();
    }

    public String toStringWithVCFAnnotation() {
        StringBuilder sb = new StringBuilder("<");
        sb.append("ID=" + this.getName() + ",");
        for (Map.Entry<String, String> en : this.myAnno.getAllAnnotationEntries()) {
            sb.append(en.getKey() + "=" + en.getValue() + ",");
        }
        if (this.myAnno.numAnnotations() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Taxon c) {
        if (this == c) {
            return 0;
        }
        return this.myName.compareTo(c.getName());
    }

    public boolean equals(Object c) {
        if (this == c) {
            return true;
        }
        if (c instanceof Taxon) {
            return this.myName.equals(((Taxon)c).getName());
        }
        if (c instanceof String) {
            return this.myName.equals((String)c);
        }
        return false;
    }

    public String getName() {
        return this.myName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public GeneralAnnotation getAnnotation() {
        return this.myAnno;
    }

    public static class Builder {
        private String myTaxonName;
        private GeneralAnnotationStorage.Builder myAnnotations = GeneralAnnotationStorage.getBuilder();

        public Builder(Taxon aTaxon) {
            this.myTaxonName = aTaxon.getName();
            this.myAnnotations.addAnnotations(aTaxon.getAnnotation());
        }

        public Builder(String aTaxonName) {
            this.myTaxonName = aTaxonName;
        }

        public Builder addAnno(String key, String value) {
            this.myAnnotations.addAnnotation(key, value);
            return this;
        }

        public Builder addAnno(String key, Number value) {
            this.myAnnotations.addAnnotation(key, value);
            return this;
        }

        public Builder name(String newName) {
            this.myTaxonName = newName;
            return this;
        }

        public Builder sex(byte val) {
            return this.addAnno(Taxon.SexKey, val);
        }

        public Builder inbreedF(float val) {
            return this.addAnno(Taxon.InbreedFKey, Float.valueOf(val));
        }

        public Builder parents(String mom, String dad) {
            this.addAnno(Taxon.MotherKey, mom);
            return this.addAnno(Taxon.FatherKey, dad);
        }

        public Builder pedigree(String val) {
            return this.addAnno(Taxon.PedigreeKey, val);
        }

        public Builder synonym(String val) {
            return this.addAnno(Taxon.SynonymKey, val);
        }

        public Taxon build() {
            return new Taxon(this.myTaxonName, this.myAnnotations.build());
        }
    }
}

