/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.distance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;

public class DistanceMatrixUtils {
    private DistanceMatrixUtils() {
    }

    public static String[] getGRMFilenames(String base) {
        String[] result = new String[5];
        String filename = base.toLowerCase();
        if (filename.endsWith(".txt")) {
            int txtIndex = filename.lastIndexOf(".txt");
            String temp = base.substring(0, txtIndex);
            result[0] = temp + ".grm.id";
            result[1] = temp + ".grm.bin";
            result[2] = temp + ".grm.N.bin";
            result[3] = temp + ".grm.raw";
            result[4] = filename;
            return result;
        }
        int grmIndex = filename.lastIndexOf(".grm");
        if (grmIndex == -1) {
            result[0] = base + ".grm.id";
            result[1] = base + ".grm.bin";
            result[2] = base + ".grm.N.bin";
            result[3] = base + ".grm.raw";
            result[4] = base + ".txt";
        } else {
            String temp = base.substring(0, grmIndex);
            result[0] = temp + ".grm.id";
            result[1] = temp + ".grm.bin";
            result[2] = temp + ".grm.N.bin";
            result[3] = temp + ".grm.raw";
            result[4] = temp + ".txt";
        }
        return result;
    }

    public static String[] getDARwinFilenames(String base) {
        String[] result = new String[2];
        int index = base.lastIndexOf(".");
        if (index == -1) {
            result[0] = base + ".don";
            result[1] = base + ".dis";
            return result;
        }
        String temp = base.substring(0, index);
        result[0] = temp + ".don";
        result[1] = temp + ".dis";
        return result;
    }

    public static double squaredDistance(DistanceMatrix mat1, DistanceMatrix mat2, boolean weighted) {
        int i;
        boolean aliasNeeded = false;
        if (mat1.getSize() != mat2.getSize()) {
            aliasNeeded = true;
        }
        int[] alias = null;
        if (aliasNeeded) {
            if (mat1.getSize() > mat2.getSize()) {
                DistanceMatrix temp = mat2;
                mat2 = mat1;
                mat1 = temp;
            }
            alias = new int[mat1.getSize()];
            for (i = 0; i < alias.length; ++i) {
                alias[i] = mat2.whichIdNumber(mat1.getTaxon(i).getName());
            }
        } else {
            alias = new int[mat1.getSize()];
            for (i = 0; i < alias.length; ++i) {
                alias[i] = i;
            }
        }
        double sum = 0.0;
        double[][] mat1Distance = mat1.getDistances();
        double[][] mat2Distance = mat2.getDistances();
        for (int i2 = 0; i2 < mat1.getSize() - 1; ++i2) {
            int ai = alias[i2];
            for (int j = i2 + 1; j < mat1.getSize(); ++j) {
                double diff = mat1Distance[i2][j] - mat2Distance[ai][alias[j]];
                double weight = weighted ? 1.0 / (mat1Distance[i2][j] * mat2Distance[ai][alias[j]]) : 1.0;
                sum += weight * diff * diff;
            }
        }
        return 2.0 * sum;
    }

    public static DistanceMatrix minus(DistanceMatrix parent, int taxaToRemove) {
        int size = parent.numberOfTaxa() - 1;
        double[][] distances = new double[size][size];
        Taxon[] ids = new Taxon[size];
        int counti = 0;
        int countj = 0;
        for (int i = 0; i < size; ++i) {
            if (counti == taxaToRemove) {
                ++counti;
            }
            ids[i] = parent.getTaxon(counti);
            countj = 0;
            double[][] parentDistance = parent.getDistances();
            for (int j = 0; j < size; ++j) {
                if (countj == taxaToRemove) {
                    ++countj;
                }
                distances[i][j] = parentDistance[counti][countj];
                ++countj;
            }
            ++counti;
        }
        TaxaList tl = new TaxaListBuilder().addAll(ids).build();
        DistanceMatrix smaller = new DistanceMatrix(distances, tl);
        return smaller;
    }

    public static DistanceMatrix keepTaxa(DistanceMatrix parent, int[] taxaToKeep) {
        int ntaxa = taxaToKeep.length;
        double[][] newDistances = new double[ntaxa][ntaxa];
        for (int r = 0; r < ntaxa; ++r) {
            for (int c = 0; c < ntaxa; ++c) {
                newDistances[r][c] = parent.getDistance(taxaToKeep[r], taxaToKeep[c]);
            }
        }
        TaxaListBuilder taxaBuilder = new TaxaListBuilder();
        for (int ndx : taxaToKeep) {
            taxaBuilder.add(parent.getTaxon(ndx));
        }
        TaxaList taxaListToKeep = taxaBuilder.build();
        return new DistanceMatrix(newDistances, taxaListToKeep);
    }

    public static DistanceMatrix keepTaxa(DistanceMatrix parent, TaxaList taxaToKeep) {
        int[] keepIndex = taxaToKeep.stream().mapToInt(t -> parent.whichIdNumber((Taxon)t)).filter(i -> i > -1).toArray();
        return DistanceMatrixUtils.keepTaxa(parent, keepIndex);
    }

    public static DistanceMatrix clusterBySmallestDistance(DistanceMatrix orig) {
        TaxaList taxa = orig.getTaxaList();
        int numTaxa = taxa.numberOfTaxa();
        Object[] lowValues = new TaxaPairLowestDistance[numTaxa];
        for (int t = 0; t < numTaxa; ++t) {
            lowValues[t] = new TaxaPairLowestDistance(t);
        }
        for (int x = 0; x < numTaxa; ++x) {
            for (int y = x + 1; y < numTaxa; ++y) {
                float value = orig.getDistance(x, y);
                if (Float.isNaN(value)) continue;
                if (((TaxaPairLowestDistance)lowValues[x]).myLowValue > value) {
                    ((TaxaPairLowestDistance)lowValues[x]).myLowValue = value;
                    ((TaxaPairLowestDistance)lowValues[x]).myTaxon2 = y;
                }
                if (!(((TaxaPairLowestDistance)lowValues[y]).myLowValue > value)) continue;
                ((TaxaPairLowestDistance)lowValues[y]).myLowValue = value;
                ((TaxaPairLowestDistance)lowValues[y]).myTaxon2 = x;
            }
        }
        Arrays.sort(lowValues);
        ArrayList clusters = new ArrayList();
        ArrayList[] whichCluster = new ArrayList[numTaxa];
        ArrayList<Integer> unknownList = new ArrayList<Integer>();
        for (int t = 0; t < numTaxa; ++t) {
            int taxon1 = ((TaxaPairLowestDistance)lowValues[t]).myTaxon1;
            int taxon2 = ((TaxaPairLowestDistance)lowValues[t]).myTaxon2;
            if (taxon2 == -1) {
                unknownList.add(taxon1);
                continue;
            }
            if (whichCluster[taxon1] == null && whichCluster[taxon2] == null) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                arrayList.add(taxon1);
                arrayList.add(taxon2);
                clusters.add(arrayList);
                whichCluster[taxon1] = arrayList;
                whichCluster[taxon2] = arrayList;
                continue;
            }
            if (whichCluster[taxon1] == null) {
                whichCluster[taxon1] = whichCluster[taxon2];
                whichCluster[taxon1].add(taxon1);
                continue;
            }
            if (whichCluster[taxon2] != null) continue;
            whichCluster[taxon2] = whichCluster[taxon1];
            whichCluster[taxon2].add(taxon2);
        }
        clusters.add(unknownList);
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(numTaxa);
        int count = 0;
        for (List list : clusters) {
            int currentNumTaxa = list.size();
            for (int taxon = 0; taxon < currentNumTaxa; ++taxon) {
                builder.addTaxon((Taxon)taxa.get((Integer)list.get(taxon)));
                for (int x = taxon; x < currentNumTaxa; ++x) {
                    builder.set(x + count, taxon + count, orig.getDistance((Integer)list.get(taxon), (Integer)list.get(x)));
                }
            }
            count += currentNumTaxa;
        }
        return builder.build();
    }

    public static double getIBSDistance(long[] iMajor, long[] iMinor, long[] jMajor, long[] jMinor) {
        int sameCnt = 0;
        int diffCnt = 0;
        int hetCnt = 0;
        for (int x = 0; x < iMajor.length; ++x) {
            long same = iMajor[x] & jMajor[x] | iMinor[x] & jMinor[x];
            long diff = iMajor[x] & jMinor[x] | iMinor[x] & jMajor[x];
            long hets = same & diff;
            sameCnt += BitUtil.pop(same);
            diffCnt += BitUtil.pop(diff);
            hetCnt += BitUtil.pop(hets);
        }
        double identity = (double)(sameCnt + hetCnt / 2) / (double)(sameCnt + diffCnt + hetCnt);
        double dist = 1.0 - identity;
        return dist;
    }

    public static double getIBSDistance(BitSet iMajor, BitSet iMinor, BitSet jMajor, BitSet jMinor) {
        return DistanceMatrixUtils.getIBSDistance(iMajor.getBits(), iMinor.getBits(), jMajor.getBits(), jMinor.getBits());
    }

    private static class TaxaPairLowestDistance
    implements Comparable<TaxaPairLowestDistance> {
        private final int myTaxon1;
        private int myTaxon2;
        private float myLowValue = Float.POSITIVE_INFINITY;

        public TaxaPairLowestDistance(int taxon1) {
            this.myTaxon1 = taxon1;
            this.myTaxon2 = -1;
            this.myLowValue = Float.POSITIVE_INFINITY;
        }

        @Override
        public int compareTo(TaxaPairLowestDistance o) {
            if (this.myLowValue < o.myLowValue) {
                return -1;
            }
            if (this.myLowValue > o.myLowValue) {
                return 1;
            }
            return 0;
        }
    }
}

