/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.AttributeNode;
import net.maizegenetics.taxa.tree.LabelMapping;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.NodeUtils;
import net.maizegenetics.taxa.tree.SimpleNode;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.taxa.tree.TreeUtils;

public class SimpleTree
implements Tree,
Serializable {
    private Node root;
    private Node[] internalNode = null;
    private int numInternalNodes;
    private Node[] externalNode = null;
    private int numExternalNodes;
    private Hashtable[] attributes = null;
    private int units = 0;
    static final long serialVersionUID = -7330318631600898531L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.root);
        out.writeObject(this.attributes);
        out.writeInt(this.units);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.root = (Node)in.readObject();
        this.createNodeList();
        this.attributes = (Hashtable[])in.readObject();
        this.units = in.readInt();
    }

    public SimpleTree() {
        this.root = new SimpleNode();
        this.root.setBranchLength(0.0);
        this.root.setBranchLengthSE(0.0);
    }

    public SimpleTree(Node r) {
        this.root = r;
        this.createNodeList();
    }

    public SimpleTree(Tree tree) {
        this.root = new SimpleNode(tree.getRoot());
        this.setUnits(tree.getUnits());
        this.createNodeList();
    }

    public SimpleTree(Tree tree, boolean keepIdentifiers) {
        this.root = new SimpleNode(tree.getRoot(), keepIdentifiers);
        this.setUnits(tree.getUnits());
        this.createNodeList();
    }

    public SimpleTree(Tree tree, LabelMapping lm) {
        this.root = new SimpleNode(tree.getRoot(), lm);
        this.setUnits(tree.getUnits());
        this.createNodeList();
    }

    @Override
    public final int getUnits() {
        return this.units;
    }

    public final void setUnits(int units) {
        this.units = units;
    }

    @Override
    public final int getExternalNodeCount() {
        if (this.externalNode == null) {
            this.createNodeList();
        }
        return this.numExternalNodes;
    }

    @Override
    public final Node getExternalNode(int i) {
        if (this.externalNode == null) {
            this.createNodeList();
        }
        return this.externalNode[i];
    }

    @Override
    public final int getInternalNodeCount() {
        if (this.internalNode == null) {
            this.createNodeList();
        }
        return this.numInternalNodes;
    }

    @Override
    public final Node getInternalNode(int i) {
        if (this.internalNode == null) {
            this.createNodeList();
        }
        return this.internalNode[i];
    }

    @Override
    public final Node getRoot() {
        return this.root;
    }

    @Override
    public final void setRoot(Node r) {
        this.root = r;
        this.createNodeList();
    }

    @Override
    public void createNodeList() {
        this.numInternalNodes = 0;
        this.numExternalNodes = 0;
        Node node = this.root;
        do {
            if ((node = NodeUtils.postorderSuccessor(node)).isLeaf()) {
                node.setNumber(this.numExternalNodes);
                ++this.numExternalNodes;
                continue;
            }
            node.setNumber(this.numInternalNodes);
            ++this.numInternalNodes;
        } while (node != this.root);
        this.internalNode = new Node[this.numInternalNodes];
        this.externalNode = new Node[this.numExternalNodes];
        node = this.root;
        do {
            if ((node = NodeUtils.postorderSuccessor(node)).isLeaf()) {
                this.externalNode[node.getNumber()] = node;
                continue;
            }
            this.internalNode[node.getNumber()] = node;
        } while (node != this.root);
        if (this.root.getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(this.root);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            NodeUtils.printNH(new PrintWriter(sw), this.getRoot(), true, false, 0, false);
            sw.write(";");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public Node findNode(int num) {
        this.createNodeList();
        if (num <= this.numExternalNodes) {
            return this.externalNode[num - 1];
        }
        return this.internalNode[num - 1 - this.numExternalNodes];
    }

    private int getIndex(Node node) {
        if (node.isLeaf()) {
            return node.getNumber();
        }
        return this.getExternalNodeCount() + node.getNumber();
    }

    @Override
    public void setAttribute(Node node, String name, Object value) {
        if (node instanceof AttributeNode) {
            ((AttributeNode)node).setAttribute(name, value);
        } else {
            int index = this.getIndex(node);
            if (this.attributes == null) {
                this.attributes = new Hashtable[this.getExternalNodeCount() + this.getInternalNodeCount()];
            }
            if (this.attributes[index] == null) {
                this.attributes[index] = new Hashtable();
            }
            this.attributes[index].put(name, value);
        }
    }

    @Override
    public int whichIdNumber(Taxon t) {
        for (int i = 0; i < this.getExternalNodeCount(); ++i) {
            if (!t.equals(this.getExternalNode(i).getIdentifier())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getAttribute(Node node, String name) {
        if (node instanceof AttributeNode) {
            return ((AttributeNode)node).getAttribute(name);
        }
        int index = this.getIndex(node);
        if (this.attributes == null || this.attributes[index] == null) {
            return null;
        }
        return this.attributes[index].get(name);
    }

    public void reroot(int num) {
        TreeUtils.reroot(this, this.findNode(num));
    }

    public void reroot(Node node) {
        TreeUtils.reroot(this, node);
    }

    public void report(Writer out) throws IOException {
        TreeUtils.report(this, out);
    }

    @Override
    public Tree getCopy() {
        return new SimpleTree(this);
    }
}

