/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableMap;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.v2.BarcodeTrie;
import net.maizegenetics.analysis.gbs.v2.GBSEnzyme;
import net.maizegenetics.analysis.gbs.v2.GBSUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ConvertOldFastqToModernFormatPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ConvertOldFastqToModernFormatPlugin.class);
    private PluginParameter<String> inputFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).description("Input file or directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively").build();
    private PluginParameter<String> keyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> projectName = new PluginParameter.Builder<String>("p", null, String.class).guiName("Project File").required(true).description("Name for this project.  Project name becomes part of the newly created fastq file name").build();
    private PluginParameter<String> outputDir = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output Directory").required(true).outDir().description("Output directory where new fastQ files will be written").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").required(true).description("Enzyme used to create the GBS library").build();
    public static final String inputFileGlob = "glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}";
    public static final String sampleNameField = "FullSampleName";
    public static final String flowcellField = "Flowcell";
    public static final String laneField = "Lane";
    public static final String barcodeField = "Barcode";
    public static final String tissueNameField = "Tissue";
    public static final String fileNameField = "FileName";
    static List<Path> infiles;
    static String[] likelyReadEndStrings;
    protected static int readEndCutSiteRemnantLength;

    public ConvertOldFastqToModernFormatPlugin() {
        super(null, false);
    }

    public ConvertOldFastqToModernFormatPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void postProcessParameters() {
        File dirList = new File(this.inputFile());
        if (!dirList.exists()) {
            throw new IllegalStateException("Input file or directory not found !!");
        }
        if (dirList.isDirectory()) {
            infiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.inputFile.value(), new String[0]).toAbsolutePath());
            if (infiles.isEmpty()) {
                myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
                throw new IllegalStateException("no .txt files found in input directory !!");
            }
        } else {
            infiles = new ArrayList<Path>();
            Path filePath = Paths.get(this.inputFile(), new String[0]).toAbsolutePath();
            infiles.add(filePath);
        }
        if (!this.myEnzyme.isEmpty()) {
            GBSEnzyme enzyme = new GBSEnzyme(this.enzyme());
            likelyReadEndStrings = enzyme.likelyReadEnd();
            readEndCutSiteRemnantLength = enzyme.readEndCutSiteRemnantLength();
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        myLogger.info((Object)"Checking Key format");
        boolean keyFormatIsNew = ConvertOldFastqToModernFormatPlugin.determineKeyFormat(this.keyFile());
        TaxaList masterTaxaList = keyFormatIsNew ? TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), sampleNameField, new HashMap<String, String>(), true) : ConvertOldFastqToModernFormatPlugin.readOldTaxaAnnotationFile(this.keyFile(), new HashMap<String, String>(), true);
        myLogger.info((Object)"Created masterTaxaList - start processing fastq files");
        int batchSize = 8;
        for (int idx = 0; idx < infiles.size(); idx += batchSize) {
            int end = idx + batchSize;
            if (end > infiles.size()) {
                end = infiles.size();
            }
            ArrayList<Path> sub = new ArrayList<Path>();
            for (int j = idx; j < end; ++j) {
                sub.add(infiles.get(j));
            }
            myLogger.info((Object)("\nStart processing batch " + String.valueOf(idx / batchSize + 1)));
            sub.parallelStream().forEach(inputSeqFile -> {
                try {
                    Path keyPath = Paths.get(this.keyFile(), new String[0]).toAbsolutePath();
                    myLogger.info((Object)(" - processing file " + inputSeqFile));
                    HashMap<Taxon, Tuple<BufferedWriter, String>> taxaWriterMap = new HashMap<Taxon, Tuple<BufferedWriter, String>>();
                    ConvertOldFastqToModernFormatPlugin.processFastQFile(keyPath, inputSeqFile, this.enzyme(), masterTaxaList, taxaWriterMap, this.outputDir(), this.projectName(), keyFormatIsNew);
                    myLogger.info((Object)("Calling Shutdown to close the writers for " + inputSeqFile));
                    ConvertOldFastqToModernFormatPlugin.Shutdown(taxaWriterMap);
                }
                catch (StringIndexOutOfBoundsException oobe) {
                    return;
                }
            });
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean determineKeyFormat(String keyFile) {
        try (BufferedReader br = Utils.getBufferedReader(keyFile);){
            String header = br.readLine();
            if (header.contains(sampleNameField)) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public static ArrayList<Taxon> getLaneAnnotatedTaxaList(Path keyPath, Path fastQpath, boolean useNew) {
        ArrayList<Taxon> annoTL;
        String[] filenameField = fastQpath.getFileName().toString().split("_");
        if (filenameField.length == 3) {
            annoTL = useNew ? TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[0], (Object)laneField, (Object)filenameField[1])) : ConvertOldFastqToModernFormatPlugin.readOldFormatKeyFile(keyPath.toAbsolutePath().toString(), (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[0], (Object)laneField, (Object)filenameField[1]), true);
        } else if (filenameField.length == 4) {
            annoTL = useNew ? TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[0], (Object)laneField, (Object)filenameField[2])) : ConvertOldFastqToModernFormatPlugin.readOldFormatKeyFile(keyPath.toAbsolutePath().toString(), (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[0], (Object)laneField, (Object)filenameField[2]), true);
        } else if (filenameField.length == 5) {
            annoTL = useNew ? TaxaListIOUtils.readTaxaAnnotationFileAL(keyPath.toAbsolutePath().toString(), sampleNameField, (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[1], (Object)laneField, (Object)filenameField[3])) : ConvertOldFastqToModernFormatPlugin.readOldFormatKeyFile(keyPath.toAbsolutePath().toString(), (Map<String, String>)ImmutableMap.of((Object)flowcellField, (Object)filenameField[1], (Object)laneField, (Object)filenameField[3]), true);
        } else {
            myLogger.error((Object)("Error in parsing file name: " + fastQpath.toString()));
            myLogger.error((Object)"   The filename does not contain either 3, 4, or 5 underscore-delimited values.");
            myLogger.error((Object)"   Expect: flowcell_lane_fastq.txt.gz OR flowcell_s_lane_fastq.txt.gz OR code_flowcell_s_lane_fastq.txt.gz");
            return null;
        }
        return annoTL;
    }

    public static TaxaList readOldTaxaAnnotationFile(String fileName, Map<String, String> filters, boolean mergeSameNames) {
        ArrayList<Taxon> taxaAL = ConvertOldFastqToModernFormatPlugin.readOldFormatKeyFile(fileName, filters, mergeSameNames);
        if (taxaAL == null) {
            return null;
        }
        TaxaListBuilder tlb = new TaxaListBuilder();
        taxaAL.stream().forEach(taxa -> {
            if (mergeSameNames) {
                tlb.addOrMerge((Taxon)taxa);
            } else {
                tlb.add((Taxon)taxa);
            }
        });
        return tlb.sortTaxaAlphabetically().build();
    }

    public static ArrayList<Taxon> readOldFormatKeyFile(String fileName, Map<String, String> filters, boolean mergeSameNames) {
        try {
            BufferedReader fileIn = Utils.getBufferedReader(fileName, 1000000);
            fileIn.mark(65536);
            String line = fileIn.readLine();
            ArrayList<Taxon> taxaAL = new ArrayList<Taxon>();
            int indexOfSample = 0;
            int indexOfFlowcell = 0;
            int indexOfLane = 0;
            int indexOfBarcode = 0;
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<Boolean> isQuant = new ArrayList<Boolean>();
            if (line.contains(flowcellField)) {
                int idx = 0;
                for (String header : line.split("\\t")) {
                    if (header.equalsIgnoreCase("Sample")) {
                        indexOfSample = idx;
                    }
                    if (header.equalsIgnoreCase(flowcellField)) {
                        indexOfFlowcell = idx;
                    }
                    if (header.equalsIgnoreCase(laneField)) {
                        indexOfLane = idx;
                    }
                    if (header.equalsIgnoreCase(barcodeField)) {
                        indexOfBarcode = idx;
                    }
                    isQuant.add(header.startsWith("#") || header.startsWith("<#"));
                    headers.add(header.replace(">", "").replace("<", "").replace("#", ""));
                    ++idx;
                }
            } else {
                fileIn.reset();
            }
            while ((line = fileIn.readLine()) != null) {
                String[] stokens = line.split("\\t");
                StringBuilder taxonSB = new StringBuilder();
                taxonSB.append(stokens[indexOfSample]).append(":");
                taxonSB.append(stokens[indexOfFlowcell]).append(":");
                taxonSB.append(stokens[indexOfLane]).append(":");
                taxonSB.append(stokens[indexOfBarcode]);
                String aTaxonName = taxonSB.toString();
                Taxon.Builder anID = new Taxon.Builder(aTaxonName);
                for (int idx = 0; idx < stokens.length; ++idx) {
                    String[] cs;
                    for (String ta : cs = stokens[idx].split(";")) {
                        if (ta == null || ta.isEmpty()) continue;
                        if (((Boolean)isQuant.get(idx)).booleanValue()) {
                            if (ta.equals("NA")) {
                                anID.addAnno((String)headers.get(idx), Double.NaN);
                                continue;
                            }
                            anID.addAnno((String)headers.get(idx), Double.parseDouble(ta));
                            continue;
                        }
                        anID.addAnno((String)headers.get(idx), ta);
                    }
                }
                Taxon myTaxon = anID.build();
                if (!TaxaListIOUtils.doesTaxonHaveAllAnnotations(myTaxon, filters)) continue;
                taxaAL.add(myTaxon);
            }
            Collections.sort(taxaAL, new Comparator<Taxon>(){

                @Override
                public int compare(Taxon taxa1, Taxon taxa2) {
                    return taxa1.getName().compareTo(taxa2.getName());
                }
            });
            return taxaAL;
        }
        catch (Exception e) {
            System.err.println("Error in Reading Annotated Taxon File:" + fileName);
            e.printStackTrace();
            return null;
        }
    }

    public static void processFastQFile(Path keyPath, Path fastQPath, String enzymeName, TaxaList masterTaxaList, Map<Taxon, Tuple<BufferedWriter, String>> taxaFileMap, String outputDir, String projectName, boolean keyFormatIsNew) {
        int allReads = 0;
        int goodBarcodedReads = 0;
        int barCodeNotFound = 0;
        int badEndReads = 0;
        int currentTotal = 0;
        int first20hasN = 0;
        ArrayList<Taxon> tl = ConvertOldFastqToModernFormatPlugin.getLaneAnnotatedTaxaList(keyPath, fastQPath, keyFormatIsNew);
        HashMap<String, Taxon> nameToTaxon = new HashMap<String, Taxon>();
        for (Taxon taxon : tl) {
            String name = taxon.getName();
            nameToTaxon.put(name, taxon);
        }
        if (tl.size() == 0) {
            return;
        }
        BarcodeTrie barcodeTrie = GBSUtils.initializeBarcodeTrie(tl, masterTaxaList, new GBSEnzyme(enzymeName));
        BufferedReader br = Utils.getBufferedReader(fastQPath.toString(), 0x400000);
        long time = System.nanoTime();
        try {
            String[] seqAndQual;
            while ((seqAndQual = ConvertOldFastqToModernFormatPlugin.readAllFastQBlock(br, allReads)) != null) {
                BufferedWriter bw;
                ++allReads;
                ++currentTotal;
                Barcode barcode = barcodeTrie.longestPrefix(seqAndQual[1]);
                if (barcode == null) {
                    if (seqAndQual[1].contains("N")) {
                        ++first20hasN;
                    }
                    ++barCodeNotFound;
                    continue;
                }
                int barcodeLen = barcode.getBarLength();
                String adjustedSeq = seqAndQual[1].substring(barcodeLen);
                String adjustedQual = seqAndQual[3].substring(barcodeLen);
                Tuple<Integer, Integer> stringStartEnd = ConvertOldFastqToModernFormatPlugin.truncateToSecondCutSite(adjustedSeq, enzymeName);
                if (stringStartEnd == null) {
                    ++badEndReads;
                    continue;
                }
                adjustedSeq = adjustedSeq.substring((Integer)stringStartEnd.x, (Integer)stringStartEnd.y);
                adjustedQual = adjustedQual.substring((Integer)stringStartEnd.x, (Integer)stringStartEnd.y);
                ++goodBarcodedReads;
                Taxon readTaxon = barcode.getTaxon();
                Tuple<BufferedWriter, String> origTuple = taxaFileMap.get(readTaxon);
                if (origTuple == null) {
                    Taxon taxonWithAnno = (Taxon)nameToTaxon.get(readTaxon.getName());
                    GeneralAnnotation annotation = taxonWithAnno.getAnnotation();
                    String outFile = outputDir + "/" + projectName + "_" + readTaxon.getName() + "_" + annotation.getTextAnnotation(flowcellField)[0] + "_" + annotation.getTextAnnotation(laneField)[0] + "_" + barcode.getBarcodeString() + ".fastq";
                    taxaFileMap.put(readTaxon, new Tuple<Object, String>(null, outFile));
                    origTuple = taxaFileMap.get(readTaxon);
                }
                if ((bw = (BufferedWriter)origTuple.x) == null) {
                    bw = Utils.getBufferedWriter((String)origTuple.y);
                    taxaFileMap.put(readTaxon, new Tuple(bw, origTuple.y));
                }
                bw.write(seqAndQual[0]);
                bw.write("\n");
                bw.write(adjustedSeq);
                bw.write("\n");
                bw.write(seqAndQual[2]);
                bw.write("\n");
                bw.write(adjustedQual);
                bw.write("\n");
                if (currentTotal <= 1000000) continue;
                System.out.println("Reads processed so far: " + allReads);
                currentTotal = 0;
            }
            myLogger.info((Object)("Summary for " + fastQPath.toString() + "\nTotal number of reads in lane=" + allReads + "\nTotal number of good barcoded reads=" + goodBarcodedReads + "\nTotal number of bar codes not found=" + barCodeNotFound + "\nTotal number where first 20 bps of seq has N =" + first20hasN + "\nTotal number of read End not found=" + badEndReads + "\nTiming process (parsing, collapsing, and writing readBlock to file).\nProcess took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds."));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static String[] readAllFastQBlock(BufferedReader bw, int currentRead) throws IOException {
        String[] result = new String[4];
        try {
            result[0] = bw.readLine();
            result[1] = bw.readLine();
            if (result[0] == null) {
                return null;
            }
            result[2] = bw.readLine();
            result[3] = bw.readLine();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            myLogger.error((Object)("Unable to correctly parse the fastQ read nead line: " + currentRead * 4 + " from fastq file.  Your fastq file may have been corrupted."));
            return null;
        }
    }

    private static Tuple<Integer, Integer> truncateToSecondCutSite(String seq, String enzyme) {
        int seqStart = 0;
        if (enzyme.equalsIgnoreCase("ApeKI") && (seq.startsWith("CAGCTGC") || seq.startsWith("CTGCAGC"))) {
            seq = seq.substring(3, seq.length());
            seqStart = 3;
        }
        int indexOfReadEnd = -1;
        String shortSeq = seq.substring(20);
        for (String readEnd : likelyReadEndStrings) {
            int indx = shortSeq.indexOf(readEnd);
            if (indx <= 0 || indexOfReadEnd >= 0 && indx >= indexOfReadEnd) continue;
            indexOfReadEnd = indx;
        }
        if (indexOfReadEnd < 0) {
            return new Tuple<Integer, Integer>(seqStart, seq.length() - seqStart);
        }
        int tagLen = indexOfReadEnd + 20 + readEndCutSiteRemnantLength;
        return new Tuple<Integer, Integer>(seqStart, tagLen);
    }

    private static void Shutdown(Map<Taxon, Tuple<BufferedWriter, String>> taxaWriterMap) {
        if (taxaWriterMap == null) {
            return;
        }
        try {
            for (Map.Entry<Taxon, Tuple<BufferedWriter, String>> entry : taxaWriterMap.entrySet()) {
                BufferedWriter bw = (BufferedWriter)entry.getValue().x;
                if (bw == null) continue;
                bw.close();
            }
        }
        catch (Exception e) {
            System.out.println("Problem with shutdown");
            e.printStackTrace();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "ConvertOldFastqToModernFormat";
    }

    @Override
    public String getToolTipText() {
        return "Fastq files formatted with multiple taxa and bar codes are transformed into Illumina format with 1 taxa per file and no bar codes in the read sequence";
    }

    public String inputFile() {
        return this.inputFile.value();
    }

    public ConvertOldFastqToModernFormatPlugin inputFile(String value) {
        this.inputFile = new PluginParameter<String>(this.inputFile, value);
        return this;
    }

    public String keyFile() {
        return this.keyFile.value();
    }

    public ConvertOldFastqToModernFormatPlugin keyFile(String value) {
        this.keyFile = new PluginParameter<String>(this.keyFile, value);
        return this;
    }

    public String projectName() {
        return this.projectName.value();
    }

    public ConvertOldFastqToModernFormatPlugin projectName(String value) {
        this.projectName = new PluginParameter<String>(this.projectName, value);
        return this;
    }

    public String outputDir() {
        return this.outputDir.value();
    }

    public ConvertOldFastqToModernFormatPlugin outputDir(String value) {
        this.outputDir = new PluginParameter<String>(this.outputDir, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public ConvertOldFastqToModernFormatPlugin enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }
}

