/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.SuperByteMatrix;

public class SuperByteMatrixSingle
implements SuperByteMatrix {
    private final byte[] myData;
    private int myNumRows;
    private int myNumColumns;
    private final long myPrecompute1;

    SuperByteMatrixSingle(int rows, int columns) {
        this.myNumRows = rows;
        this.myNumColumns = columns;
        this.myPrecompute1 = (long)this.myNumColumns * (long)this.myNumRows - 1L;
        long numElements = (long)this.myNumRows * (long)this.myNumColumns;
        if (numElements > 0x7FFFFFF5L) {
            throw new IllegalArgumentException("SuperByteMatrixSingle: init: this number of rows: " + rows + "  and columns: " + columns + " is too large for SuperByteMatrixSingle.");
        }
        this.myData = new byte[(int)numElements];
    }

    @Override
    public void set(int row, int column, byte value) {
        this.myData[this.getIndex((int)row, (int)column)] = value;
    }

    @Override
    public void arraycopy(int row, byte[] src, int startColumn) {
        int start = this.getIndex(row, startColumn);
        System.arraycopy(src, 0, this.myData, start, src.length);
    }

    @Override
    public void setAll(byte value) {
        Arrays.fill(this.myData, value);
    }

    @Override
    public byte get(int row, int column) {
        return this.myData[this.getIndex(row, column)];
    }

    @Override
    public byte[] getAllColumns(int row) {
        if (row < 0 || row >= this.myNumRows) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingle: getAllColumns: row: " + row);
        }
        int start = this.getIndex(row, 0);
        byte[] result = new byte[this.myNumColumns];
        System.arraycopy(this.myData, start, result, 0, this.myNumColumns);
        return result;
    }

    @Override
    public byte[] getColumnRange(int row, int start, int end) {
        if (row < 0 || row >= this.myNumRows) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingle: getColumnRange: row: " + row);
        }
        if (start < 0 || start >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingle: getColumnRange: start: " + start);
        }
        if (end < 0 || end >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingle: getColumnRange: end: " + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("SuperByteMatrixSingle: getColumnRange: end: " + end + " less than start: " + start);
        }
        int startIndex = this.getIndex(row, start);
        int numElements = end - start;
        byte[] result = new byte[numElements];
        System.arraycopy(this.myData, startIndex, result, 0, numElements);
        return result;
    }

    @Override
    public byte[] getAllRows(int column) {
        if (column < 0 || column >= this.myNumColumns) {
            throw new IndexOutOfBoundsException("SuperByteMatrixSingle: getAllRows: column: " + column);
        }
        byte[] result = new byte[this.myNumRows];
        int current = column;
        for (int i = 0; i < this.myNumRows; ++i) {
            result[i] = this.myData[current];
            current += this.myNumColumns;
        }
        return result;
    }

    private int getIndex(int row, int column) {
        return row * this.myNumColumns + column;
    }

    @Override
    public int getNumRows() {
        return this.myNumRows;
    }

    @Override
    public int getNumColumns() {
        return this.myNumColumns;
    }

    @Override
    public boolean isColumnInnerLoop() {
        return true;
    }

    private int translateIndexForTranspose(long index) {
        return (int)((index + index % (long)this.myNumRows * this.myPrecompute1) / (long)this.myNumRows);
    }

    public void transpose() {
        int numElements = this.myNumColumns * this.myNumRows;
        OpenBitSet notVisited = new OpenBitSet(numElements);
        notVisited.set(0L, numElements);
        int currentIndex = 1;
        while (currentIndex != -1) {
            if ((currentIndex = notVisited.nextSetBit(currentIndex)) == -1) continue;
            byte temp = this.myData[currentIndex];
            int srcIndex = this.translateIndexForTranspose(currentIndex);
            int destIndex = currentIndex;
            while (srcIndex != currentIndex) {
                this.myData[destIndex] = this.myData[srcIndex];
                notVisited.fastClear(destIndex);
                destIndex = srcIndex;
                srcIndex = this.translateIndexForTranspose(destIndex);
            }
            this.myData[destIndex] = temp;
            notVisited.fastClear(destIndex);
        }
        int tempSize = this.myNumColumns;
        this.myNumColumns = this.myNumRows;
        this.myNumRows = tempSize;
    }

    @Override
    public void reorderRows(int[] newIndices) {
        if (newIndices.length != this.myNumRows) {
            throw new IllegalArgumentException("SuperByteMatrixSingle: reorderRows: index array size: " + newIndices.length + " doesn't equal num rows in matrix: " + this.myNumRows);
        }
        int[] tempIndices = new int[newIndices.length];
        System.arraycopy(newIndices, 0, tempIndices, 0, this.myNumRows);
        int currentRow = 0;
        byte[] temp = new byte[this.myNumColumns];
        while (currentRow < this.myNumRows) {
            while (currentRow < this.myNumRows && (tempIndices[currentRow] == currentRow || tempIndices[currentRow] == -1)) {
                tempIndices[currentRow] = -1;
                ++currentRow;
            }
            if (currentRow >= this.myNumRows) continue;
            System.arraycopy(this.myData, this.getIndex(currentRow, 0), temp, 0, this.myNumColumns);
            int srcRow = tempIndices[currentRow];
            int destRow = currentRow;
            while (srcRow != currentRow) {
                System.arraycopy(this.myData, this.getIndex(srcRow, 0), this.myData, this.getIndex(destRow, 0), this.myNumColumns);
                tempIndices[destRow] = -1;
                destRow = srcRow;
                srcRow = tempIndices[destRow];
            }
            System.arraycopy(temp, 0, this.myData, this.getIndex(destRow, 0), this.myNumColumns);
            tempIndices[destRow] = -1;
        }
    }

    @Override
    public void reorderColumns(int[] newIndices) {
        if (newIndices.length != this.myNumColumns) {
            throw new IllegalArgumentException("SuperByteMatrixSingle: reorderColumns: index array size: " + newIndices.length + " doesn't equal num columns in matrix: " + this.myNumColumns);
        }
        int[] tempIndices = new int[newIndices.length];
        System.arraycopy(newIndices, 0, tempIndices, 0, this.myNumColumns);
        int currentRow = 0;
        byte[] temp = new byte[this.myNumRows];
        while (currentRow < this.myNumColumns) {
            int r;
            while (currentRow < this.myNumColumns && (tempIndices[currentRow] == currentRow || tempIndices[currentRow] == -1)) {
                tempIndices[currentRow] = -1;
                ++currentRow;
            }
            if (currentRow >= this.myNumColumns) continue;
            for (int r2 = 0; r2 < this.myNumRows; ++r2) {
                temp[r2] = this.get(r2, currentRow);
            }
            int srcColumn = tempIndices[currentRow];
            int destColumn = currentRow;
            while (srcColumn != currentRow) {
                for (r = 0; r < this.myNumRows; ++r) {
                    this.set(r, destColumn, this.get(r, srcColumn));
                }
                tempIndices[destColumn] = -1;
                destColumn = srcColumn;
                srcColumn = tempIndices[destColumn];
            }
            for (r = 0; r < this.myNumRows; ++r) {
                this.set(r, destColumn, temp[r]);
            }
            tempIndices[destColumn] = -1;
        }
    }

    @Override
    public void setHetsTo(byte value) {
        for (int i = 0; i < this.myData.length; ++i) {
            if ((this.myData[i] >>> 4 & 0xF) == (this.myData[i] & 0xF)) continue;
            this.myData[i] = value;
        }
    }

    @Override
    public Stream<Byte> stream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Stream<Byte> stream(int row) {
        int start = row * this.myNumColumns;
        return StreamSupport.stream(new SuperByteMatrixSingleSpliterator(start, start + this.myNumColumns), true);
    }

    public Spliterator<Byte> spliterator() {
        return new SuperByteMatrixSingleSpliterator(0, this.myData.length);
    }

    class SuperByteMatrixSingleSpliterator<T extends Byte>
    implements Spliterator<Byte> {
        private int myCurrentIndex;
        private final int myFence;

        SuperByteMatrixSingleSpliterator(int currentIndex, int fence) {
            this.myCurrentIndex = currentIndex;
            this.myFence = fence;
        }

        @Override
        public void forEachRemaining(Consumer<? super Byte> action) {
            while (this.myCurrentIndex < this.myFence) {
                action.accept((Byte)SuperByteMatrixSingle.this.myData[this.myCurrentIndex]);
                ++this.myCurrentIndex;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Byte> action) {
            if (this.myCurrentIndex < this.myFence) {
                action.accept((Byte)SuperByteMatrixSingle.this.myData[this.myCurrentIndex]);
                ++this.myCurrentIndex;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Byte> trySplit() {
            int lo = this.myCurrentIndex;
            int mid = lo + this.myFence >>> 1;
            if (lo < mid) {
                this.myCurrentIndex = mid;
                return new SuperByteMatrixSingleSpliterator<T>(lo, mid);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentIndex;
        }

        @Override
        public int characteristics() {
            return 17488;
        }
    }
}

