/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.BufferedWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.util.SimpleTableReport;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TableReportBuilder {
    private static final Logger myLogger = Logger.getLogger(TableReportBuilder.class);
    private static final String DELIMITER = "\t";
    private final String myTableName;
    private final Object[] myColumnNames;
    private final List<Object[]> myData;
    private final String myFilename;
    private final BufferedWriter myWriter;
    private final boolean myInMemory;
    private final int myNumColumns;

    private TableReportBuilder(String tableName, Object[] columnNames) {
        this.myTableName = tableName;
        this.myColumnNames = columnNames;
        this.myNumColumns = columnNames.length;
        this.myData = new ArrayList<Object[]>();
        this.myFilename = null;
        this.myWriter = null;
        this.myInMemory = true;
    }

    private TableReportBuilder(String tableName, int numColumns) {
        this.myTableName = tableName;
        this.myColumnNames = null;
        this.myNumColumns = numColumns;
        this.myData = new ArrayList<Object[]>();
        this.myFilename = null;
        this.myWriter = null;
        this.myInMemory = true;
    }

    private TableReportBuilder(String tableName, Object[] columnNames, String filename) {
        this.myTableName = tableName;
        this.myColumnNames = columnNames;
        this.myNumColumns = columnNames.length;
        this.myData = null;
        this.myFilename = Utils.addSuffixIfNeeded(filename, ".txt");
        this.myWriter = Utils.getBufferedWriter(this.myFilename);
        this.myInMemory = false;
        try {
            this.writeRow(columnNames);
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TableReportBuilder: init: Problem adding headers to file: " + this.myFilename + ": " + e.getMessage());
        }
    }

    public static TableReport readTableReport(String saveFile) {
        return TableReportUtils.readDelimitedTableReport(saveFile, DELIMITER);
    }

    public static TableReportBuilder getInstance(String tableName, Object[] columnNames) {
        return new TableReportBuilder(tableName, columnNames);
    }

    public static TableReportBuilder getInstance(String tableName, int numColumns) {
        return new TableReportBuilder(tableName, numColumns);
    }

    public static TableReportBuilder getInstance(String tableName, Object[] columnNames, String filename) {
        return new TableReportBuilder(tableName, columnNames, filename);
    }

    public void add(Object[] row) {
        if (this.myNumColumns != row.length) {
            throw new IllegalArgumentException("TableReportBuilder: add: number of row elements: " + row.length + " doesn't equal number of headers: " + this.myNumColumns);
        }
        if (this.myInMemory) {
            this.myData.add(row);
        } else {
            this.writeRow(row);
        }
    }

    public void addElements(Object ... rowElements) {
        Object[] list = new Object[this.myNumColumns];
        int index = 0;
        for (Object rowElement : rowElements) {
            if (rowElement.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(rowElement); ++i) {
                    list[index++] = Array.get(rowElement, i);
                }
                continue;
            }
            list[index++] = rowElement;
        }
        this.add(list);
    }

    private void writeRow(Object[] row) {
        try {
            for (int i = 0; i < row.length; ++i) {
                if (i != 0) {
                    this.myWriter.write(DELIMITER);
                }
                this.myWriter.write(row[i].toString());
            }
            this.myWriter.write("\n");
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TableReportBuilder: writeRow: Problem adding row to file: " + this.myFilename + ": " + e.getMessage());
        }
    }

    public TableReport build() {
        if (this.myInMemory) {
            return new SimpleTableReport(this.myTableName, this.myColumnNames, (Object[][])this.myData.toArray((T[])new Object[this.myData.size()][]));
        }
        try {
            this.myWriter.close();
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("TableReportBuilder: build: Problem closing file: " + this.myFilename + ": " + e.getMessage());
        }
        return null;
    }
}

