/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.maizegenetics.util.Graph;
import net.maizegenetics.util.Tuple;

public class UndirectedGraph<T>
implements Graph<T> {
    private final HashSet<T> nodes;
    private final ImmutableSetMultimap<T, T> adj;
    private final HashMap<Tuple<T, T>, Double> wts;

    public UndirectedGraph(HashSet<T> nodes, ImmutableSetMultimap<T, T> adj, HashMap<Tuple<T, T>, Double> wts) {
        this.nodes = nodes;
        this.adj = adj;
        this.wts = wts;
    }

    @Override
    public Iterator<T> nodesIter() {
        return this.nodes.iterator();
    }

    @Override
    public Collection<T> nodes() {
        return this.nodes;
    }

    @Override
    public int numberOfNodes() {
        return this.nodes.size();
    }

    @Override
    public boolean hasNode(T n) {
        return this.nodes.contains(n);
    }

    @Override
    public boolean hasEdge(T u, T v) {
        return this.adj.containsEntry(u, v);
    }

    @Override
    public Collection<T> neighbors(T n) {
        return this.adj.get(n);
    }

    @Override
    public Collection<Map.Entry<T, T>> edges() {
        return new UndirectedSet<Map.Entry<T, T>>(this.adj.entries());
    }

    @Override
    public Iterator<Map.Entry<T, T>> edgesIter() {
        return new UndirectedIterator((Iterator)this.adj.entries().iterator());
    }

    @Override
    public int degree(T n) {
        return this.adj.get(n).size();
    }

    @Override
    public int size() {
        return this.adj.size() / 2;
    }

    @Override
    public double size(boolean weighted) {
        if (weighted) {
            double total_size = 0.0;
            Iterator<Map.Entry<T, T>> it = this.edgesIter();
            while (it.hasNext()) {
                Map.Entry<T, T> entry = it.next();
                total_size += this.wts.get(new Tuple<T, T>(entry.getKey(), entry.getValue())).doubleValue();
            }
            return total_size;
        }
        return this.size();
    }

    protected class UndirectedSet<E>
    extends HashSet<E> {
        boolean instantiated;

        public UndirectedSet(ImmutableSet c) {
            super(c);
            this.instantiated = false;
            this.instantiated = true;
        }

        @Override
        public boolean add(E e) {
            if (this.instantiated) {
                throw new UnsupportedOperationException("Immutable");
            }
            return super.add(e);
        }

        public UndirectedIterator iterator() {
            return new UndirectedIterator(super.iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] arr = new Object[this.size()];
            int i = 0;
            UndirectedIterator it = this.iterator();
            while (it.hasNext()) {
                arr[i] = it.next();
                ++i;
            }
            return arr;
        }

        @Override
        public int size() {
            return super.size() / 2;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.instantiated) {
                throw new UnsupportedOperationException("Immutable");
            }
            return super.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Immutable");
        }
    }

    protected class UndirectedIterator
    implements Iterator {
        private final HashSet<Tuple<T, T>> added = new HashSet();
        private final Iterator<Map.Entry<T, T>> it;
        private Map.Entry<T, T> on_deck;

        public UndirectedIterator(Iterator it) {
            this.it = it;
            this.on_deck = this.it.hasNext() ? this.it.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.on_deck != null;
        }

        public Map.Entry<T, T> next() {
            if (this.on_deck == null) {
                throw new NoSuchElementException();
            }
            Map.Entry return_val = this.on_deck;
            this.added.add(new Tuple(return_val.getKey(), return_val.getValue()));
            if (this.it.hasNext()) {
                while (this.it.hasNext()) {
                    this.on_deck = this.it.next();
                    if (this.added.contains(new Tuple(this.on_deck.getValue(), this.on_deck.getKey()))) {
                        this.on_deck = null;
                        continue;
                    }
                    break;
                }
            } else {
                this.on_deck = null;
            }
            return return_val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Immutable");
        }
    }
}

