/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import net.maizegenetics.util.db.DBTuple;
import net.maizegenetics.util.db.DataAccessException;
import net.maizegenetics.util.db.SQL;

public class ResultSetIterator
implements Iterator<DBTuple> {
    private ResultSet rs;
    private PreparedStatement ps;
    private Connection connection;
    private String sql;

    public ResultSetIterator(Connection connection, String sql) {
        assert (connection != null);
        assert (sql != null);
        this.connection = connection;
        this.sql = sql;
    }

    public void init() {
        try {
            this.ps = this.connection.prepareStatement(this.sql);
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            this.close();
            throw new DataAccessException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.ps == null) {
            this.init();
        }
        try {
            boolean hasMore = this.rs.next();
            if (!hasMore) {
                this.close();
            }
            return hasMore;
        }
        catch (SQLException e) {
            this.close();
            throw new DataAccessException(e);
        }
    }

    void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (this.ps != null) {
                this.ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public DBTuple next() {
        try {
            return SQL.rowAsTuple(this.sql, this.rs);
        }
        catch (DataAccessException e) {
            this.close();
            throw e;
        }
    }
}

