/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.association.FixedEffectLM;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SolveByOrthogonalizing;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.log4j.Logger;

public abstract class AbstractFixedEffectLM
implements FixedEffectLM {
    protected static Logger myLogger = Logger.getLogger(AbstractFixedEffectLM.class);
    protected final Datum myDatum;
    protected final GenotypePhenotype myGenoPheno;
    protected final int numberOfObservations;
    protected final int numberOfSites;
    protected final List<PhenotypeAttribute> myDataAttributes;
    protected final List<PhenotypeAttribute> myFactorAttributes;
    protected final List<PhenotypeAttribute> myCovariateAttributes;
    protected TableReportBuilder siteReportBuilder;
    protected TableReportBuilder alleleReportBuilder;
    protected int numberOfSiteReportColumns;
    protected int numberOfAlleleReportColumns;
    protected float[] allData;
    protected int myCurrentSite;
    protected int myCurrentSiteMinimumClassSize;
    protected double[] siteData;
    protected OpenBitSet missingObsForSite;
    protected String currentTraitName;
    protected boolean areTaxaReplicated;
    protected boolean saveToFile = false;
    protected String siteReportFilename;
    protected String alleleReportFilename;
    protected double maxP = 1.0;
    protected FixedEffectLMPlugin myParentPlugin;
    protected boolean appendAddDomEffects = false;
    protected int minClassSize = 0;
    protected boolean biallelicOnly = false;
    protected boolean outputSiteStats = false;
    protected String siteStatsFile = null;
    protected boolean permute = false;
    protected int numberOfPermutations = 0;
    protected double[] minP = null;
    protected List<DoubleMatrix> permutedData;
    protected double[] baseErrorSSdf;
    protected double[] totalcfmSSdf;
    protected double[] markerSSdf;
    protected double[] errorSSdf;
    protected List<Object[]> siteTableReportRows;
    protected int markerpvalueColumn;
    protected int permpvalueColumn;
    protected ArrayList<ModelEffect> myModel;
    protected DoubleMatrix G;
    protected ArrayList<ModelEffect> myBaseModel;
    protected int numberOfBaseEffects;
    protected int taxaEffectNumber;
    protected int randomSeed;
    protected boolean useRandomSeed = false;
    protected Random rand = null;
    protected static final Map<SiteScore.SITE_SCORE_TYPE, String> typeNameMap = new HashMap<SiteScore.SITE_SCORE_TYPE, String>();

    public AbstractFixedEffectLM(Datum dataset, FixedEffectLMPlugin parentPlugin) {
        this.myDatum = dataset;
        this.myParentPlugin = parentPlugin;
        this.myGenoPheno = (GenotypePhenotype)this.myDatum.getData();
        this.numberOfObservations = this.myGenoPheno.phenotype().numberOfObservations();
        this.numberOfSites = this.myGenoPheno.genotypeTable().numberOfSites();
        this.myDataAttributes = this.myGenoPheno.phenotype().attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        this.myFactorAttributes = this.myGenoPheno.phenotype().attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        this.myCovariateAttributes = this.myGenoPheno.phenotype().attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
        this.siteTableReportRows = new ArrayList<Object[]>();
        this.testTaxaReplication();
    }

    @Override
    public void initializeReportBuilders() {
        String tableName = "GLM Statistics - " + this.myDatum.getName();
        Object[] columnNames = this.siteReportColumnNames();
        this.numberOfSiteReportColumns = columnNames.length;
        this.siteReportBuilder = this.saveToFile ? TableReportBuilder.getInstance(tableName, columnNames, this.siteReportFilename) : TableReportBuilder.getInstance(tableName, columnNames);
        tableName = "GLM Genotype Effects - " + this.myDatum.getName();
        columnNames = this.alleleReportColumnNames();
        this.numberOfAlleleReportColumns = columnNames.length;
        this.alleleReportBuilder = this.saveToFile ? TableReportBuilder.getInstance(tableName, columnNames, this.alleleReportFilename) : TableReportBuilder.getInstance(tableName, columnNames);
    }

    @Override
    public void solve() {
        this.initializeReportBuilders();
        int numberOfAttributes = this.myDataAttributes.size();
        int numberOfTestsTotal = numberOfAttributes * this.numberOfSites;
        int numberOfTestsCalculated = 0;
        int updateInterval = Math.max(1, numberOfTestsTotal / 100);
        for (PhenotypeAttribute dataAttribute : this.myDataAttributes) {
            this.currentTraitName = dataAttribute.name();
            OpenBitSet missingObs = new OpenBitSet(dataAttribute.missing());
            for (PhenotypeAttribute attr : this.myFactorAttributes) {
                missingObs.or(attr.missing());
            }
            for (PhenotypeAttribute attr : this.myCovariateAttributes) {
                missingObs.or(attr.missing());
            }
            this.allData = (float[])dataAttribute.allValues();
            if (this.permute) {
                this.missingObsForSite = missingObs;
                this.createPermutedData();
            }
            for (int s = 0; s < this.numberOfSites; ++s) {
                this.myCurrentSite = s;
                this.getGenotypeAndUpdateMissing(missingObs);
                boolean keepSite = this.applySiteFilters();
                if (!keepSite) continue;
                this.siteData = AssociationUtils.getNonMissingDoubles(this.allData, (BitSet)this.missingObsForSite);
                this.myBaseModel = this.baseModel();
                this.numberOfBaseEffects = this.myBaseModel.size();
                this.analyzeSite();
                if (this.permute) {
                    this.updateMinP(missingObs);
                }
                if (++numberOfTestsCalculated % updateInterval != 0) continue;
                double percentTested = 100.0 * (double)numberOfTestsCalculated / (double)numberOfTestsTotal;
                percentTested = Math.min(percentTested, 100.0);
                if (this.myParentPlugin == null) continue;
                this.myParentPlugin.updateProgress((int)percentTested);
            }
            if (!this.permute) continue;
            this.updateReportsWithPermutationP();
        }
        if (this.saveToFile) {
            this.siteReportBuilder.build();
            this.alleleReportBuilder.build();
        }
    }

    private boolean applySiteFilters() {
        if (!this.myGenoPheno.genotypeTable().hasGenotype()) {
            return true;
        }
        byte[] siteGeno = this.myGenoPheno.genotypeAllTaxa(this.myCurrentSite);
        int nsites = siteGeno.length;
        HashMap<Byte, Integer> genoCountMap = new HashMap<Byte, Integer>();
        for (int s = 0; s < nsites; ++s) {
            if (this.missingObsForSite.get(s)) continue;
            Integer genoCount = (Integer)genoCountMap.get(siteGeno[s]);
            if (genoCount == null) {
                genoCountMap.put(siteGeno[s], 1);
                continue;
            }
            genoCountMap.put(siteGeno[s], genoCount + 1);
        }
        boolean keepSite = true;
        if (this.biallelicOnly) {
            keepSite = false;
            if (genoCountMap.size() == 2) {
                keepSite = true;
            } else if (genoCountMap.size() == 3) {
                int hetCount = 0;
                for (Byte genoval : genoCountMap.keySet()) {
                    if (!GenotypeTableUtils.isHeterozygous(genoval)) continue;
                    ++hetCount;
                }
                if (hetCount == 1) {
                    keepSite = true;
                }
            }
        }
        if (keepSite && this.minClassSize > 0) {
            int numberBigEnough = 0;
            int numberTooSmall = 0;
            for (Integer ival : genoCountMap.values()) {
                if (ival < this.minClassSize) {
                    ++numberTooSmall;
                    continue;
                }
                ++numberBigEnough;
            }
            if (numberBigEnough < 2) {
                keepSite = false;
            } else if (numberTooSmall > 0) {
                for (Byte Bval : genoCountMap.keySet()) {
                    int classSize = (Integer)genoCountMap.get(Bval);
                    if (classSize >= this.minClassSize) continue;
                    byte classValue = Bval;
                    for (int s = 0; s < nsites; ++s) {
                        if (siteGeno[s] != classValue) continue;
                        this.missingObsForSite.set(s);
                    }
                }
                this.getGenotypeAfterUpdatingMissing();
            }
        }
        ArrayList classSizes = new ArrayList(genoCountMap.values());
        Collections.sort(classSizes);
        int nclasses = classSizes.size();
        this.myCurrentSiteMinimumClassSize = nclasses > 1 ? (Integer)classSizes.get(nclasses - 2) : 0;
        return keepSite;
    }

    @Override
    public TableReport siteReport() {
        this.saveToFile = true;
        return this.siteReportBuilder.build();
    }

    @Override
    public TableReport alleleReport() {
        this.saveToFile = true;
        return this.alleleReportBuilder.build();
    }

    @Override
    public List<Datum> datumList() {
        ArrayList<Datum> dataList = new ArrayList<Datum>();
        StringBuilder comment = new StringBuilder();
        comment.append("GLM Output\nStatistical Tests for individual variants.\n");
        comment.append("Input data: " + this.myDatum.getName()).append("\n");
        dataList.add(new Datum("GLM_Stats_" + this.myDatum.getName(), this.siteReport(), comment.toString()));
        comment = new StringBuilder();
        comment.append("GLM Output\nGenotype Effect Estimates\n");
        comment.append("Input data: " + this.myDatum.getName()).append("\n");
        dataList.add(new Datum("GLM_Genotypes_" + this.myDatum.getName(), this.alleleReport(), comment.toString()));
        return dataList;
    }

    @Override
    public void permutationTest(boolean permute, int nperm) {
        this.permute = permute;
        this.numberOfPermutations = nperm;
    }

    protected abstract void getGenotypeAndUpdateMissing(BitSet var1);

    protected abstract void getGenotypeAfterUpdatingMissing();

    protected abstract void analyzeSite();

    protected String[] siteReportColumnNames() {
        this.markerpvalueColumn = 5;
        this.permpvalueColumn = 6;
        if (this.appendAddDomEffects && !this.permute) {
            return new String[]{"Trait", "Marker", "Chr", "Pos", "marker_F", "p", "marker_Rsq", "add_F", "add_p", "dom_F", "dom_p", "marker_df", "marker_MS", "error_df", "error_MS", "model_df", "model_MS", "minorObs", "addEffect", "domEffect"};
        }
        if (this.appendAddDomEffects && this.permute) {
            return new String[]{"Trait", "Marker", "Chr", "Pos", "marker_F", "p", "perm_p", "marker_Rsq", "add_F", "add_p", "dom_F", "dom_p", "marker_df", "marker_MS", "error_df", "error_MS", "model_df", "model_MS", "minorObs", "addEffect", "domEffect"};
        }
        if (this.permute) {
            return new String[]{"Trait", "Marker", "Chr", "Pos", "marker_F", "p", "perm_p", "marker_Rsq", "add_F", "add_p", "dom_F", "dom_p", "marker_df", "marker_MS", "error_df", "error_MS", "model_df", "model_MS", "minorObs"};
        }
        return new String[]{"Trait", "Marker", "Chr", "Pos", "marker_F", "p", "marker_Rsq", "add_F", "add_p", "dom_F", "dom_p", "marker_df", "marker_MS", "error_df", "error_MS", "model_df", "model_MS", "minorObs"};
    }

    protected String[] alleleReportColumnNames() {
        return new String[]{"Trait", "Marker", "Chr", "Pos", "Obs", "Allele", "Estimate"};
    }

    protected ArrayList<ModelEffect> baseModel() {
        int numberOfNonmissingObs = this.numberOfObservations - (int)this.missingObsForSite.cardinality();
        ArrayList<ModelEffect> modelEffects = new ArrayList<ModelEffect>();
        FactorModelEffect meanEffect = new FactorModelEffect(new int[numberOfNonmissingObs], false);
        meanEffect.setID("mean");
        modelEffects.add(meanEffect);
        for (PhenotypeAttribute attr : this.myFactorAttributes) {
            Object[] factorLabels = AssociationUtils.getNonMissingValues((String[])attr.allValues(), (BitSet)this.missingObsForSite);
            FactorModelEffect fme = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(factorLabels), true, attr.name());
            modelEffects.add(fme);
        }
        for (PhenotypeAttribute attr : this.myCovariateAttributes) {
            double[] values = AssociationUtils.getNonMissingDoubles((float[])attr.allValues(), (BitSet)this.missingObsForSite);
            CovariateModelEffect cme = new CovariateModelEffect(values, attr.name());
            modelEffects.add(cme);
        }
        return modelEffects;
    }

    protected void createPermutedData() {
        this.permutedData = new LinkedList<DoubleMatrix>();
        double[] y = AssociationUtils.getNonMissingDoubles(this.allData, (BitSet)this.missingObsForSite);
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.baseModel(), y);
        DoubleMatrix residuals = sflm.getResiduals();
        DoubleMatrix predicted = sflm.getPredictedValues();
        this.baseErrorSSdf = sflm.getResidualSSdf();
        this.totalcfmSSdf = new double[2];
        double[] modelSSdf = sflm.getModelcfmSSdf();
        this.totalcfmSSdf[0] = this.baseErrorSSdf[0] + modelSSdf[0];
        this.totalcfmSSdf[1] = this.baseErrorSSdf[1] + modelSSdf[1];
        if (this.rand == null) {
            this.rand = this.useRandomSeed ? new Random(this.randomSeed) : new Random();
        }
        for (int p = 0; p < this.numberOfPermutations; ++p) {
            LinearModelUtils.shuffle(residuals, this.rand);
            DoubleMatrix permdm = predicted.plus(residuals);
            this.permutedData.add(permdm);
        }
        this.minP = new double[this.numberOfPermutations];
        Arrays.fill(this.minP, 1.0);
    }

    protected void updateReportsWithPermutationP() {
        Arrays.sort(this.minP);
        for (Object[] row : this.siteTableReportRows) {
            double permPval;
            double pval = (Double)row[this.markerpvalueColumn];
            int ndx = Arrays.binarySearch(this.minP, pval);
            if (ndx < 0) {
                ndx = -(ndx + 1);
            }
            if ((permPval = (double)(ndx + 1) / (double)this.numberOfPermutations) > 1.0) {
                permPval = 1.0;
            }
            row[this.permpvalueColumn] = new Double(permPval);
        }
    }

    protected ModelEffect taxaEffect() {
        Taxon[] myTaxa = this.myGenoPheno.phenotype().taxaAttribute().allTaxa();
        Object[] myNonMissingTaxa = AssociationUtils.getNonMissingValues(myTaxa, (BitSet)this.missingObsForSite);
        int[] taxaLevels = ModelEffectUtils.getIntegerLevels(myNonMissingTaxa);
        FactorModelEffect taxaEffect = new FactorModelEffect(taxaLevels, true, "Taxon");
        return taxaEffect;
    }

    protected void testTaxaReplication() {
        this.areTaxaReplicated = false;
        int numberOfObservations = this.myGenoPheno.phenotype().numberOfObservations();
        int numberOfTaxa = this.myGenoPheno.genotypeTable().numberOfTaxa();
        if (numberOfTaxa < numberOfObservations) {
            String msg = "There are more phenotype observations than taxa with genotypes. Either some taxa have multiple phenotypes or some taxa do not have genotypes. Tassel version 5 will not run GLM when that is the case. Be sure to use an intersect join to merge genotypes and phenotypes.";
            throw new RuntimeException(msg);
        }
    }

    protected void updateMinP(BitSet missingObsBeforeSite) {
        block14: {
            int iter;
            OpenBitSet newMissing;
            block15: {
                boolean useFastMethod;
                block13: {
                    useFastMethod = false;
                    int numberOfObsTotal = this.allData.length;
                    int numberOfMissingBeforeSite = (int)missingObsBeforeSite.cardinality();
                    int sizeOfPermutedData = this.permutedData.get(0).numberOfRows();
                    newMissing = new OpenBitSet(sizeOfPermutedData);
                    int permutedDataIndex = -1;
                    for (int i = 0; i < numberOfObsTotal; ++i) {
                        if (missingObsBeforeSite.fastGet(i)) continue;
                        ++permutedDataIndex;
                        if (!this.missingObsForSite.fastGet(i)) continue;
                        newMissing.fastSet(permutedDataIndex);
                    }
                    if (!this.areTaxaReplicated) break block13;
                    iter = 0;
                    for (DoubleMatrix pdata : this.permutedData) {
                        double[] y = AssociationUtils.getNonMissingDoubles(pdata.to1DArray(), (BitSet)newMissing);
                        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, y);
                        this.markerSSdf = sflm.getIncrementalSSdf(this.numberOfBaseEffects);
                        this.errorSSdf = sflm.getIncrementalSSdf(this.taxaEffectNumber);
                        double F = this.markerSSdf[0] / this.markerSSdf[1] / this.errorSSdf[0] * this.errorSSdf[1];
                        try {
                            double p = LinearModelUtils.Ftest(F, this.markerSSdf[1], this.errorSSdf[1]);
                            if (this.minP[iter] > p) {
                                this.minP[iter] = p;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++iter;
                    }
                    break block14;
                }
                if (!useFastMethod) break block15;
                int numberOfModelEffects = this.myModel.size();
                ArrayList<ModelEffect> thisBaseModel = new ArrayList<ModelEffect>(this.myModel);
                ModelEffect markerEffect = (ModelEffect)thisBaseModel.remove(this.myModel.size() - 1);
                List<double[]> permutedArrays = this.permutedData.stream().map(dm -> dm.to1DArray()).map(da -> AssociationUtils.getNonMissingDoubles(da, newMissing)).collect(Collectors.toList());
                SolveByOrthogonalizing sbo = SolveByOrthogonalizing.getInstanceFromModel(thisBaseModel, permutedArrays);
                DoubleMatrix X = markerEffect.getX();
                SolveByOrthogonalizing.Marker markerRValues = null;
                if (X.numberOfColumns() == 1) {
                    markerRValues = sbo.solveForR(null, X.to1DArray());
                } else if (X.numberOfColumns() == 2) {
                    markerRValues = sbo.solveForR(null, X.column(0).to1DArray(), X.column(1).to1DArray());
                }
                if (markerRValues == null) break block14;
                int n = X.numberOfRows();
                for (int iter2 = 0; iter2 < this.numberOfPermutations; ++iter2) {
                    if (!(this.minP[iter2] > markerRValues.vector2()[iter2])) continue;
                    this.minP[iter2] = markerRValues.vector2()[iter2];
                }
                break block14;
            }
            iter = 0;
            int numberOfModelEffects = this.myModel.size();
            for (DoubleMatrix pdata : this.permutedData) {
                double[] y = AssociationUtils.getNonMissingDoubles(pdata.to1DArray(), (BitSet)newMissing);
                SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, y);
                this.markerSSdf = sflm.getIncrementalSSdf(numberOfModelEffects - 1);
                this.errorSSdf = sflm.getResidualSSdf();
                double F = this.markerSSdf[0] / this.markerSSdf[1] / this.errorSSdf[0] * this.errorSSdf[1];
                try {
                    double p = LinearModelUtils.Ftest(F, this.markerSSdf[1], this.errorSSdf[1]);
                    if (this.minP[iter] > p) {
                        this.minP[iter] = p;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++iter;
            }
        }
    }

    @Override
    public void maxP(double maxP) {
        this.maxP = maxP;
    }

    @Override
    public void siteReportFilepath(String savefile) {
        this.saveToFile = true;
        this.siteReportFilename = savefile;
    }

    @Override
    public void alleleReportFilepath(String savefile) {
        this.saveToFile = true;
        this.alleleReportFilename = savefile;
    }

    @Override
    public void biallelicOnly(boolean biallelic) {
        this.biallelicOnly = biallelic;
    }

    @Override
    public void minimumClassSize(int minsize) {
        this.minClassSize = minsize;
    }

    @Override
    public void saveSiteStats(boolean siteStats) {
        this.outputSiteStats = siteStats;
    }

    @Override
    public void siteStatsFile(String filename) {
        this.siteStatsFile = filename;
    }

    @Override
    public void appendAddDom(boolean append) {
        this.appendAddDomEffects = append;
    }

    public void setRandomSeed(int seed) {
        this.randomSeed = seed;
        this.useRandomSeed = true;
    }

    static {
        typeNameMap.put(SiteScore.SITE_SCORE_TYPE.ProbA, "A");
        typeNameMap.put(SiteScore.SITE_SCORE_TYPE.ProbC, "C");
        typeNameMap.put(SiteScore.SITE_SCORE_TYPE.ProbG, "G");
        typeNameMap.put(SiteScore.SITE_SCORE_TYPE.ProbT, "T");
        typeNameMap.put(SiteScore.SITE_SCORE_TYPE.ProbGap, "-");
        typeNameMap.put(SiteScore.SITE_SCORE_TYPE.ProbInsertion, "+");
    }
}

