/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import net.maizegenetics.analysis.association.AbstractFixedEffectLM;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class AlleleProbabilityFELM
extends AbstractFixedEffectLM {
    public AlleleProbabilityFELM(Datum data, FixedEffectLMPlugin parentPlugin) {
        super(data, parentPlugin);
    }

    @Override
    protected void analyzeSite() {
        double p;
        int numberOfAlleles;
        String siteName = this.myGenoPheno.genotypeTable().siteName(this.myCurrentSite);
        SweepFastLinearModel markerModel = null;
        ArrayList<ModelEffect> modelPlusMarkers = new ArrayList<ModelEffect>(this.myBaseModel);
        int ntaxa = this.myGenoPheno.genotypeTable().numberOfTaxa();
        float[] sumOfValues = new float[ntaxa];
        ArrayList<float[]> probList = new ArrayList<float[]>();
        ArrayList<SiteScore.SITE_SCORE_TYPE> typeList = new ArrayList<SiteScore.SITE_SCORE_TYPE>();
        for (SiteScore.SITE_SCORE_TYPE type : AlleleProbability.ALLELE_PROBABILITY_TYPES) {
            float[] values = this.myGenoPheno.alleleProbsOfType(type, this.myCurrentSite);
            if (AssociationUtils.isMonomorphic(values)) continue;
            probList.add(values);
            typeList.add(type);
            for (int t = 0; t < ntaxa; ++t) {
                int n = t;
                sumOfValues[n] = sumOfValues[n] + values[t];
            }
        }
        boolean sumsToOne = true;
        for (int t = 0; t < ntaxa; ++t) {
            if (!((double)sumOfValues[t] < 0.95) && !((double)sumOfValues[t] > 1.05)) continue;
            sumsToOne = false;
            break;
        }
        int numberOfAllelesInModel = numberOfAlleles = probList.size();
        if (sumsToOne) {
            --numberOfAllelesInModel;
        }
        for (int a = 0; a < numberOfAllelesInModel; ++a) {
            double[] covar = AssociationUtils.getNonMissingDoubles((float[])probList.get(a), (BitSet)this.missingObsForSite);
            modelPlusMarkers.add(new CovariateModelEffect(covar));
        }
        if (this.areTaxaReplicated) {
            this.myModel.add(this.taxaEffect());
        }
        markerModel = new SweepFastLinearModel(modelPlusMarkers, this.siteData);
        double[] modelSSdf = markerModel.getModelcfmSSdf();
        this.errorSSdf = this.areTaxaReplicated ? markerModel.getIncrementalSSdf(this.taxaEffectNumber) : markerModel.getResidualSSdf();
        this.markerSSdf = new double[]{0.0, 0.0};
        for (int a = 0; a < numberOfAllelesInModel; ++a) {
            double[] SSdf = markerModel.getIncrementalSSdf(a + this.numberOfBaseEffects);
            this.markerSSdf[0] = this.markerSSdf[0] + SSdf[0];
            this.markerSSdf[1] = this.markerSSdf[1] + SSdf[1];
        }
        double rsq = this.markerSSdf[0] / (modelSSdf[0] + this.errorSSdf[0]);
        double F = this.markerSSdf[0] / this.markerSSdf[1] / this.errorSSdf[0] * this.errorSSdf[1];
        try {
            p = LinearModelUtils.Ftest(F, this.markerSSdf[1], this.errorSSdf[1]);
        }
        catch (Exception e) {
            p = Double.NaN;
        }
        double[] beta = markerModel.getBeta();
        Object[] rowData = new Object[this.numberOfSiteReportColumns];
        int columnCount = 0;
        rowData[columnCount++] = this.currentTraitName;
        rowData[columnCount++] = siteName;
        rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomeName(this.myCurrentSite);
        rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomalPosition(this.myCurrentSite);
        rowData[columnCount++] = new Double(F);
        rowData[columnCount++] = new Double(p);
        rowData[columnCount++] = new Double(rsq);
        rowData[columnCount++] = new Double(this.markerSSdf[1]);
        rowData[columnCount++] = new Double(this.markerSSdf[0] / this.markerSSdf[1]);
        rowData[columnCount++] = new Double(this.errorSSdf[1]);
        rowData[columnCount++] = new Double(this.errorSSdf[0] / this.errorSSdf[1]);
        rowData[columnCount++] = new Double(modelSSdf[1]);
        rowData[columnCount++] = new Double(modelSSdf[0] / modelSSdf[1]);
        this.siteReportBuilder.add(rowData);
        int firstEstimateIndex = beta.length - numberOfAllelesInModel;
        for (int a = 0; a < numberOfAlleles; ++a) {
            rowData = new Object[this.numberOfAlleleReportColumns];
            columnCount = 0;
            rowData[columnCount++] = this.currentTraitName;
            rowData[columnCount++] = siteName;
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomeName(this.myCurrentSite);
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomalPosition(this.myCurrentSite);
            rowData[columnCount++] = typeNameMap.get(typeList.get(a));
            rowData[columnCount++] = a < numberOfAllelesInModel ? new Double(beta[firstEstimateIndex + a]) : new Double(0.0);
            this.alleleReportBuilder.add(rowData);
        }
    }

    @Override
    protected void getGenotypeAndUpdateMissing(BitSet missingObsBeforeSite) {
        float[] allSiteProbs = this.myGenoPheno.alleleProbsOfType(SiteScore.SITE_SCORE_TYPE.ProbA, this.myCurrentSite);
        int n = allSiteProbs.length;
        this.missingObsForSite = new OpenBitSet(missingObsBeforeSite);
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(allSiteProbs[i])) continue;
            this.missingObsForSite.fastSet(i);
        }
    }

    @Override
    protected void getGenotypeAfterUpdatingMissing() {
    }
}

