/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import java.util.Collections;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.taxa.tree.TreeClusters;

public class CompressedDoubleMatrix {
    protected DistanceMatrix kinshipMatrix;
    protected TreeClusters theClusters;
    protected int numberOfGroups;
    protected DoubleMatrix adjustmentMatrix;
    protected DoubleMatrix compressedMatrix;
    protected int[] distance2clusterIndex;
    protected int[][] groupMembers;
    Tree myTree;

    public CompressedDoubleMatrix(DistanceMatrix kinship, Tree theTree) {
        this.kinshipMatrix = kinship;
        this.myTree = theTree;
        this.init();
    }

    protected void init() {
        this.theClusters = new TreeClusters(this.myTree);
        int nrow = this.kinshipMatrix.getSize();
        this.distance2clusterIndex = new int[nrow];
        for (int i = 0; i < nrow; ++i) {
            this.distance2clusterIndex[i] = this.myTree.whichIdNumber(this.kinshipMatrix.getTaxon(i));
        }
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public void setNumberOfGroups(int numberOfGroups) {
        int i;
        int ncol;
        int nrow = this.kinshipMatrix.getSize();
        int[] clusterIndex = this.theClusters.getGroups(numberOfGroups);
        int maxIndex = 0;
        for (int i2 : clusterIndex) {
            maxIndex = Math.max(maxIndex, i2);
        }
        this.numberOfGroups = ncol = maxIndex + 1;
        this.adjustmentMatrix = DoubleMatrixFactory.DEFAULT.make(nrow, ncol, 0.0);
        for (i = 0; i < nrow; ++i) {
            int thiscol = clusterIndex[this.distance2clusterIndex[i]];
            this.adjustmentMatrix.set(i, thiscol, 1.0);
        }
        this.groupMembers = new int[ncol][];
        for (i = 0; i < ncol; ++i) {
            int n = (int)this.adjustmentMatrix.columnSum(i);
            this.groupMembers[i] = new int[n];
            int count = 0;
            for (int r = 0; r < nrow; ++r) {
                if (this.adjustmentMatrix.get(r, i) != 1.0) continue;
                this.groupMembers[i][count++] = r;
            }
        }
    }

    public DoubleMatrix getCompressedMatrix(kinshipMethod km) {
        int ngroups = this.adjustmentMatrix.numberOfColumns();
        this.compressedMatrix = DoubleMatrixFactory.DEFAULT.make(ngroups, ngroups, 0.0);
        for (int g1 = 0; g1 < ngroups; ++g1) {
            for (int g2 = g1; g2 < ngroups; ++g2) {
                ArrayList<Double> kinshipCoefficients = new ArrayList<Double>();
                for (int t1 : this.groupMembers[g1]) {
                    for (int t2 : this.groupMembers[g2]) {
                        kinshipCoefficients.add(Double.valueOf(this.kinshipMatrix.getDistance(t1, t2)));
                    }
                }
                double groupDistance = 0.0;
                switch (km) {
                    case avg: {
                        double n = kinshipCoefficients.size();
                        double total = 0.0;
                        for (Double kc : kinshipCoefficients) {
                            total += kc.doubleValue();
                        }
                        groupDistance = total / n;
                        break;
                    }
                    case min: {
                        groupDistance = (Double)kinshipCoefficients.get(0);
                        for (Double kc : kinshipCoefficients) {
                            groupDistance = Math.min(groupDistance, kc);
                        }
                        break;
                    }
                    case max: {
                        groupDistance = (Double)kinshipCoefficients.get(0);
                        for (Double kc : kinshipCoefficients) {
                            groupDistance = Math.max(groupDistance, kc);
                        }
                        break;
                    }
                    case median: {
                        int midpoint;
                        Collections.sort(kinshipCoefficients);
                        int ncoeff = kinshipCoefficients.size();
                        if (ncoeff % 2 == 0) {
                            midpoint = ncoeff / 2;
                            groupDistance = ((Double)kinshipCoefficients.get(midpoint) + (Double)kinshipCoefficients.get(midpoint - 1)) / 2.0;
                            break;
                        }
                        midpoint = (ncoeff - 1) / 2;
                        groupDistance = (Double)kinshipCoefficients.get(midpoint);
                    }
                }
                this.compressedMatrix.set(g1, g2, groupDistance);
                this.compressedMatrix.set(g2, g1, groupDistance);
            }
        }
        return this.compressedMatrix;
    }

    public DoubleMatrix getAdjustmentMatrix() {
        return this.adjustmentMatrix;
    }

    public DoubleMatrix getCompressedZKZ(DoubleMatrix Z, kinshipMethod km) {
        DoubleMatrix compressedZ = this.getCompressedZ(Z);
        this.getCompressedMatrix(km);
        return compressedZ.mult(this.compressedMatrix).tcrossproduct(compressedZ);
    }

    public DoubleMatrix getCompressedZ(DoubleMatrix originalZ) {
        return originalZ.mult(this.adjustmentMatrix);
    }

    public static enum kinshipMethod {
        avg,
        min,
        max,
        median;

    }
}

