/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.association.AbstractFixedEffectLM;
import net.maizegenetics.analysis.association.AlleleProbabilityFELM;
import net.maizegenetics.analysis.association.DiscreteSitesFELM;
import net.maizegenetics.analysis.association.PhenotypeLM;
import net.maizegenetics.analysis.association.ReferenceProbabilityFELM;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.TableReportUtils;
import org.apache.log4j.Logger;

public class FixedEffectLMPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FixedEffectLMPlugin.class);
    String baseOutFileName = "";
    private GenotypeTable.GENOTYPE_TABLE_COMPONENT[] GENOTYPE_COMP = new GenotypeTable.GENOTYPE_TABLE_COMPONENT[]{GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype, GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability, GenotypeTable.GENOTYPE_TABLE_COMPONENT.AlleleProbability};
    private PluginParameter<Boolean> phenotypeOnly = new PluginParameter.Builder<Boolean>("phenoOnly", false, Boolean.class).description("Should the phenotype be analyzed with no markers and BLUEs generated? (BLUE = best linear unbiased estimate)").guiName("Analyze Phenotype Only").build();
    private PluginParameter<Boolean> saveAsFile = new PluginParameter.Builder<Boolean>("saveToFile", false, Boolean.class).description("Should the results be saved to a file rather than stored in memory? It true, the results will be written to a file as each SNP is analyzed in order to reduce memory requirementsand the results will NOT be saved to the data tree. Default = false.").guiName("Save to file").build();
    private PluginParameter<String> siteReportFilename = new PluginParameter.Builder<String>("siteFile", null, String.class).outFile().dependentOnParameter(this.saveAsFile).description("The name of the file to which these results will be saved.").guiName("Statistics File").build();
    private PluginParameter<String> alleleReportFilename = new PluginParameter.Builder<String>("alleleFile", null, String.class).outFile().dependentOnParameter(this.saveAsFile).description("The name of the file to which these results will be saved.").guiName("Genotype Effect File").build();
    private PluginParameter<String> bluesReportFilename = new PluginParameter.Builder<String>("bluesFile", null, String.class).description("Name of file to which BLUEs values will be saved").outFile().dependentOnParameter(this.phenotypeOnly).guiName("BLUEs File").build();
    private PluginParameter<String> anovaReportFilename = new PluginParameter.Builder<String>("anovaFile", null, String.class).description("Name of file to which ANOVA report will be saved").outFile().dependentOnParameter(this.phenotypeOnly).guiName("ANOVA File").build();
    private PluginParameter<Double> maxPvalue = new PluginParameter.Builder<Double>("maxP", 1.0, Double.class).description("Only results with p <= maxPvalue will be reported. Default = 1.0.").dependentOnParameter(this.phenotypeOnly, false).range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).guiName("max P value").build();
    private PluginParameter<Boolean> permute = new PluginParameter.Builder<Boolean>("permute", false, Boolean.class).description("Should a permutation analysis be run? The permutation analysis controls the experiment-wise error rate for individual phenotypes.").dependentOnParameter(this.phenotypeOnly, false).guiName("Run Permutations").build();
    private PluginParameter<Integer> numberOfPermutations = new PluginParameter.Builder<Integer>("nperm", 0, Integer.class).description("The number of permutations to be run for the permutation analysis.").dependentOnParameter(this.permute).guiName("Number of Permutations").build();
    private PluginParameter<GenotypeTable.GENOTYPE_TABLE_COMPONENT> myGenotypeTable = new PluginParameter.Builder<GenotypeTable.GENOTYPE_TABLE_COMPONENT>("genotypeComponent", GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype, GenotypeTable.GENOTYPE_TABLE_COMPONENT.class).genotypeTable().range((Comparable<T>[])this.GENOTYPE_COMP).description("If the genotype table contains more than one type of genotype data, choose the type to use for the analysis.").build();
    private PluginParameter<Integer> minClassSize = new PluginParameter.Builder<Integer>("minClassSize", 0, Integer.class).description("The minimum acceptable genotype class size. Genotypes in a class with a smaller size will be set to missing.").guiName("Minimum Class Size").build();
    private PluginParameter<Boolean> biallelicOnly = new PluginParameter.Builder<Boolean>("biallelicOnly", false, Boolean.class).description("Only test sites that are bi-allelic. The alternative is to test sites with two or more alleles.").guiName("Bi-Allelic Sites Only").build();
    private PluginParameter<Boolean> siteStatsOutput = new PluginParameter.Builder<Boolean>("siteStatsOut", false, Boolean.class).description("Generate an output dataset with only p-val, F statistic, and number of obs per site for all sites.").guiName("Output Site Stats").build();
    private PluginParameter<String> siteStatFilename = new PluginParameter.Builder<String>("siteStatFile", null, String.class).description("").guiName("").dependentOnParameter(this.siteStatsOutput).outFile().build();
    private PluginParameter<Boolean> appendAddDom = new PluginParameter.Builder<Boolean>("appendAddDom", false, Boolean.class).description("If true, additive and dominance effect estimates will be added to the stats report for bi-allelic sites only. The effect will only be estimated when the data source is genotype (not a probability). The additive effect will always be non-negative.").guiName("Append Effect Estimates to Stats").build();

    public FixedEffectLMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public String getButtonName() {
        return "GLM";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FixedEffectLMPlugin.class.getResource("/net/maizegenetics/analysis/images/LinearAssociation.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getToolTipText() {
        return "Use fixed effect model to test associations";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void preProcessParameters(DataSet data) {
        List<Datum> genoPhenoList = data.getDataOfType(GenotypePhenotype.class);
        if (genoPhenoList.size() == 0) {
            List<Datum> phenoList = data.getDataOfType(Phenotype.class);
            if (phenoList.size() == 0) {
                throw new IllegalArgumentException("A dataset that can be analyzed by GLM has not been selected.");
            }
            if (phenoList.size() != 1) throw new IllegalArgumentException("GLM can only process one data set at a time.");
            this.phenotypeOnly = new PluginParameter.Builder<Boolean>("phenoOnly", true, Boolean.class).description("Should the phenotype be analyzed with no markers and BLUEs generated? (BLUE = best linear unbiased estimate)").guiName("Analyze Phenotype Only").build();
            return;
        } else {
            if (genoPhenoList.size() <= 1) return;
            throw new IllegalArgumentException("GLM can only process one data set at a time.");
        }
    }

    @Override
    public DataSet processData(DataSet data) {
        AbstractFixedEffectLM myLM;
        if (this.phenotypeOnly.value().booleanValue()) {
            List<Datum> datumList = data.getDataOfType(Phenotype.class);
            if (datumList.size() == 1) {
                Datum myDatum = datumList.get(0);
                PhenotypeLM plm = new PhenotypeLM(myDatum);
                if (this.saveAsFile().booleanValue()) {
                    TableReportUtils.saveDelimitedTableReport(plm.myBlues, new File(this.bluesReportFilename()));
                    TableReportUtils.saveDelimitedTableReport(plm.report(), new File(this.anovaReportFilename()));
                    return null;
                }
                return new DataSet(plm.datumList(), (Plugin)this);
            }
            if (datumList.size() == 0) {
                throw new IllegalArgumentException("The phenotype only option was selected, but no phenotype data set was provided as input.");
            }
            throw new IllegalArgumentException("Multiple phenotype data sets were provided. Only one is allowed.");
        }
        Datum myDatum = data.getDataOfType(GenotypePhenotype.class).get(0);
        if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype) {
            myLM = new DiscreteSitesFELM(myDatum, this);
        } else if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability) {
            myLM = new ReferenceProbabilityFELM(myDatum, this);
        } else if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.AlleleProbability) {
            myLM = new AlleleProbabilityFELM(myDatum, this);
        } else {
            return null;
        }
        if (this.permute.value().booleanValue()) {
            myLM.permutationTest(true, this.numberOfPermutations.value());
        }
        if (this.saveAsFile.value().booleanValue()) {
            myLM.siteReportFilepath(this.siteReportFilename.value());
            myLM.alleleReportFilepath(this.alleleReportFilename.value());
        }
        myLM.maxP(this.maxPvalue.value());
        myLM.biallelicOnly(this.biallelicOnly.value());
        myLM.minimumClassSize(this.minClassSize.value());
        myLM.appendAddDom(this.appendAddDom.value());
        myLM.solve();
        if (this.saveAsFile.value().booleanValue()) {
            return null;
        }
        return new DataSet(myLM.datumList(), (Plugin)this);
    }

    public void updateProgress(int percent) {
        this.fireProgress(percent);
    }

    public void setOutputFile(String name) {
        this.baseOutFileName = name;
    }

    public void setMaxP(double maxp) {
        this.maxPvalue(maxp);
    }

    public void setPermute(boolean permute) {
        this.permute(permute);
    }

    public void setNumberOfPermutations(int nperm) {
        this.numberOfPermutations(nperm);
    }

    public Boolean phenotypeOnly() {
        return this.phenotypeOnly.value();
    }

    public FixedEffectLMPlugin phenotypeOnly(Boolean value) {
        this.phenotypeOnly = new PluginParameter<Boolean>(this.phenotypeOnly, value);
        return this;
    }

    public Boolean saveAsFile() {
        return this.saveAsFile.value();
    }

    public FixedEffectLMPlugin saveAsFile(Boolean value) {
        this.saveAsFile = new PluginParameter<Boolean>(this.saveAsFile, value);
        return this;
    }

    public String siteReportFilename() {
        return this.siteReportFilename.value();
    }

    public FixedEffectLMPlugin siteReportFilename(String value) {
        this.siteReportFilename = new PluginParameter<String>(this.siteReportFilename, value);
        return this;
    }

    public String alleleReportFilename() {
        return this.alleleReportFilename.value();
    }

    public FixedEffectLMPlugin alleleReportFilename(String value) {
        this.alleleReportFilename = new PluginParameter<String>(this.alleleReportFilename, value);
        return this;
    }

    public Double maxPvalue() {
        return this.maxPvalue.value();
    }

    public FixedEffectLMPlugin maxPvalue(Double value) {
        this.maxPvalue = new PluginParameter<Double>(this.maxPvalue, value);
        return this;
    }

    public Boolean permute() {
        return this.permute.value();
    }

    public FixedEffectLMPlugin permute(Boolean value) {
        this.permute = new PluginParameter<Boolean>(this.permute, value);
        return this;
    }

    public Integer numberOfPermutations() {
        return this.numberOfPermutations.value();
    }

    public FixedEffectLMPlugin numberOfPermutations(Integer value) {
        this.numberOfPermutations = new PluginParameter<Integer>(this.numberOfPermutations, value);
        return this;
    }

    public GenotypeTable.GENOTYPE_TABLE_COMPONENT genotypeTable() {
        return this.myGenotypeTable.value();
    }

    public FixedEffectLMPlugin genotypeTable(GenotypeTable.GENOTYPE_TABLE_COMPONENT value) {
        this.myGenotypeTable = new PluginParameter<GenotypeTable.GENOTYPE_TABLE_COMPONENT>(this.myGenotypeTable, value);
        return this;
    }

    public Integer minClassSize() {
        return this.minClassSize.value();
    }

    public FixedEffectLMPlugin minClassSize(Integer value) {
        this.minClassSize = new PluginParameter<Integer>(this.minClassSize, value);
        return this;
    }

    public Boolean biallelicOnly() {
        return this.biallelicOnly.value();
    }

    public FixedEffectLMPlugin biallelicOnly(Boolean value) {
        this.biallelicOnly = new PluginParameter<Boolean>(this.biallelicOnly, value);
        return this;
    }

    public Boolean siteStatsOutput() {
        return this.siteStatsOutput.value();
    }

    public FixedEffectLMPlugin siteStatsOutput(Boolean value) {
        this.siteStatsOutput = new PluginParameter<Boolean>(this.siteStatsOutput, value);
        return this;
    }

    public String siteStatFilename() {
        return this.siteStatFilename.value();
    }

    public FixedEffectLMPlugin siteStatFilename(String value) {
        this.siteStatFilename = new PluginParameter<String>(this.siteStatFilename, value);
        return this;
    }

    public Boolean appendAddDom() {
        return this.appendAddDom.value();
    }

    public FixedEffectLMPlugin appendAddDom(Boolean value) {
        this.appendAddDom = new PluginParameter<Boolean>(this.appendAddDom, value);
        return this;
    }

    public String bluesReportFilename() {
        return this.bluesReportFilename.value();
    }

    public FixedEffectLMPlugin bluesReportFilename(String value) {
        this.bluesReportFilename = new PluginParameter<String>(this.bluesReportFilename, value);
        return this;
    }

    public String anovaReportFilename() {
        return this.anovaReportFilename.value();
    }

    public FixedEffectLMPlugin anovaReportFilename(String value) {
        this.anovaReportFilename = new PluginParameter<String>(this.anovaReportFilename, value);
        return this;
    }

    static enum GENOTYPE_DATA_TYPE {
        genotype,
        probability,
        allele_probabilities,
        none;

    }
}

