/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.association.CompressedMLMusingDoubleMatrix;
import net.maizegenetics.analysis.association.MLMOptionDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.ReportDestinationDialog;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import org.apache.log4j.Logger;

public class MLMPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MLMPlugin.class);
    protected DistanceMatrix kinshipMatrix;
    protected boolean analyzeByColumn;
    protected boolean useP3D = true;
    protected CompressionType compressionType = CompressionType.None;
    protected double compression = 1.0;
    private boolean writeOutputToFile = false;
    private String outputName = null;
    private boolean filterOutput = false;
    private double maxp = 1.0;
    private boolean useGenotype = true;
    private boolean useRefProb = false;
    private boolean useAlleleProb = false;

    public boolean isUseP3D() {
        return this.useP3D;
    }

    public void setUseP3D(boolean useP3D) {
        this.useP3D = useP3D;
    }

    public boolean isUseGenotype() {
        return this.useGenotype;
    }

    public void setUseGenotype(boolean useGenotype) {
        this.useGenotype = useGenotype;
    }

    public boolean isUseRefProb() {
        return this.useRefProb;
    }

    public void setUseRefProb(boolean useRefProb) {
        this.useRefProb = useRefProb;
    }

    public MLMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        boolean hasGenotypePhenotype = true;
        try {
            DataSet dataSet;
            List<Datum> alignInList = input.getDataOfType(GenotypePhenotype.class);
            if (alignInList.size() == 0) {
                hasGenotypePhenotype = false;
                alignInList = input.getDataOfType(Phenotype.class);
            }
            List<Datum> kinshipList = input.getDataOfType(DistanceMatrix.class);
            if (alignInList.size() != 1) {
                String message = "Invalid selection. Please select one dataset with marker and trait data.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet2 = null;
                return dataSet2;
            }
            if (kinshipList.size() != 1) {
                String message = "Please select exactly one kinship matrix.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet3 = null;
                return dataSet3;
            }
            this.kinshipMatrix = (DistanceMatrix)kinshipList.get(0).getData();
            Iterator<Datum> itr = alignInList.iterator();
            if (this.isInteractive()) {
                ReportDestinationDialog rdd;
                MLMOptionDialog theOptions;
                if (hasGenotypePhenotype) {
                    GenotypePhenotype gp = (GenotypePhenotype)alignInList.get(0).getData();
                    theOptions = new MLMOptionDialog(this.getParentFrame(), this.hasDataTypes(gp));
                } else {
                    theOptions = new MLMOptionDialog(this.getParentFrame(), new boolean[]{false, false, false});
                }
                if (theOptions.runClicked) {
                    this.useP3D = theOptions.useP3D();
                    this.compressionType = theOptions.getCompressionType();
                    this.compression = theOptions.getCompressionLevel();
                    theOptions.dispose();
                    rdd = new ReportDestinationDialog();
                    rdd.setLocationRelativeTo(this.getParentFrame());
                    rdd.setVisible(true);
                    if (!rdd.isOkayChecked()) {
                        DataSet dataSet4 = null;
                        return dataSet4;
                    }
                    this.writeOutputToFile = rdd.wasUseFileChecked();
                    if (this.writeOutputToFile) {
                        this.outputName = rdd.getOutputFileName();
                    }
                    this.filterOutput = rdd.wasRestrictOutputChecked();
                    if (this.filterOutput) {
                        this.maxp = rdd.getMaxP();
                    }
                } else {
                    theOptions.dispose();
                    rdd = null;
                    return rdd;
                }
            }
            ArrayList<Datum> myResults = new ArrayList<Datum>();
            while (itr.hasNext()) {
                CompressedMLMusingDoubleMatrix theAnalysis;
                Datum current = itr.next();
                if (hasGenotypePhenotype) {
                    GenotypeTable myGenotype = ((GenotypePhenotype)current.getData()).genotypeTable();
                    this.useGenotype = myGenotype.hasGenotype();
                    if (!this.useGenotype) {
                        this.useRefProb = myGenotype.hasReferenceProbablity();
                    }
                } else {
                    this.useGenotype = false;
                    this.useRefProb = false;
                }
                if (this.useP3D) {
                    theAnalysis = this.compressionType.equals((Object)CompressionType.Optimum) ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, true, Double.NaN) : (this.compressionType.equals((Object)CompressionType.Custom) ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, true, this.compression) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, false, true, Double.NaN));
                    theAnalysis.useGenotypeCalls(this.useGenotype);
                    theAnalysis.useReferenceProbability(this.useRefProb);
                    theAnalysis.useAlleleProbabilities(this.useAlleleProb);
                } else {
                    theAnalysis = this.compressionType.equals((Object)CompressionType.Optimum) ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, false, Double.NaN) : (this.compressionType.equals((Object)CompressionType.Custom) ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, false, this.compression) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, false, false, Double.NaN));
                    theAnalysis.useGenotypeCalls(this.useGenotype);
                    theAnalysis.useReferenceProbability(this.useRefProb);
                    theAnalysis.useAlleleProbabilities(this.useAlleleProb);
                }
                myResults.addAll(theAnalysis.solve());
            }
            if (myResults.size() > 0 && !this.writeOutputToFile) {
                this.fireDataSetReturned(new DataSet(myResults, (Plugin)this));
                dataSet = new DataSet(myResults, (Plugin)this);
                return dataSet;
            }
            dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private boolean[] hasDataTypes(GenotypePhenotype gp) {
        boolean[] hasTypes = new boolean[]{false, false, false};
        if (gp.genotypeTable().hasGenotype()) {
            hasTypes[0] = true;
        }
        if (gp.genotypeTable().hasReference()) {
            hasTypes[1] = true;
        }
        if (gp.genotypeTable().hasAlleleProbabilities()) {
            hasTypes[2] = true;
        }
        return hasTypes;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MLMPlugin.class.getResource("/net/maizegenetics/analysis/images/Mix.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "MLM";
    }

    @Override
    public String getToolTipText() {
        return "Association analysis using mixed model";
    }

    public void setAnalyzeByColumn(boolean analyzeByColumn) {
        this.analyzeByColumn = analyzeByColumn;
    }

    public void setMaximumNumOfIteration(int max) {
    }

    public void setFinalIterMarker(boolean myFinalIterMarker) {
    }

    public void addFactors(int[] factors) {
    }

    public void setColumnTypes(String[] types) {
    }

    public void addFactors(String[] names) {
    }

    public void updateProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        } else if (progress > 100) {
            progress = 100;
        }
        this.fireProgress(progress);
    }

    public void setVarCompEst(String value) {
        if (value.equalsIgnoreCase("P3D")) {
            this.useP3D = true;
        } else if (value.equalsIgnoreCase("EachMarker")) {
            this.useP3D = false;
        } else {
            throw new IllegalArgumentException("MLMPlugin: setVarCompEst: don't know how to handle value: " + value);
        }
    }

    public void setCompressionType(CompressionType type) {
        this.compressionType = type;
    }

    public boolean isWriteOutputToFile() {
        return this.writeOutputToFile;
    }

    public void setWriteOutputToFile(boolean writeOutputToFile) {
        this.writeOutputToFile = writeOutputToFile;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
        this.writeOutputToFile = true;
    }

    public boolean isFilterOutput() {
        return this.filterOutput;
    }

    public void setFilterOutput(boolean filterOutput) {
        this.filterOutput = filterOutput;
    }

    public double getMaxp() {
        return this.maxp;
    }

    public void setMaxp(double maxp) {
        this.maxp = maxp;
        this.filterOutput = true;
    }

    public double getCustomCompression() {
        return this.compression;
    }

    public void setCustomCompression(double value) {
        this.compression = value;
    }

    public void useGenotypeCalls() {
        this.useGenotype = true;
        this.useRefProb = false;
        this.useAlleleProb = false;
    }

    public void useReferenceProbability() {
        this.useGenotype = false;
        this.useRefProb = true;
        this.useAlleleProb = false;
    }

    public void useAlleleProbabilities() {
        this.useGenotype = false;
        this.useRefProb = false;
        this.useAlleleProb = true;
    }

    public static enum CompressionType {
        Optimum,
        Custom,
        None;

    }
}

