/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;

public class PhenotypeLM {
    protected Datum myDatum;
    protected Phenotype myPhenotype;
    protected Phenotype myBlues;
    protected TableReportBuilder reportBuilder;
    private TableReport report;
    boolean areTaxaReplicated;
    protected TaxaList myTaxaList;
    protected int numberOfObservations;
    protected List<PhenotypeAttribute> myDataAttributes;
    protected List<PhenotypeAttribute> myFactorAttributes;
    protected List<PhenotypeAttribute> myCovariateAttributes;
    protected Taxon[] myTaxa;
    protected ArrayList<Taxon> taxaInModel;
    protected Map<Taxon, Integer> taxaInModelMap;

    public PhenotypeLM(Datum phenotypeOnly) {
        this.myDatum = phenotypeOnly;
        Object data = this.myDatum.getData();
        if (data instanceof Phenotype) {
            this.myPhenotype = (Phenotype)data;
        } else if (data instanceof GenotypePhenotype) {
            this.myPhenotype = ((GenotypePhenotype)data).phenotype();
        } else {
            return;
        }
        this.initialize();
        this.solve();
    }

    public Phenotype blues() {
        return this.myBlues;
    }

    public TableReport report() {
        if (this.report == null) {
            this.report = this.reportBuilder.build();
        }
        return this.report;
    }

    public List<Datum> datumList() {
        ArrayList<Datum> returnDatum = new ArrayList<Datum>();
        String bluesName = "BLUEs_" + this.myDatum.getName();
        StringBuilder sb = new StringBuilder("Best Linear Unbiased Estimates\n");
        sb.append("From ").append(this.myDatum.getName());
        sb.append("\nNumber of Taxa = ").append(this.myTaxaList.size());
        sb.append("\nNumber of Traits = ").append(this.myBlues.numberOfAttributes() - 1);
        String bluesComment = sb.toString();
        String reportName = "Phenotype_ANOVA_" + this.myDatum.getName();
        sb = new StringBuilder("Taxa Statistical Tests");
        sb.append("From ").append(this.myDatum.getName());
        String reportComment = sb.toString();
        returnDatum.add(new Datum(bluesName, this.myBlues, bluesComment));
        returnDatum.add(new Datum(reportName, this.report(), reportComment));
        return returnDatum;
    }

    protected void initialize() {
        this.myTaxaList = this.myPhenotype.taxa();
        this.myTaxa = this.myPhenotype.taxaAttribute().allTaxa();
        Object[] columns = new String[]{"Trait", "F", "p", "taxaDF", "taxaMS", "errorDF", "errorMS", "modelDF", "modelMS"};
        String name = "Phenotype analysis for " + this.myDatum.getName();
        this.reportBuilder = TableReportBuilder.getInstance(name, columns);
        this.numberOfObservations = this.myPhenotype.numberOfObservations();
        this.myDataAttributes = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        this.myFactorAttributes = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        this.myCovariateAttributes = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
    }

    protected void solve() {
        OpenBitSet missingModelObs = new OpenBitSet(this.numberOfObservations);
        for (PhenotypeAttribute attr : this.myFactorAttributes) {
            missingModelObs.or(attr.missing());
        }
        for (PhenotypeAttribute attr : this.myCovariateAttributes) {
            missingModelObs.or(attr.missing());
        }
        ArrayList<PhenotypeAttribute> blueAttributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> blueAttributeTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        blueAttributes.add(new TaxaAttribute(this.myTaxaList, this.myPhenotype.taxaAttribute().name()));
        blueAttributeTypes.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (PhenotypeAttribute dataAttribute : this.myDataAttributes) {
            double p;
            String currentTraitName = dataAttribute.name();
            OpenBitSet missingObs = new OpenBitSet(dataAttribute.missing());
            for (PhenotypeAttribute attr : this.myFactorAttributes) {
                missingObs.or(attr.missing());
            }
            for (PhenotypeAttribute attr : this.myCovariateAttributes) {
                missingObs.or(attr.missing());
            }
            float[] allData = (float[])dataAttribute.allValues();
            double[] y = AssociationUtils.getNonMissingDoubles(allData, (BitSet)missingObs);
            ArrayList<ModelEffect> myModel = this.model(missingObs, y.length);
            SweepFastLinearModel sflm = new SweepFastLinearModel(myModel, y);
            double[] beta = sflm.getBeta();
            double overallMean = beta[0];
            int nEffects = myModel.size();
            int start = 1;
            for (int i = 1; i < nEffects - 1; ++i) {
                ModelEffect me = myModel.get(i);
                if (me instanceof FactorModelEffect) {
                    FactorModelEffect fme = (FactorModelEffect)me;
                    int nLevels = fme.getNumberOfLevels();
                    int nEstimates = fme.getRestricted() ? nLevels - 1 : nLevels;
                    double factorMean = 0.0;
                    for (int j = 0; j < nEstimates; ++j) {
                        factorMean += beta[j + start];
                    }
                    overallMean += (factorMean /= (double)nLevels);
                    start += nEstimates;
                    continue;
                }
                start += me.getNumberOfLevels();
            }
            float[] attrValues = new float[this.myTaxaList.size()];
            OpenBitSet missing = new OpenBitSet(this.myTaxaList.size());
            int lastTaxon = this.taxaInModel.size() - 1;
            for (int t = 0; t < this.myTaxaList.size(); ++t) {
                Integer ndx = this.taxaInModelMap.get(this.myTaxaList.get(t));
                if (ndx == null) {
                    attrValues[t] = Float.NaN;
                    missing.fastSet(t);
                    continue;
                }
                attrValues[t] = ndx == lastTaxon ? (float)overallMean : (float)(beta[ndx + start] + overallMean);
            }
            blueAttributes.add(new NumericAttribute(dataAttribute.name(), attrValues, missing));
            blueAttributeTypes.add(Phenotype.ATTRIBUTE_TYPE.data);
            double[] taxaSSdf = sflm.getIncrementalSSdf(nEffects - 1);
            double[] modelSSdf = sflm.getModelcfmSSdf();
            double[] errorSSdf = sflm.getResidualSSdf();
            double F = taxaSSdf[0] / taxaSSdf[1] / errorSSdf[0] * errorSSdf[1];
            try {
                p = LinearModelUtils.Ftest(F, taxaSSdf[1], errorSSdf[1]);
            }
            catch (Exception e) {
                p = Double.NaN;
            }
            Object[] result = new Object[]{currentTraitName, new Double(F), new Double(p), new Double(taxaSSdf[1]), new Double(taxaSSdf[0] / taxaSSdf[1]), new Double(errorSSdf[1]), new Double(errorSSdf[0] / errorSSdf[1]), new Double(modelSSdf[1]), new Double(modelSSdf[0] / modelSSdf[1])};
            this.reportBuilder.add(result);
        }
        this.myBlues = new PhenotypeBuilder().fromAttributeList(blueAttributes, blueAttributeTypes).build().get(0);
    }

    protected void testTaxaReplication() {
        this.areTaxaReplicated = this.myTaxaList.numberOfTaxa() < this.myPhenotype.numberOfObservations();
    }

    protected ArrayList<ModelEffect> model(BitSet missingObs, int numberOfNonmissingObs) {
        ArrayList<ModelEffect> modelEffects = new ArrayList<ModelEffect>();
        FactorModelEffect meanEffect = new FactorModelEffect(new int[numberOfNonmissingObs], false, "mean");
        modelEffects.add(meanEffect);
        for (PhenotypeAttribute attr : this.myFactorAttributes) {
            Object[] factorLabels = AssociationUtils.getNonMissingValues((String[])attr.allValues(), missingObs);
            FactorModelEffect fme = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(factorLabels), true, attr.name());
            modelEffects.add(fme);
        }
        for (PhenotypeAttribute attr : this.myCovariateAttributes) {
            NumericAttribute numericAttr = (NumericAttribute)attr;
            double[] values = AssociationUtils.getNonMissingDoubles(numericAttr.floatValues(), missingObs);
            CovariateModelEffect cme = new CovariateModelEffect(values, attr.name());
            modelEffects.add(cme);
        }
        Taxon[] taxa = AssociationUtils.getNonMissingValues(this.myTaxa, missingObs);
        this.taxaInModel = new ArrayList();
        int[] taxaLevels = ModelEffectUtils.getIntegerLevels(taxa, this.taxaInModel);
        FactorModelEffect taxaEffect = new FactorModelEffect(taxaLevels, true);
        modelEffects.add(taxaEffect);
        this.taxaInModelMap = new HashMap<Taxon, Integer>();
        int count = 0;
        for (Taxon taxon : this.taxaInModel) {
            this.taxaInModelMap.put(taxon, count++);
        }
        return modelEffects;
    }
}

