/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import net.maizegenetics.analysis.association.AbstractFixedEffectLM;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class ReferenceProbabilityFELM
extends AbstractFixedEffectLM {
    double[] myProbabilities;

    public ReferenceProbabilityFELM(Datum data, FixedEffectLMPlugin parentPlugin) {
        super(data, parentPlugin);
    }

    @Override
    protected void analyzeSite() {
        double p;
        this.myModel = new ArrayList(this.myBaseModel);
        String siteName = this.myGenoPheno.genotypeTable().siteName(this.myCurrentSite);
        this.myModel.add(new CovariateModelEffect(this.myProbabilities));
        if (this.areTaxaReplicated) {
            this.myModel.add(this.taxaEffect());
        }
        SweepFastLinearModel markerModel = new SweepFastLinearModel(this.myModel, this.siteData);
        double[] modelSSdf = markerModel.getModelcfmSSdf();
        this.markerSSdf = markerModel.getIncrementalSSdf(this.numberOfBaseEffects);
        this.errorSSdf = this.areTaxaReplicated ? markerModel.getIncrementalSSdf(this.numberOfBaseEffects + 1) : markerModel.getResidualSSdf();
        double rsq = this.markerSSdf[0] / (modelSSdf[0] + markerModel.getResidualSSdf()[0]);
        double F = this.markerSSdf[0] / this.markerSSdf[1] / this.errorSSdf[0] * this.errorSSdf[1];
        try {
            p = LinearModelUtils.Ftest(F, this.markerSSdf[1], this.errorSSdf[1]);
        }
        catch (Exception e) {
            p = Double.NaN;
        }
        double[] beta = markerModel.getBeta();
        if (this.permute) {
            this.G = markerModel.getInverseOfXtX();
        }
        if (this.maxP == 1.0 || p <= this.maxP) {
            Object[] rowData = new Object[this.numberOfSiteReportColumns];
            int columnCount = 0;
            rowData[columnCount++] = this.currentTraitName;
            rowData[columnCount++] = siteName;
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomeName(this.myCurrentSite);
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomalPosition(this.myCurrentSite);
            rowData[columnCount++] = new Double(F);
            rowData[columnCount++] = new Double(p);
            if (this.permute) {
                rowData[columnCount++] = "";
            }
            rowData[columnCount++] = new Double(rsq);
            rowData[columnCount++] = new Double(this.markerSSdf[1]);
            rowData[columnCount++] = new Double(this.markerSSdf[0] / this.markerSSdf[1]);
            rowData[columnCount++] = new Double(this.errorSSdf[1]);
            rowData[columnCount++] = new Double(this.errorSSdf[0] / this.errorSSdf[1]);
            rowData[columnCount++] = new Double(modelSSdf[1]);
            rowData[columnCount++] = new Double(modelSSdf[0] / modelSSdf[1]);
            this.siteReportBuilder.add(rowData);
            if (this.permute) {
                this.siteTableReportRows.add(rowData);
            }
            int estimateIndex = beta.length - 1;
            rowData = new Object[this.numberOfAlleleReportColumns];
            columnCount = 0;
            rowData[columnCount++] = this.currentTraitName;
            rowData[columnCount++] = siteName;
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomeName(this.myCurrentSite);
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomalPosition(this.myCurrentSite);
            rowData[columnCount++] = beta[estimateIndex];
            this.alleleReportBuilder.add(rowData);
        }
    }

    @Override
    protected void getGenotypeAndUpdateMissing(BitSet missingObsBeforeSite) {
        float[] allSiteProbs = this.myGenoPheno.referenceProb(this.myCurrentSite);
        int n = allSiteProbs.length;
        this.missingObsForSite = new OpenBitSet(missingObsBeforeSite);
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(allSiteProbs[i])) continue;
            this.missingObsForSite.fastSet(i);
        }
        this.myProbabilities = AssociationUtils.getNonMissingDoubles(allSiteProbs, (BitSet)this.missingObsForSite);
    }

    @Override
    protected void getGenotypeAfterUpdatingMissing() {
        this.myProbabilities = AssociationUtils.getNonMissingDoubles(this.myGenoPheno.referenceProb(this.myCurrentSite), (BitSet)this.missingObsForSite);
    }

    @Override
    protected String[] siteReportColumnNames() {
        this.markerpvalueColumn = 5;
        this.permpvalueColumn = 6;
        if (this.permute) {
            return new String[]{"Trait", "Marker", "Chr", "Pos", "marker_F", "p", "perm_p", "marker_Rsq", "marker_df", "marker_MS", "error_df", "error_MS", "model_df", "model_MS"};
        }
        return new String[]{"Trait", "Marker", "Chr", "Pos", "marker_F", "p", "marker_Rsq", "marker_df", "marker_MS", "error_df", "error_MS", "model_df", "model_MS"};
    }

    @Override
    protected String[] alleleReportColumnNames() {
        return new String[]{"Trait", "Marker", "Chr", "Pos", "Estimate"};
    }
}

