/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.association.CompressedMLMusingDoubleMatrix;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.association.WeightedMLMOptionDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.ReportDestinationDialog;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import org.apache.log4j.Logger;

public class WeightedMLMPlugin
extends MLMPlugin {
    private static final Logger myLogger = Logger.getLogger(WeightedMLMPlugin.class);
    protected DistanceMatrix kinshipMatrix;
    protected boolean analyzeByColumn;
    protected boolean useP3D = true;
    protected CompressionType compressionType = CompressionType.None;
    protected double compression = 1.0;
    protected List<Datum> weightList;
    private boolean writeOutputToFile = false;
    private String outputName = null;
    private boolean filterOutput = false;
    private double maxp = 1.0;
    private boolean useGenotype = true;
    private boolean useRefProb = false;
    private boolean useAlleleProb = false;

    @Override
    public boolean isUseP3D() {
        return this.useP3D;
    }

    @Override
    public void setUseP3D(boolean useP3D) {
        this.useP3D = useP3D;
    }

    @Override
    public boolean isUseGenotype() {
        return this.useGenotype;
    }

    @Override
    public void setUseGenotype(boolean useGenotype) {
        this.useGenotype = useGenotype;
    }

    @Override
    public boolean isUseRefProb() {
        return this.useRefProb;
    }

    @Override
    public void setUseRefProb(boolean useRefProb) {
        this.useRefProb = useRefProb;
    }

    public WeightedMLMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        try {
            DataSet dataSet;
            List<Datum> alignInList = input.getDataOfType(GenotypePhenotype.class);
            if (alignInList.size() == 0) {
                String message = "Invalid selection. Please select a GenotypePhenotype file";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet2 = null;
                return dataSet2;
            }
            this.weightList = input.getDataOfType(Phenotype.class);
            List<Datum> kinshipList = input.getDataOfType(DistanceMatrix.class);
            if (alignInList.size() != 1) {
                String message = "Invalid selection. Please select one dataset with marker and trait data.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet3 = null;
                return dataSet3;
            }
            if (kinshipList.size() != 1) {
                String message = "Please select exactly one kinship matrix.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet4 = null;
                return dataSet4;
            }
            if (this.weightList.size() != 1 && this.weightList.size() != 0) {
                String message = "Please select exactly one weight matrix.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet5 = null;
                return dataSet5;
            }
            if (this.weightList.size() != 0 && !this.isUseP3D()) {
                String message = "If You are using a Weight Matrix, you must use P3D.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)("performFunction: " + message));
                }
                DataSet dataSet6 = null;
                return dataSet6;
            }
            this.kinshipMatrix = (DistanceMatrix)kinshipList.get(0).getData();
            Iterator<Datum> itr = alignInList.iterator();
            if (this.isInteractive()) {
                GenotypePhenotype gp = (GenotypePhenotype)alignInList.get(0).getData();
                WeightedMLMOptionDialog theOptions = new WeightedMLMOptionDialog(this.getParentFrame(), this.hasDataTypes(gp), this.weightList.size());
                if (theOptions.runClicked) {
                    this.useP3D = theOptions.useP3D();
                    this.compressionType = theOptions.getCompressionType();
                    this.compression = theOptions.getCompressionLevel();
                    theOptions.dispose();
                    ReportDestinationDialog rdd = new ReportDestinationDialog();
                    rdd.setLocationRelativeTo(this.getParentFrame());
                    rdd.setVisible(true);
                    if (!rdd.isOkayChecked()) {
                        DataSet dataSet7 = null;
                        return dataSet7;
                    }
                    this.writeOutputToFile = rdd.wasUseFileChecked();
                    if (this.writeOutputToFile) {
                        this.outputName = rdd.getOutputFileName();
                    }
                    this.filterOutput = rdd.wasRestrictOutputChecked();
                    if (this.filterOutput) {
                        this.maxp = rdd.getMaxP();
                    }
                } else {
                    theOptions.dispose();
                    DataSet rdd = null;
                    return rdd;
                }
            }
            ArrayList<Datum> myResults = new ArrayList<Datum>();
            while (itr.hasNext()) {
                CompressedMLMusingDoubleMatrix theAnalysis;
                Datum current = itr.next();
                GenotypeTable myGenotype = ((GenotypePhenotype)current.getData()).genotypeTable();
                this.useGenotype = myGenotype.hasGenotype();
                if (!this.useGenotype) {
                    this.useRefProb = myGenotype.hasReferenceProbablity();
                }
                if (this.useP3D) {
                    theAnalysis = this.compressionType.equals((Object)CompressionType.Optimum) ? (this.weightList.size() == 0 ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, true, Double.NaN) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, this.weightList.get(0), true, true, Double.NaN)) : (this.compressionType.equals((Object)CompressionType.Custom) ? (this.weightList.size() == 0 ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, true, this.compression) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, this.weightList.get(0), true, true, this.compression)) : (this.weightList.size() == 0 ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, false, true, Double.NaN) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, this.weightList.get(0), false, true, Double.NaN)));
                    theAnalysis.useGenotypeCalls(this.useGenotype);
                    theAnalysis.useReferenceProbability(this.useRefProb);
                    theAnalysis.useAlleleProbabilities(this.useAlleleProb);
                } else {
                    theAnalysis = this.compressionType.equals((Object)CompressionType.Optimum) ? (this.weightList.size() == 0 ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, false, Double.NaN) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, this.weightList.get(0), true, false, Double.NaN)) : (this.compressionType.equals((Object)CompressionType.Custom) ? (this.weightList.size() == 0 ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, true, false, this.compression) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, this.weightList.get(0), true, false, this.compression)) : (this.weightList.size() == 0 ? new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, false, false, Double.NaN) : new CompressedMLMusingDoubleMatrix(this, current, this.kinshipMatrix, this.weightList.get(0), false, false, Double.NaN)));
                    theAnalysis.useGenotypeCalls(this.useGenotype);
                    theAnalysis.useReferenceProbability(this.useRefProb);
                    theAnalysis.useAlleleProbabilities(this.useAlleleProb);
                }
                myResults.addAll(theAnalysis.solve());
            }
            if (myResults.size() > 0) {
                dataSet = new DataSet(myResults, (Plugin)this);
                return dataSet;
            }
            dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private boolean[] hasDataTypes(GenotypePhenotype gp) {
        boolean[] hasTypes = new boolean[]{false, false, false};
        if (gp.genotypeTable().hasGenotype()) {
            hasTypes[0] = true;
        }
        if (gp.genotypeTable().hasReference()) {
            hasTypes[1] = true;
        }
        if (gp.genotypeTable().hasAlleleProbabilities()) {
            hasTypes[2] = true;
        }
        return hasTypes;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = WeightedMLMPlugin.class.getResource("/net/maizegenetics/analysis/images/Mix.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "WeightedMLM";
    }

    @Override
    public String getToolTipText() {
        return "Association analysis using mixed model";
    }

    @Override
    public void setAnalyzeByColumn(boolean analyzeByColumn) {
        this.analyzeByColumn = analyzeByColumn;
    }

    @Override
    public void setMaximumNumOfIteration(int max) {
    }

    @Override
    public void setFinalIterMarker(boolean myFinalIterMarker) {
    }

    @Override
    public void addFactors(int[] factors) {
    }

    @Override
    public void setColumnTypes(String[] types) {
    }

    @Override
    public void addFactors(String[] names) {
    }

    @Override
    public void updateProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        } else if (progress > 100) {
            progress = 100;
        }
        this.fireProgress(progress);
    }

    @Override
    public void setVarCompEst(String value) {
        if (value.equalsIgnoreCase("P3D")) {
            this.useP3D = true;
        } else if (value.equalsIgnoreCase("EachMarker")) {
            this.useP3D = false;
        } else {
            throw new IllegalArgumentException("MLMPlugin: setVarCompEst: don't know how to handle value: " + value);
        }
    }

    public void setCompressionType(CompressionType type) {
        this.compressionType = type;
    }

    @Override
    public boolean isWriteOutputToFile() {
        return this.writeOutputToFile;
    }

    @Override
    public void setWriteOutputToFile(boolean writeOutputToFile) {
        this.writeOutputToFile = writeOutputToFile;
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public void setOutputName(String outputName) {
        this.outputName = outputName;
        this.writeOutputToFile = true;
    }

    @Override
    public boolean isFilterOutput() {
        return this.filterOutput;
    }

    @Override
    public void setFilterOutput(boolean filterOutput) {
        this.filterOutput = filterOutput;
    }

    @Override
    public double getMaxp() {
        return this.maxp;
    }

    @Override
    public void setMaxp(double maxp) {
        this.maxp = maxp;
        this.filterOutput = true;
    }

    @Override
    public double getCustomCompression() {
        return this.compression;
    }

    @Override
    public void setCustomCompression(double value) {
        this.compression = value;
    }

    @Override
    public void useGenotypeCalls() {
        this.useGenotype = true;
        this.useRefProb = false;
        this.useAlleleProb = false;
    }

    @Override
    public void useReferenceProbability() {
        this.useGenotype = false;
        this.useRefProb = true;
        this.useAlleleProb = false;
    }

    @Override
    public void useAlleleProbabilities() {
        this.useGenotype = false;
        this.useRefProb = false;
        this.useAlleleProb = true;
    }

    @Override
    public String getCitation() {
        return "Shang Xue, Zachary Miller, Janu Verma,  First Annual Tassel Hackathon";
    }

    public static enum CompressionType {
        Optimum,
        Custom,
        None;

    }
}

