/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.avro;

import java.io.File;
import net.maizegenetics.analysis.avro.AvroConstants;
import net.maizegenetics.analysis.avro.GenericRecordGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.log4j.Logger;

public class ExportAvro {
    private static final Logger myLogger = Logger.getLogger(ExportAvro.class);

    private ExportAvro() {
    }

    public static String write(GenotypeTable genotype, String filename) {
        filename = Utils.addSuffixIfNeeded(filename, ".avro");
        try {
            int numTaxa = genotype.numberOfTaxa();
            int numSites = genotype.numberOfSites();
            SchemaBuilder.FieldAssembler genotypeSchemaBuilder = SchemaBuilder.builder((String)"net.maizegenetics").record("genotype").fields();
            for (int s = 0; s < numSites; s += 256) {
                for (int t = 0; t < numTaxa; t += 256) {
                    genotypeSchemaBuilder = genotypeSchemaBuilder.name(AvroConstants.getKey(t, s)).type(AvroConstants.BYTE_BLOCK_SCHEMA).noDefault();
                }
            }
            Schema genotypeSchema = (Schema)genotypeSchemaBuilder.endRecord();
            Schema tasselSchema = (Schema)SchemaBuilder.builder((String)"net.maizegenetics").record("tassel").fields().name("taxa").type(AvroConstants.TAXA_SCHEMA).noDefault().name("positions").type(AvroConstants.POSITIONS_SCHEMA).noDefault().name("genotype").type(genotypeSchema).noDefault().endRecord();
            GenericDatumWriter datumWriter = new GenericDatumWriter(tasselSchema);
            try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
                dataFileWriter.setCodec(CodecFactory.snappyCodec());
                dataFileWriter.create(tasselSchema, new File(filename));
                dataFileWriter.append((Object)new GenericRecordGenotypeTable(tasselSchema, genotype));
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("ExportAvro: write: problem writing file: " + filename + ". " + e.getMessage());
        }
        return filename;
    }

    public static void main(String[] args) {
        LoggingUtils.setupDebugLogging();
        GenotypeTable genotype = ImportUtils.read("mdp_genotype.hmp.txt");
        ExportAvro.write(genotype, "test");
    }
}

