/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.avro;

import java.util.HashMap;
import java.util.Map;
import net.maizegenetics.analysis.avro.AvroConstants;
import net.maizegenetics.analysis.avro.GenericMapAnnotations;
import net.maizegenetics.dna.map.Chromosome;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordChromosome
implements GenericRecord {
    private static Map<Chromosome, GenericRecordChromosome> INSTANCES = new HashMap<Chromosome, GenericRecordChromosome>();
    private final Chromosome myChromosome;

    private GenericRecordChromosome(Chromosome chromosome) {
        this.myChromosome = chromosome;
    }

    public static GenericRecordChromosome getInstance(Chromosome chromosome) {
        GenericRecordChromosome result = INSTANCES.get(chromosome);
        if (result == null) {
            result = new GenericRecordChromosome(chromosome);
            INSTANCES.put(chromosome, result);
        }
        return result;
    }

    public void put(String arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(String key) {
        if (key.equals(AvroConstants.CHROMOSOME_INDICES.name.name())) {
            return this.myChromosome.getName();
        }
        if (key.equals(AvroConstants.CHROMOSOME_INDICES.annotations.name())) {
            return new GenericMapAnnotations(this.myChromosome.getAnnotation());
        }
        throw new IllegalArgumentException("GenericRecordChromosome: get: unknown key: " + key);
    }

    public void put(int arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(int i) {
        return this.get(AvroConstants.CHROMOSOME_INDICES.values()[i].name());
    }

    public Schema getSchema() {
        return AvroConstants.CHROMOSOME_SCHEMA;
    }
}

