/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.avro;

import java.io.File;
import java.nio.ByteBuffer;
import net.maizegenetics.analysis.avro.AvroConstants;
import net.maizegenetics.dna.snp.GenotypeTable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;

public class GenericRecordGenotype
implements GenericRecord {
    private final Schema myGenotypeSchema;
    private final GenotypeTable myGenotype;
    private final int myNumTaxa;
    private final int myNumSites;
    private final int myNumTaxaBlocks;

    public GenericRecordGenotype(Schema genotypeSchema, GenotypeTable genotype) {
        this.myGenotypeSchema = genotypeSchema;
        this.myGenotype = genotype;
        this.myNumTaxa = this.myGenotype.numberOfTaxa();
        this.myNumSites = this.myGenotype.numberOfSites();
        int temp = this.myNumTaxa / 256;
        this.myNumTaxaBlocks = this.myNumTaxa % 256 == 0 ? temp : temp + 1;
    }

    public void put(String arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(String key) {
        System.out.println("GenericRecordGenotype: get: key: " + key);
        int[] taxonSite = AvroConstants.getTaxonSiteFromKey(key);
        int tSize = Math.min(256, this.myNumTaxa - taxonSite[0]);
        int sSize = Math.min(256, this.myNumSites - taxonSite[1]);
        System.out.println("tSize: " + tSize + "  sSize: " + sSize + "   taxon: " + taxonSite[0] + "  site: " + taxonSite[1]);
        GenericData.Array result = new GenericData.Array(sSize, AvroConstants.BYTE_BLOCK_SCHEMA);
        for (int s = 0; s < sSize; ++s) {
            byte[] genotype = this.myGenotype.genotypeAllTaxa(taxonSite[1] + s);
            ByteBuffer temp = ByteBuffer.allocateDirect(tSize);
            temp.rewind();
            for (int t = 0; t < tSize; ++t) {
                temp.put(genotype[taxonSite[0] + t]);
            }
            temp.rewind();
            result.add((Object)temp);
        }
        return result;
    }

    public void put(int arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(int i) {
        System.out.println("GenericRecordGenotype: get: " + i);
        int siteBlock = i / this.myNumTaxaBlocks;
        int taxaBlock = i % this.myNumTaxaBlocks;
        long key = ((long)taxaBlock << 32) + (long)siteBlock;
        return this.get("B" + key);
    }

    public Schema getSchema() {
        return this.myGenotypeSchema;
    }

    public static void main(String[] args) {
        try {
            GenericDatumReader datumReader = new GenericDatumReader();
            DataFileReader reader = new DataFileReader(new File("tassel.avro"), (DatumReader)datumReader);
            GenericRecord temp = (GenericRecord)reader.next();
            GenericData.Array temp1 = (GenericData.Array)temp.get("B0");
            System.out.println("temp1: " + temp1.getClass().getName());
            System.out.println("temp1 get 0: " + ((ByteBuffer)temp1.get(0)).getClass().getName());
            System.out.println("temp1 size: " + temp1.size());
            System.out.println(((ByteBuffer)temp1.get(1)).array().length);
            ByteBuffer temp3 = (ByteBuffer)temp1.get(2);
            while (temp3.hasRemaining()) {
                System.out.print(temp3.get() + " ");
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

