/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.avro;

import net.maizegenetics.analysis.avro.AvroConstants;
import net.maizegenetics.analysis.avro.GenericArrayPositions;
import net.maizegenetics.analysis.avro.GenericArrayTaxa;
import net.maizegenetics.analysis.avro.GenericRecordGenotype;
import net.maizegenetics.dna.snp.GenotypeTable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordGenotypeTable
implements GenericRecord {
    private final Schema mySchema;
    private final GenotypeTable myTable;

    public GenericRecordGenotypeTable(Schema tasselSchema, GenotypeTable table) {
        this.mySchema = tasselSchema;
        this.myTable = table;
    }

    public void put(String arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(String key) {
        switch (key) {
            case "taxa": {
                return new GenericArrayTaxa(this.myTable.taxa());
            }
            case "positions": {
                return new GenericArrayPositions(this.myTable.positions());
            }
            case "genotype": {
                return new GenericRecordGenotype(this.mySchema.getField("genotype").schema(), this.myTable);
            }
        }
        throw new IllegalStateException("GenericRecordGenotypeTable: get: Unknown key: " + key);
    }

    public void put(int arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(int i) {
        return this.get(AvroConstants.GENOTYPE_TABLE_COMPONENTS.values()[i].name());
    }

    public Schema getSchema() {
        return this.mySchema;
    }
}

