/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.avro;

import net.maizegenetics.analysis.avro.AvroConstants;
import net.maizegenetics.analysis.avro.GenericMapAnnotations;
import net.maizegenetics.analysis.avro.GenericRecordChromosome;
import net.maizegenetics.dna.map.Position;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordPosition
implements GenericRecord {
    private final Position myPosition;

    public GenericRecordPosition(Position position) {
        this.myPosition = position;
    }

    public void put(String arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(String key) {
        if (key.equals(AvroConstants.POSITION_INDICES.chromosome.name())) {
            return GenericRecordChromosome.getInstance(this.myPosition.getChromosome());
        }
        if (key.equals(AvroConstants.POSITION_INDICES.position.name())) {
            return this.myPosition.getPosition();
        }
        if (key.equals(AvroConstants.POSITION_INDICES.snp_id.name())) {
            return this.myPosition.getSNPID();
        }
        if (key.equals(AvroConstants.POSITION_INDICES.annotations.name())) {
            return new GenericMapAnnotations(this.myPosition.getAnnotation());
        }
        throw new IllegalArgumentException("GenericRecordPosition: get: unknown key: " + key);
    }

    public void put(int arg0, Object arg1) {
        throw new UnsupportedOperationException("Not Mutable.");
    }

    public Object get(int i) {
        return this.get(AvroConstants.POSITION_INDICES.values()[i].name());
    }

    public Schema getSchema() {
        return AvroConstants.POSITION_SCHEMA;
    }
}

