/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.avro;

import java.util.HashMap;
import java.util.Map;
import net.maizegenetics.analysis.avro.AvroConstants;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GOBIIAvroGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotationStorage;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class ImportAvro {
    private static final Map<String, Chromosome> CHROMOSOMES = new HashMap<String, Chromosome>();

    private ImportAvro() {
    }

    public static GenotypeTable genotypeTable(GenericRecord genotypeTable) {
        TaxaList taxa = ImportAvro.taxa((GenericArray<GenericRecord>)((GenericArray)genotypeTable.get(AvroConstants.GENOTYPE_TABLE_COMPONENTS.taxa.name())));
        PositionList positions = ImportAvro.positions((GenericArray<GenericRecord>)((GenericArray)genotypeTable.get(AvroConstants.GENOTYPE_TABLE_COMPONENTS.positions.name())));
        GenotypeCallTable genotypes = ImportAvro.genotypeCallTable(taxa.numberOfTaxa(), positions.numberOfSites(), false, (GenericRecord)genotypeTable.get(AvroConstants.GENOTYPE_TABLE_COMPONENTS.genotype.name()));
        return GenotypeTableBuilder.getInstance(genotypes, positions, taxa, null, null, null, null, null);
    }

    private static GenotypeCallTable genotypeCallTable(int numTaxa, int numSites, boolean phased, GenericRecord genotypes) {
        return GOBIIAvroGenotypeCallTable.getInstance(numTaxa, numSites, phased, genotypes);
    }

    private static TaxaList taxa(GenericArray<GenericRecord> taxa) {
        TaxaListBuilder builder = new TaxaListBuilder();
        for (GenericRecord current : taxa) {
            builder.add(new Taxon(current.get(AvroConstants.TAXON_INDICES.name.name()).toString(), ImportAvro.annotations((Map)current.get(AvroConstants.TAXON_INDICES.annotations.name()))));
        }
        return builder.build();
    }

    private static PositionList positions(GenericArray<GenericRecord> positions) {
        PositionListBuilder builder = new PositionListBuilder();
        for (GenericRecord record : positions) {
            GeneralPosition.Builder current = new GeneralPosition.Builder(ImportAvro.chromosome((GenericRecord)record.get(AvroConstants.POSITION_INDICES.chromosome.name())), (Integer)record.get(AvroConstants.POSITION_INDICES.position.name())).snpName(record.get(AvroConstants.POSITION_INDICES.snp_id.name()).toString());
            ImportAvro.annotations((Map)record.get(AvroConstants.POSITION_INDICES.annotations.name()), current);
            builder.add(current.build());
        }
        return builder.build();
    }

    private static Chromosome chromosome(GenericRecord chromosome) {
        String name = chromosome.get(AvroConstants.CHROMOSOME_INDICES.name.name()).toString();
        Chromosome result = CHROMOSOMES.get(name);
        if (result == null) {
            result = Chromosome.instance(name, -1, ImportAvro.annotations((Map)chromosome.get(AvroConstants.CHROMOSOME_INDICES.annotations.name())));
            CHROMOSOMES.put(name, result);
        }
        return result;
    }

    private static void annotations(Map<Utf8, Utf8> annotations, GeneralPosition.Builder positionBuilder) {
        if (annotations.isEmpty()) {
            return;
        }
        for (Map.Entry<Utf8, Utf8> current : annotations.entrySet()) {
            String key = current.getKey().toString();
            if (key.equals("strand")) {
                positionBuilder.strand(current.getValue().toString());
                continue;
            }
            positionBuilder.addAnno(key, current.getValue());
        }
    }

    private static GeneralAnnotationStorage annotations(Map<Utf8, Utf8> annotations) {
        if (annotations.isEmpty()) {
            return null;
        }
        GeneralAnnotationStorage.Builder builder = GeneralAnnotationStorage.getBuilder();
        for (Map.Entry<Utf8, Utf8> current : annotations.entrySet()) {
            builder.addAnnotation(current.getKey().toString(), current.getValue().toString());
        }
        return builder.build();
    }
}

