/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.b4r;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.b4r.B4RPhenotypeUtils;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;

public class GetPhenotypeFromB4RPlugin
extends AbstractPlugin {
    private PluginParameter<String> myB4RDBName = new PluginParameter.Builder<String>("b4rdb", null, String.class).required(true).guiName("B4R Database Name").description("B4R Database Name").build();
    private PluginParameter<String> myB4RHost = new PluginParameter.Builder<String>("b4rhost", "localhost", String.class).guiName("B4R Host Name").description("B4R Host Name").build();
    private PluginParameter<String> myB4RUser = new PluginParameter.Builder<String>("b4ruser", null, String.class).required(true).guiName("B4R User").description("B4R User Name").build();
    private PluginParameter<String> myB4RPassword = new PluginParameter.Builder<String>("b4rpassword", "", String.class).guiName("B4R Password").description("Password").password().build();
    private PluginParameter<String> myStudyName = new PluginParameter.Builder<String>("studyName", "", String.class).description("Name of the study").guiName("Study Name").build();
    private PluginParameter<String> myTaxaName = new PluginParameter.Builder<String>("taxaName", "", String.class).description("Name of the taxa").guiName("Taxa Name").build();
    private PluginParameter<String> myVariableName = new PluginParameter.Builder<String>("varName", "", String.class).description("Name of the variable").guiName("Variable Name").build();

    public GetPhenotypeFromB4RPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        Phenotype result = null;
        try {
            result = B4RPhenotypeUtils.getPhenotypeFromB4RWithDuplicates(this.b4RHost(), this.b4RDBName(), this.b4RUser(), this.b4RPassword(), this.studyName(), this.taxaName(), this.variableName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create Phenotype Object");
        }
        if (result != null) {
            ArrayList<String> outputNameList = new ArrayList<String>();
            outputNameList.add("B4R_Phenotype");
            if (!this.myStudyName.value().equals("")) {
                outputNameList.add("Study_" + this.myStudyName.value());
            }
            if (!this.myTaxaName.value().equals("")) {
                outputNameList.add("Taxa_" + this.myTaxaName.value());
            }
            if (!this.myVariableName.value().equals("")) {
                outputNameList.add("Var_" + this.myVariableName.value());
            }
            String name = outputNameList.stream().collect(Collectors.joining("_"));
            Datum td = new Datum(name, result, null);
            DataSet tds = new DataSet(td, (Plugin)this);
            return tds;
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Phenotype From B4R";
    }

    @Override
    public String getToolTipText() {
        return "Pull a Study from B4R";
    }

    @Override
    public String getCitation() {
        return "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633\u00ad2635.";
    }

    public Phenotype runPlugin(DataSet input) {
        return (Phenotype)this.performFunction(input).getData(0).getData();
    }

    public String b4RDBName() {
        return this.myB4RDBName.value();
    }

    public GetPhenotypeFromB4RPlugin b4RDBName(String value) {
        this.myB4RDBName = new PluginParameter<String>(this.myB4RDBName, value);
        return this;
    }

    public String b4RHost() {
        return this.myB4RHost.value();
    }

    public GetPhenotypeFromB4RPlugin b4RHost(String value) {
        this.myB4RHost = new PluginParameter<String>(this.myB4RHost, value);
        return this;
    }

    public String b4RUser() {
        return this.myB4RUser.value();
    }

    public GetPhenotypeFromB4RPlugin b4RUser(String value) {
        this.myB4RUser = new PluginParameter<String>(this.myB4RUser, value);
        return this;
    }

    public String b4RPassword() {
        return this.myB4RPassword.value();
    }

    public GetPhenotypeFromB4RPlugin b4RPassword(String value) {
        this.myB4RPassword = new PluginParameter<String>(this.myB4RPassword, value);
        return this;
    }

    public String studyName() {
        return this.myStudyName.value();
    }

    public GetPhenotypeFromB4RPlugin studyName(String value) {
        this.myStudyName = new PluginParameter<String>(this.myStudyName, value);
        return this;
    }

    public String taxaName() {
        return this.myTaxaName.value();
    }

    public GetPhenotypeFromB4RPlugin taxaName(String value) {
        this.myTaxaName = new PluginParameter<String>(this.myTaxaName, value);
        return this;
    }

    public String variableName() {
        return this.myVariableName.value();
    }

    public GetPhenotypeFromB4RPlugin variableName(String value) {
        this.myVariableName = new PluginParameter<String>(this.myVariableName, value);
        return this;
    }
}

