/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.ManhattanDisplayPluginDialog;
import net.maizegenetics.analysis.chart.PlotOptionsDialog;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.util.TableReport;

public class ManhattanDisplayPlugin
extends AbstractDisplayPlugin {
    public ManhattanDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> tableInList = input.getDataOfType(TableReport.class);
            TableReport tableReport = this.findTableReportWithPValues(tableInList);
            if (tableReport == null) {
                String message = "Invalid selection.  Please select table with p values.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            if (this.isInteractive()) {
                try {
                    ArrayList<Integer> indexes = this.splitTable(tableReport);
                    String[] traits = this.getTraits(tableReport);
                    if (traits.length > 1) {
                        PlotOptionsDialog myOptions = new PlotOptionsDialog(this.getParentFrame(), this.getTraits(tableReport));
                        myOptions.setLocationRelativeTo(this.getParentFrame());
                        myOptions.setVisible(true);
                        if (!myOptions.isCanceled()) {
                            int index = myOptions.getTraitIndex();
                            ManhattanDisplayPluginDialog myDialog = new ManhattanDisplayPluginDialog(this.getParentFrame(), this, tableReport, indexes.get((index - 1) * 2), indexes.get((index - 1) * 2 + 1));
                            myDialog.setLocationRelativeTo(this.getParentFrame());
                            myDialog.setVisible(true);
                        }
                    } else if (traits.length == 1) {
                        ManhattanDisplayPluginDialog myDialog = new ManhattanDisplayPluginDialog(this.getParentFrame(), this, tableReport, indexes.get(0), indexes.get(1));
                        myDialog.setLocationRelativeTo(this.getParentFrame());
                        myDialog.setVisible(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to create Manhattan plot " + ex);
                }
                catch (Error er) {
                    er.printStackTrace();
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to create Manhattan plot " + er);
                }
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private TableReport findTableReportWithPValues(List<Datum> tableInList) {
        for (Datum current : tableInList) {
            Object[] headings;
            for (Object currentHeading : headings = ((TableReport)current.getData()).getTableColumnNames()) {
                if (!currentHeading.toString().equals("p")) continue;
                return (TableReport)current.getData();
            }
        }
        return null;
    }

    private ArrayList<Integer> splitTable(TableReport table) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int numRows = (int)table.getRowCount();
        String previousTrait = "";
        for (int i = 0; i < numRows; ++i) {
            if (previousTrait.equals((String)table.getValueAt(i, 0))) continue;
            if (!((String)table.getValueAt(i, 1)).equals("None")) {
                indexes.add(i);
                previousTrait = (String)table.getValueAt(i, 0);
                if (i <= 1) continue;
                indexes.add(i);
                continue;
            }
            if (i == 0) continue;
            indexes.add(i);
            indexes.add(i + 1);
            previousTrait = (String)table.getValueAt(i + 1, 0);
        }
        indexes.add(numRows);
        return indexes;
    }

    private String[] getTraits(TableReport table) {
        ArrayList<String> traitArray = new ArrayList<String>();
        int numRows = (int)table.getRowCount();
        String previousTrait = "";
        for (int i = 0; i < numRows; ++i) {
            if (previousTrait.equals((String)table.getValueAt(i, 0))) continue;
            previousTrait = (String)table.getValueAt(i, 0);
            traitArray.add(previousTrait);
        }
        String[] traits = new String[traitArray.size()];
        for (int i = 0; i < traitArray.size(); ++i) {
            traits[i] = (String)traitArray.get(i);
        }
        return traits;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = ManhattanDisplayPlugin.class.getResource("/net/maizegenetics/analysis/images/ManhattanPlot.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Manhattan Plot";
    }

    @Override
    public String getToolTipText() {
        return "Display Manhattan Plot";
    }
}

