/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.maizegenetics.util.TableReport;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultTableXYDataset;

public class TableReportManhattanDataset
extends DefaultTableXYDataset {
    private String[] seriesNames;
    private int[] seriesOffsets;
    private String myTrait;
    private int numberYAxes = 0;
    private String[] myChromNames;
    private Object[] myColumnNames;
    private double[] myPValues;
    private double[] myLogPValues;
    private double myMaxLogValue;
    private long[] myPositions;
    private String[] myMarkers;
    private HashMap<Double, Integer> myLookupTable;
    private int myPValueColumnIndex = -1;
    private int myChromColumnIndex = -1;
    private int myPositionColumnIndex = -1;
    private int myMarkerColumnIndex = -1;
    private int myTraitColumnIndex = -1;
    private final int myNumRows;
    private final int myStartIndex;
    private final int myEndIndex;
    private final List<Long> myActualPositions = new ArrayList<Long>();

    public TableReportManhattanDataset(TableReport theTable, int start, int end) {
        this.myStartIndex = start;
        this.myEndIndex = end;
        this.myNumRows = this.myEndIndex - start;
        this.setTableReport(theTable);
    }

    public Range getDomainBounds(boolean includeInterval) {
        return new Range(this.getDomainLowerBound(includeInterval), this.getDomainUpperBound(includeInterval));
    }

    public double getDomainUpperBound(boolean includeInterval) {
        return this.myPositions[this.myNumRows - 1];
    }

    public double getDomainLowerBound(boolean includeInterval) {
        return this.myPositions[0];
    }

    public Range getRangeBounds() {
        return new Range(0.0, this.myMaxLogValue);
    }

    public int getItemCount(int parm1) {
        return this.seriesOffsets[parm1 + 1] - this.seriesOffsets[parm1];
    }

    public Number getX(int series, int item) {
        return this.myPositions[this.seriesOffsets[series] + item];
    }

    public int getSeriesCount() {
        return this.numberYAxes;
    }

    public Number getY(int series, int item) {
        return this.myLogPValues[this.seriesOffsets[series] + item];
    }

    public String getSeriesName(int series) {
        return this.seriesNames[series];
    }

    public String getSeriesKey(int series) {
        return this.seriesNames[series];
    }

    public String getXName() {
        return "Position";
    }

    public List<Long> getActualPostions() {
        return this.myActualPositions;
    }

    private void setTraitColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Trait")) continue;
            this.myTraitColumnIndex = i;
            return;
        }
    }

    private void setPValueColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("p")) continue;
            this.myPValueColumnIndex = i;
            return;
        }
        throw new IllegalArgumentException("No P-values in selected data");
    }

    private void setChromColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Chr")) continue;
            this.myChromColumnIndex = i;
            return;
        }
        throw new IllegalArgumentException("No Chromosome names in selected data");
    }

    private void setMarkerColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Marker")) continue;
            this.myMarkerColumnIndex = i;
            return;
        }
    }

    private void setPositionColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Pos")) continue;
            this.myPositionColumnIndex = i;
            return;
        }
        throw new IllegalArgumentException("No positions in selected data");
    }

    private void setMarkers(TableReport myTableReport) {
        for (int i = 0; i < this.myMarkers.length; ++i) {
            this.myMarkers[i] = (String)myTableReport.getValueAt(this.myStartIndex + i, this.myMarkerColumnIndex);
        }
    }

    private void setPValues(TableReport myTableReport) {
        Object temp = myTableReport.getValueAt(this.myStartIndex, this.myPValueColumnIndex);
        if (temp instanceof Double) {
            for (int i = 0; i < this.myPValues.length; ++i) {
                this.myPValues[i] = (Double)myTableReport.getValueAt(this.myStartIndex + i, this.myPValueColumnIndex);
                if (this.myPValues[i] == 0.0) {
                    this.myPValues[i] = Double.MIN_VALUE;
                }
                this.myLookupTable.put(this.myPValues[i], i);
            }
        } else if (temp instanceof String) {
            for (int i = 0; i < this.myPValues.length; ++i) {
                this.myPValues[i] = Double.parseDouble((String)myTableReport.getValueAt(this.myStartIndex + i, this.myPValueColumnIndex));
                if (this.myPValues[i] == 0.0) {
                    this.myPValues[i] = Double.MIN_VALUE;
                }
                this.myLookupTable.put(this.myPValues[i], i);
            }
        } else {
            throw new IllegalStateException("TableReportManhattanDataset: setPValues: Unknown data type of P values: " + temp.getClass().getName());
        }
    }

    private void setPositions(TableReport myTableReport) {
        int i;
        long offset = 0L;
        int currentPosition = 0;
        int previousPosition = 0;
        String currentChrom = "";
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        boolean isNewChromosome = true;
        ArrayList<String> chromosomeNames = new ArrayList<String>();
        for (i = 0; i < this.myNumRows; ++i) {
            currentPosition = Integer.valueOf(myTableReport.getValueAt(this.myStartIndex + i, this.myPositionColumnIndex).toString());
            this.myChromNames[i] = myTableReport.getValueAt(this.myStartIndex + i, this.myChromColumnIndex).toString();
            if (!currentChrom.equals(this.myChromNames[i])) {
                ++this.numberYAxes;
                currentChrom = this.myChromNames[i];
                chromosomeNames.add(currentChrom);
                previousPosition = 0;
                offsets.add(i);
                isNewChromosome = true;
            }
            this.myPositions[i] = (long)(currentPosition - previousPosition) + offset;
            if (isNewChromosome) {
                this.myActualPositions.add(this.myPositions[i] - (long)currentPosition);
                isNewChromosome = false;
            }
            previousPosition = currentPosition;
            offset = this.myPositions[i];
        }
        offsets.add(this.myNumRows);
        this.seriesOffsets = new int[this.numberYAxes + 1];
        for (i = 0; i < this.numberYAxes + 1; ++i) {
            this.seriesOffsets[i] = (Integer)offsets.get(i);
        }
        this.seriesNames = new String[this.numberYAxes];
        chromosomeNames.toArray(this.seriesNames);
    }

    private void setTrait(TableReport table) {
        this.myTrait = (String)table.getValueAt(this.myStartIndex, this.myTraitColumnIndex);
    }

    public String getMarker(int series, int item) {
        return this.myMarkers[this.seriesOffsets[series] + item];
    }

    public String[] getChroms() {
        return this.myChromNames;
    }

    public String getTrait() {
        return this.myTrait;
    }

    private void setLogPValues() {
        for (int i = 0; i < this.myLogPValues.length; ++i) {
            this.myLogPValues[i] = -Math.log10(this.myPValues[i]);
            if (!(this.myLogPValues[i] > this.myMaxLogValue)) continue;
            this.myMaxLogValue = this.myLogPValues[i];
        }
    }

    public void setTableReport(TableReport theTable) {
        this.myColumnNames = theTable.getTableColumnNames();
        this.setPValueColumnIndex();
        this.setChromColumnIndex();
        this.setPositionColumnIndex();
        this.setMarkerColumnIndex();
        this.setTraitColumnIndex();
        this.myPValues = new double[this.myNumRows];
        this.myLogPValues = new double[this.myNumRows];
        this.myChromNames = new String[this.myNumRows];
        this.myPositions = new long[this.myNumRows];
        this.myMarkers = new String[this.myNumRows];
        this.myLookupTable = new HashMap(this.myNumRows);
        this.setPValues(theTable);
        this.setLogPValues();
        this.setPositions(theTable);
        this.setMarkers(theTable);
        this.setTrait(theTable);
    }
}

