/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.TableReportXYDataset;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataset;

public class XYScatterPanel
extends BasicChartPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    TableReportXYDataset dataset;
    TableReportXYDataset dataset2;
    ChartPanel chartPanel;
    TableReport theTable;
    JPanel controlPanel = new JPanel();
    JComboBox seriesXComboBox;
    JComboBox seriesY1ComboBox;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    String[] columnNames;
    JCheckBox lineChartCheckBox = new JCheckBox();
    JComboBox seriesY2ComboBox;
    JLabel jLabel3 = new JLabel();
    JCheckBox regressionCheckBox = new JCheckBox();
    JCheckBox multiYAxisCheckBox = new JCheckBox();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public XYScatterPanel(TableReport theTable) {
        this.theTable = theTable;
        try {
            Object[] colNames = theTable.getTableColumnNames();
            this.columnNames = new String[colNames.length + 1];
            this.columnNames[0] = "None";
            for (int i = 1; i < this.columnNames.length; ++i) {
                this.columnNames[i] = (String)colNames[i - 1];
            }
            this.dataset = null;
            this.chart = this.createChart(this.dataset, null, false, this.regressionCheckBox.isSelected());
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(500, 270));
            this.chartPanel.setMouseZoomable(true, false);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public XYScatterPanel(TableReport theTable, int seriesX, int seriesY1, int seriesY2, boolean isRegression) {
        this.theTable = theTable;
        try {
            this.dataset = this.createDataset(seriesX, seriesY1, seriesY2);
            this.dataset2 = null;
            this.chart = this.createChart(this.dataset, this.dataset2, false, isRegression);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(500, 270));
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.seriesY2ComboBox = new JComboBox<String>(this.columnNames);
        this.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("Y1");
        this.jLabel2.setText("X");
        this.seriesXComboBox = new JComboBox<String>(this.columnNames);
        this.seriesY1ComboBox = new JComboBox<String>(this.columnNames);
        this.seriesXComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterPanel.this.seriesXComboBox_actionPerformed(e);
            }
        });
        this.seriesY1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterPanel.this.seriesY1ComboBox_actionPerformed(e);
            }
        });
        this.lineChartCheckBox.setToolTipText("Connect scatter with a line");
        this.lineChartCheckBox.setText("Line");
        this.lineChartCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterPanel.this.lineChartCheckBox_actionPerformed(e);
            }
        });
        this.controlPanel.setMinimumSize(new Dimension(393, 50));
        this.controlPanel.setPreferredSize(new Dimension(393, 50));
        this.seriesY2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterPanel.this.seriesY2ComboBox_actionPerformed(e);
            }
        });
        this.jLabel3.setText("Y2");
        this.regressionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterPanel.this.regressionCheckBox_actionPerformed(e);
            }
        });
        this.regressionCheckBox.setToolTipText("Plot a linear regression line");
        this.regressionCheckBox.setText("Regression");
        this.seriesXComboBox.setToolTipText("Numerical variable for x-axis");
        this.seriesY1ComboBox.setToolTipText("Numerical variable for first Y");
        this.multiYAxisCheckBox.setText("2 Y Axes");
        this.multiYAxisCheckBox.setToolTipText("Plot Y2 on a second axis scaling");
        this.multiYAxisCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterPanel.this.multiYAxisCheckBox_actionPerformed(e);
            }
        });
        this.seriesY2ComboBox.setToolTipText("Numerical variable for optional second Y");
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)this.controlPanel, "North");
        this.controlPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 12, 1, 111), 26, -4));
        this.controlPanel.add((Component)this.lineChartCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 20, 1, 0), 0, -11));
        this.controlPanel.add((Component)this.seriesXComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 1, 0), 104, 0));
        this.controlPanel.add((Component)this.regressionCheckBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 1, 0), 2, -11));
        this.controlPanel.add((Component)this.multiYAxisCheckBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 1, 0), 4, -11));
        this.controlPanel.add((Component)this.seriesY1ComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 25, 0, 0), 104, 0));
        this.controlPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 6, 0, 99), 35, -4));
        this.controlPanel.add((Component)this.jLabel3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 11, 0, 34), 12, 0));
        this.controlPanel.add((Component)this.seriesY2ComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 29, 0, 0), 104, 0));
    }

    TableReportXYDataset createDataset(int seriesXColumn, int seriesY1Column, int seriesY2Column) {
        TableReportXYDataset dataset = seriesY2Column < 0 ? new TableReportXYDataset(this.theTable, seriesXColumn, seriesY1Column) : new TableReportXYDataset(this.theTable, seriesXColumn, seriesY1Column, seriesY2Column);
        return dataset;
    }

    JFreeChart createChart(TableReportXYDataset dataset, TableReportXYDataset dataset2, boolean lineChart, boolean isRegression) {
        String name = "Please select numeric variables";
        String xName = "X";
        String y1Name = "Y";
        String y2Name = "Y2";
        if (dataset != null) {
            xName = dataset.getXName();
            y1Name = dataset.getSeriesName(0);
            name = xName + " vs. " + y1Name;
            if (dataset.getSeriesCount() == 2) {
                y2Name = dataset.getSeriesName(1);
                name = name + " and " + y2Name;
            } else if (dataset2 != null) {
                y2Name = dataset2.getSeriesName(0);
                name = name + " and " + y2Name;
            }
        }
        this.chart = lineChart ? ChartFactory.createXYLineChart((String)name, (String)xName, (String)y1Name, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createScatterPlot((String)name, (String)xName, (String)y1Name, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().setForegroundAlpha(0.75f);
        if (dataset2 != null) {
            this.create2ndAxis(this.chart.getXYPlot(), (XYDataset)dataset2, 0, Color.BLUE, lineChart);
        }
        if (isRegression) {
            this.createRegression(this.chart.getXYPlot(), (XYDataset)dataset, 0, Color.RED);
            if (dataset.getSeriesCount() == 2) {
                this.createRegression(this.chart.getXYPlot(), (XYDataset)dataset, 1, Color.BLUE);
            }
            if (dataset2 != null) {
                this.createRegression(this.chart.getXYPlot(), (XYDataset)dataset2, 0, Color.BLUE);
            }
        }
        return this.chart;
    }

    private void create2ndAxis(XYPlot plot, XYDataset data, int series, Color theColor, boolean isLine) {
        NumberAxis axis2 = new NumberAxis((String)((Object)data.getSeriesKey(series)));
        axis2.setAutoRangeIncludesZero(false);
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setDataset(1, data);
        plot.mapDatasetToRangeAxis(1, 1);
        StandardXYItemRenderer renderer2 = isLine ? new StandardXYItemRenderer(2) : new StandardXYItemRenderer(1);
        renderer2.setSeriesPaint(0, (Paint)theColor);
        plot.setRenderer(1, (XYItemRenderer)renderer2);
    }

    private void createRegression(XYPlot plot, XYDataset data, int series, Color theColor) {
        double[] coefficients = Regression.getOLSRegression((XYDataset)data, (int)series);
        double max = DatasetUtilities.findMaximumDomainValue((XYDataset)data).doubleValue();
        double min = DatasetUtilities.findMinimumDomainValue((XYDataset)data).doubleValue();
        LineFunction2D curve = new LineFunction2D(coefficients[0], coefficients[1]);
        XYDataset regressionData = DatasetUtilities.sampleFunction2D((Function2D)curve, (double)min, (double)max, (int)100, (Comparable)((Object)(data.getSeriesKey(series) + " Fitted Reg. Line")));
        int datasetCount = plot.getDatasetCount();
        plot.setDataset(datasetCount, regressionData);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer(2);
        renderer2.setSeriesPaint(0, (Paint)theColor);
        plot.setRenderer(datasetCount, (XYItemRenderer)renderer2);
    }

    void updateChart() {
        int seriesX = this.seriesXComboBox.getSelectedIndex() - 1;
        int seriesY1 = this.seriesY1ComboBox.getSelectedIndex() - 1;
        int seriesY2 = this.seriesY2ComboBox.getSelectedIndex() - 1;
        boolean lineChart = this.lineChartCheckBox.isSelected();
        if (seriesX > -1 & seriesY1 > -1) {
            if (this.multiYAxisCheckBox.isSelected()) {
                this.dataset = this.createDataset(seriesX, seriesY1, -1);
                this.dataset2 = this.createDataset(seriesX, seriesY2, -1);
            } else {
                this.dataset = this.createDataset(seriesX, seriesY1, seriesY2);
                this.dataset2 = null;
            }
            this.chart = this.createChart(this.dataset, this.dataset2, lineChart, this.regressionCheckBox.isSelected());
            this.chartPanel.setChart(this.chart);
        }
    }

    void seriesXComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void seriesY1ComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void lineChartCheckBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void seriesY2ComboBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void regressionCheckBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    void multiYAxisCheckBox_actionPerformed(ActionEvent e) {
        this.updateChart();
    }

    @Override
    public JComponent getMainComponent() {
        return this.chartPanel;
    }
}

