/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class AddReferenceAlleleToHDF5Plugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(AddReferenceAlleleToHDF5Plugin.class);
    private PluginParameter<String> myInputGenotypes = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input HDF5 Genotype File").required(true).inFile().description("Input HDF5 genotype (*.h5) file to be annotated with the reference allele").build();
    private PluginParameter<String> myRefGenome = new PluginParameter.Builder<String>("ref", null, String.class).guiName("Reference Genome File").required(true).inFile().description("Reference genome file in fasta format").build();
    private PluginParameter<String> myRefGenomeVersion = new PluginParameter.Builder<String>("ver", null, String.class).guiName("Reference Genome Version").required(true).description("Version of the reference genome").build();
    private PluginParameter<String> myOutputGenotypes = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output HDF5 Genotype File").required(false).outFile().description("Output HDF5 genotype file annotated with the reference allele (Default: write to same folder as input, with '*.h5' replaced '*_withRef.h5')").build();
    private BufferedReader refReader = null;
    private PositionListBuilder newPosListBuilder = null;
    private Chromosome currChr = null;
    private int currPos = Integer.MIN_VALUE;
    private String contextSeq;
    private final boolean writePositions = false;

    public AddReferenceAlleleToHDF5Plugin() {
        super(null, false);
    }

    public AddReferenceAlleleToHDF5Plugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myOutputGenotypes.isEmpty()) {
            String outFile = new File(this.inputHDF5GenotypeFile()).getAbsolutePath().replaceFirst("\\.h5$", "_withRef.h5");
            this.outputHDF5GenotypeFile(outFile);
        }
        this.refReader = Utils.getBufferedReader(this.referenceGenomeFile());
    }

    @Override
    public DataSet processData(DataSet input) {
        String message = this.addRefAlleleToHDF5GenoTable();
        if (message != null) {
            myLogger.error((Object)message);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException(message);
        }
        try {
            this.refReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fireProgress(100);
        return null;
    }

    private String addRefAlleleToHDF5GenoTable() {
        String message = this.populatePositionsWithRefAllele();
        if (message != null) {
            return message;
        }
        PositionList newPos = this.newPosListBuilder.build();
        String genomeVer = newPos.hasReference() ? newPos.genomeVersion() : "unknown";
        myLogger.info((Object)("\nGenome version: " + genomeVer + "\n"));
        GenotypeTableBuilder newGenos = GenotypeTableBuilder.getTaxaIncremental(newPos, this.outputHDF5GenotypeFile());
        IHDF5Writer h5Reader = HDF5Factory.open((String)this.inputHDF5GenotypeFile());
        List<String> taxaNames = HDF5Utils.getAllTaxaNames((IHDF5Reader)h5Reader);
        int nTaxaWritten = 0;
        for (String taxonName : taxaNames) {
            Taxon taxon = HDF5Utils.getTaxon((IHDF5Reader)h5Reader, taxonName);
            byte[] genos = HDF5Utils.getHDF5GenotypesCalls((IHDF5Reader)h5Reader, taxonName);
            byte[][] depth = HDF5Utils.getHDF5GenotypesDepth((IHDF5Reader)h5Reader, taxonName);
            newGenos.addTaxon(taxon, genos, depth);
            if (++nTaxaWritten % 100 != 0) continue;
            myLogger.info((Object)("...finished writing genotypes and depth for " + nTaxaWritten + " taxa "));
        }
        newGenos.build();
        myLogger.info((Object)"\n\nFinished adding reference alleles to file:");
        myLogger.info((Object)("  " + this.outputHDF5GenotypeFile() + "\n\n"));
        return null;
    }

    private String populatePositionsWithRefAllele() {
        IHDF5Writer h5Writer = HDF5Factory.open((String)this.inputHDF5GenotypeFile());
        PositionList oldPosList = PositionListBuilder.getInstance((IHDF5Reader)h5Writer);
        this.newPosListBuilder = new PositionListBuilder();
        for (Position oldPos : oldPosList) {
            byte strand;
            int pos;
            Chromosome chr = oldPos.getChromosome();
            byte refAllele = this.retrieveRefAllele(chr, pos = oldPos.getPosition(), strand = oldPos.getStrand());
            if (refAllele == -128) {
                return "\nCould not find position " + pos + " on chromosome " + chr + " in the reference genome fasta file.\n\n\n";
            }
            GeneralPosition newPos = new GeneralPosition.Builder(oldPos).allele(WHICH_ALLELE.Reference, refAllele).build();
            this.newPosListBuilder.add(newPos);
        }
        this.newPosListBuilder.genomeVersion(this.referenceGenomeVersion());
        myLogger.info((Object)"Finished populating positions with RefAllele");
        return null;
    }

    private byte retrieveRefAllele(Chromosome chr, int pos, int strand) {
        this.findChrInRefGenomeFile(chr);
        char currChar = this.findPositionInRefGenomeFile(pos);
        if (this.currPos == pos) {
            byte refAllele = NucleotideAlignmentConstants.getNucleotideAlleleByte(currChar);
            if (strand == -1) {
                refAllele = NucleotideAlignmentConstants.getNucleotideComplement(refAllele);
            }
            return refAllele;
        }
        myLogger.warn((Object)("currPos:" + this.currPos));
        return -128;
    }

    private void findChrInRefGenomeFile(Chromosome chr) {
        String temp = "Nothing has been read from the reference genome fasta file yet";
        try {
            while (this.refReader.ready() && (this.currChr == null || this.currChr.compareTo(chr) < 0)) {
                temp = this.refReader.readLine().trim();
                if (temp.startsWith(">")) {
                    String chrS = temp.replace(">", "");
                    this.currChr = new Chromosome(chrS);
                    myLogger.info((Object)("\nCurrently reading chromosome " + this.currChr.getName() + " from reference genome fasta file\n\n"));
                }
                this.currPos = 0;
            }
        }
        catch (IOException e) {
            myLogger.error((Object)("Exception caught while reading the reference genome fasta file:\n  " + e + "\nLast line read:\n  " + temp));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            e.printStackTrace();
            throw new IllegalStateException("Problem reading reference genome file");
        }
        if (!this.currChr.equals(chr)) {
            myLogger.error((Object)("\nCould not find chromosome " + chr + " in the reference genome fasta file.\nMake sure that the chromosomes are in numerical order in that file\n\n\n"));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new IllegalStateException("Problem reading reference genome file: Make sure that the chromosomes are in numerical order");
        }
    }

    private char findPositionInRefGenomeFile(int pos) {
        char currChar = '\uffff';
        this.contextSeq = "";
        try {
            while (this.currPos < pos) {
                int intChar = this.refReader.read();
                if (intChar == -1) {
                    this.currPos = Integer.MAX_VALUE;
                    return '\uffff';
                }
                currChar = (char)intChar;
                if (Character.isWhitespace(currChar)) continue;
                ++this.currPos;
                if (pos - this.currPos >= 60) continue;
                this.contextSeq = this.contextSeq + currChar;
            }
        }
        catch (IOException e) {
            myLogger.error((Object)("\n\nError reading reference genome file:\n  " + e + "\n\n"));
            throw new IllegalStateException("Problem reading reference genome file");
        }
        return currChar;
    }

    private void writePosition(Position pos, String contextSeq) {
        myLogger.info((Object)(pos.getSNPID() + "\t" + pos.getChromosome().getChromosomeNumber() + "\t" + pos.getPosition() + "\t" + pos.getStrand() + "\t" + pos.getAllele(WHICH_ALLELE.GlobalMajor) + "\t" + pos.getAllele(WHICH_ALLELE.GlobalMinor) + "\t" + pos.getAllele(WHICH_ALLELE.Reference) + "\t" + pos.getGlobalMAF() + "\t" + pos.getGlobalSiteCoverage() + "\t" + contextSeq));
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Add reference allele";
    }

    @Override
    public String getToolTipText() {
        return "Add reference allele to HDF5 genotypes";
    }

    public String inputHDF5GenotypeFile() {
        return this.myInputGenotypes.value();
    }

    public AddReferenceAlleleToHDF5Plugin inputHDF5GenotypeFile(String value) {
        this.myInputGenotypes = new PluginParameter<String>(this.myInputGenotypes, value);
        return this;
    }

    public String referenceGenomeFile() {
        return this.myRefGenome.value();
    }

    public AddReferenceAlleleToHDF5Plugin referenceGenomeFile(String value) {
        this.myRefGenome = new PluginParameter<String>(this.myRefGenome, value);
        return this;
    }

    public String referenceGenomeVersion() {
        return this.myRefGenomeVersion.value();
    }

    public AddReferenceAlleleToHDF5Plugin referenceGenomeVersion(String value) {
        this.myRefGenomeVersion = new PluginParameter<String>(this.myRefGenomeVersion, value);
        return this;
    }

    public String outputHDF5GenotypeFile() {
        return this.myOutputGenotypes.value();
    }

    public AddReferenceAlleleToHDF5Plugin outputHDF5GenotypeFile(String value) {
        this.myOutputGenotypes = new PluginParameter<String>(this.myOutputGenotypes, value);
        return this;
    }
}

